/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ui.BaseForm;
import com.arsdigita.cms.ui.DataQueryOptionPrintListener;
import com.arsdigita.cms.ui.workflow.WorkflowRequestLocal;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.Task;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

class BaseTaskForm
extends BaseForm {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/BaseTaskForm.java#9 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$workflow$BaseTaskForm == null ? (class$com$arsdigita$cms$ui$workflow$BaseTaskForm = BaseTaskForm.class$("com.arsdigita.cms.ui.workflow.BaseTaskForm")) : class$com$arsdigita$cms$ui$workflow$BaseTaskForm));
    final WorkflowRequestLocal m_workflow;
    final TextField m_name;
    final TextArea m_description;
    final OptionGroup m_type;
    final OptionGroup m_deps;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$workflow$BaseTaskForm;

    BaseTaskForm(String key, GlobalizedMessage message, WorkflowRequestLocal workflow) {
        super(key, message);
        this.m_workflow = workflow;
        this.m_name = new BaseForm.Name("name", 200, true);
        this.addField(BaseTaskForm.gz("cms.ui.name"), (Component)this.m_name);
        this.m_type = new SingleSelect((ParameterModel)new BigDecimalParameter("task_type"));
        this.addField(BaseTaskForm.gz("cms.ui.workflow.task.type"), (Component)this.m_type);
        try {
            this.m_type.addPrintListener((PrintListener)new TaskTypePrintListener());
        }
        catch (TooManyListenersException tmle) {
            throw new UncheckedWrapperException((Throwable)tmle);
        }
        this.m_description = new BaseForm.Description("desc", 4000, true);
        this.addField(BaseTaskForm.gz("cms.ui.description"), (Component)this.m_description);
        this.m_deps = new CheckboxGroup("dep");
        this.addField(BaseTaskForm.gz("cms.ui.workflow.task.dependencies"), (Component)this.m_deps);
        this.addAction(new BaseForm.Finish());
        this.addAction(new BaseForm.Cancel());
        this.addSecurityListener("workflow_admin");
        this.addValidationListener(new ValidationListener());
    }

    final void processDependencies(Task t, String[] selectedDependencies) {
        Iterator iter = t.getDependencies();
        HashMap<BigDecimal, Task> toAdd = new HashMap<BigDecimal, Task>();
        HashMap<BigDecimal, Task> toRemove = new HashMap<BigDecimal, Task>();
        while (iter.hasNext()) {
            Task temp = (Task)iter.next();
            toRemove.put(temp.getID(), temp);
        }
        if (selectedDependencies != null) {
            for (int i = 0; i < selectedDependencies.length; ++i) {
                BigDecimal b = new BigDecimal(selectedDependencies[i]);
                Object addedTask = toRemove.remove(b);
                if (addedTask != null) continue;
                toAdd.put(b, new Task(b));
            }
        }
        iter = toRemove.values().iterator();
        while (iter.hasNext()) {
            t.removeDependency((Task)iter.next());
        }
        iter = toAdd.values().iterator();
        while (iter.hasNext()) {
            t.addDependency((Task)iter.next());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TaskTypePrintListener
    extends DataQueryOptionPrintListener {
        private TaskTypePrintListener() {
        }

        protected DataQuery getDataQuery(PageState s) {
            DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.workflow.getTaskTypes");
            query.addOrder("upper(name)");
            return query;
        }

        public String getKey(DataQuery d) {
            return d.get("Id").toString();
        }

        public String getValue(DataQuery d) {
            return (String)d.get("name");
        }
    }

    private class ValidationListener
    implements FormValidationListener {
        private ValidationListener() {
        }

        public final void validate(FormSectionEvent e) throws FormProcessException {
            String name = (String)BaseTaskForm.this.m_name.getValue(e.getPageState());
        }
    }
}

