/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.role;

import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.RootCategoryCollection;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Role;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RoleFactory {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/role/RoleFactory.java#7 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    public static final String CMS_ROLE_PRIVILEGES = "com.arsdigita.cms.getRolePrivileges";
    public static final String PRIVILEGE = "privilege";
    public static final String SORT_ORDER = "sortOrder";
    public static final String CMS_PRIVILEGES = "com.arsdigita.cms.getPrivileges";
    public static final String PRETTY_NAME = "prettyName";

    private static void createPrivileges(Role role, String[] privileges, ContentSection section) {
        if (privileges != null) {
            for (int i = 0; i < privileges.length; ++i) {
                String p = privileges[i];
                if (p.equals("cms_category_admin") || p.equals("cms_categorize_items")) {
                    RootCategoryCollection coll = Category.getRootCategories((ACSObject)section);
                    while (coll.next()) {
                        if (p.equals("cms_category_admin")) {
                            role.grantPermission((ACSObject)coll.getCategory(), PrivilegeDescriptor.ADMIN);
                            continue;
                        }
                        role.grantPermission((ACSObject)coll.getCategory(), Category.MAP_DESCRIPTOR);
                    }
                }
                role.grantPermission((ACSObject)section, PrivilegeDescriptor.get((String)p));
            }
        }
    }

    static void updatePrivileges(Role role, String[] privileges, ContentSection section) {
        Session session = SessionManager.getSession();
        DataQuery dq = session.retrieveQuery(CMS_ROLE_PRIVILEGES);
        Filter filter = dq.addFilter("granteeId = :granteeId");
        filter = dq.addFilter("objectId = :objectId");
        filter.set("granteeId", (Object)role.getGroup().getID());
        filter.set("objectId", (Object)section.getID());
        dq.addOrder(SORT_ORDER);
        List<String> lst = privileges == null ? Collections.EMPTY_LIST : Arrays.asList(privileges);
        ArrayList<String> newPrivs = new ArrayList<String>();
        while (dq.next()) {
            String priv = (String)dq.get(PRIVILEGE);
            if (lst.indexOf(priv) == -1) {
                role.revokePermission((ACSObject)section, PrivilegeDescriptor.get((String)priv));
                if (!priv.equals("cms_category_admin") && !priv.equals("cms_categorize_items")) continue;
                RootCategoryCollection coll = Category.getRootCategories((ACSObject)section);
                while (coll.next()) {
                    if (priv.equals("cms_category_admin")) {
                        role.revokePermission((ACSObject)coll.getCategory(), PrivilegeDescriptor.ADMIN);
                        continue;
                    }
                    role.revokePermission((ACSObject)coll.getCategory(), Category.MAP_DESCRIPTOR);
                }
                continue;
            }
            newPrivs.add(priv);
        }
        dq.close();
        RoleFactory.createPrivileges(role, privileges, section);
    }

    public static String[] getRolePrivileges(ContentSection section, Role role) {
        Group roleGroup = role.getGroup();
        DataQuery dq = RoleFactory.getRolePrivileges(section.getID(), roleGroup.getID());
        ArrayList<String> privs = new ArrayList<String>((int)dq.size());
        while (dq.next()) {
            privs.add((String)dq.get(PRIVILEGE));
        }
        dq.close();
        return privs.toArray(new String[0]);
    }

    public static DataQuery getRolePrivileges(BigDecimal sectionId, BigDecimal granteeId) {
        Session session = SessionManager.getSession();
        DataQuery dq = session.retrieveQuery(CMS_ROLE_PRIVILEGES);
        Filter filter = dq.addFilter("granteeId = :granteeId");
        filter = dq.addFilter("objectId = :objectId");
        filter.set("granteeId", (Object)granteeId);
        filter.set("objectId", (Object)sectionId);
        dq.addOrder(SORT_ORDER);
        return dq;
    }

    public static String getPrivilegeLabel(String privilege) {
        String result = null;
        DataQuery dq = SessionManager.getSession().retrieveQuery(CMS_PRIVILEGES);
        Filter f = dq.addFilter("privilege = :privilege");
        f.set(PRIVILEGE, (Object)privilege);
        if (!dq.next()) {
            throw new IllegalArgumentException("Failed to fetch pretty name for the CMS Privilege: " + privilege);
        }
        result = (String)dq.get(PRETTY_NAME);
        dq.close();
        return result;
    }
}

