/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.permissions;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ui.permissions.CMSPermissionsConstants;
import com.arsdigita.cms.ui.permissions.CMSPermissionsPane;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.util.StringUtils;

public class CMSUserSearchForm
extends Form
implements FormProcessListener,
CMSPermissionsConstants {
    private CMSPermissionsPane m_parent;
    private TextField m_search;

    public CMSUserSearchForm(CMSPermissionsPane parent) {
        this(CMSPermissionsConstants.DEFAULT_PRIVILEGES, parent);
    }

    public CMSUserSearchForm(PrivilegeDescriptor[] privs, CMSPermissionsPane parent) {
        super("RoleSearchUsers", (Container)new SimpleContainer());
        this.m_parent = parent;
        this.setMethod("post");
        this.addProcessListener(this);
        this.add((Component)new Label(CMSPermissionsConstants.SEARCH_LABEL));
        this.add((Component)new Label("&nbsp;", false));
        StringParameter searchParam = new StringParameter("query");
        this.m_search = new TextField((ParameterModel)searchParam);
        this.m_search.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        this.m_search.setSize(20);
        this.add((Component)this.m_search, 4);
        Submit submit = new Submit("submit");
        submit.setButtonLabel(CMSPermissionsConstants.SEARCH_BUTTON);
        this.add((Component)submit, 1);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        String search = (String)data.get((Object)"query");
        search = StringUtils.stripWhiteSpace((String)search);
        PartyCollection parties = Party.retrieveAllParties();
        parties.filter(search);
        if (parties.isEmpty()) {
            this.m_parent.showNoResults(state);
        } else {
            state.setValue(this.getSearchString(), data.get((Object)"query"));
            state.setValue(this.getPrivilegeModel(), (Object)this.getPrivileges());
            this.m_parent.showGrant(state);
        }
        parties.close();
    }

    private ParameterModel getSearchString() {
        return this.m_parent.getSearchString();
    }

    private ParameterModel getPrivilegeModel() {
        return this.m_parent.getPrivilegeParam();
    }

    private Object[] getPrivileges() {
        return this.m_parent.getPrivileges();
    }

    public TextField getSearchWidget() {
        return this.m_search;
    }
}

