/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.folder;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Image;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.DefaultTableColumnModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableHeader;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.folder.FolderManipulator;
import com.arsdigita.cms.ui.folder.FolderSelectionModel;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.FormatStandards;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.util.Date;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class FolderBrowser
extends Table {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/folder/FolderBrowser.java#21 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$folder$FolderBrowser == null ? (class$com$arsdigita$cms$ui$folder$FolderBrowser = FolderBrowser.class$("com.arsdigita.cms.ui.folder.FolderBrowser")) : class$com$arsdigita$cms$ui$folder$FolderBrowser));
    private static GlobalizedMessage[] s_headers = new GlobalizedMessage[]{FolderBrowser.globalize("cms.ui.folder.name"), FolderBrowser.globalize("cms.ui.folder.title"), FolderBrowser.globalize("cms.ui.folder.type"), FolderBrowser.globalize("cms.ui.folder.creation_date"), FolderBrowser.globalize("cms.ui.folder.last_modified"), FolderBrowser.globalize("cms.ui.folder.action"), FolderBrowser.globalize("cms.ui.folder.index")};
    private static GlobalizedMessage[] s_noIndexHeaders = new GlobalizedMessage[]{FolderBrowser.globalize("cms.ui.folder.name"), FolderBrowser.globalize("cms.ui.folder.title"), FolderBrowser.globalize("cms.ui.folder.type"), FolderBrowser.globalize("cms.ui.folder.creation_date"), FolderBrowser.globalize("cms.ui.folder.last_modified"), FolderBrowser.globalize("cms.ui.folder.action")};
    private static final String SORT_ACTION_UP = "sortActionUp";
    private static final String SORT_ACTION_DOWN = "sortActionDown";
    private FolderSelectionModel m_currentFolder;
    private TableActionListener m_folderChanger;
    private TableActionListener m_deleter;
    private TableActionListener m_indexChanger;
    private TableColumn m_nameColumn;
    private TableColumn m_deleteColumn;
    private TableColumn m_indexColumn;
    private static final String SORT_KEY_NAME = "name";
    private static final String SORT_KEY_TITLE = "title";
    private static final String SORT_KEY_LAST_MODIFIED_DATE = "lastModified";
    private static final String SORT_KEY_CREATION_DATE = "creationDate";
    private RequestLocal m_sortType = new RequestLocal(){

        public Object initialValue(PageState state) {
            return FolderBrowser.SORT_KEY_NAME;
        }
    };
    private final RequestLocal m_sortDirection = new RequestLocal(){

        public Object initialValue(PageState state) {
            return FolderBrowser.SORT_ACTION_UP;
        }
    };
    static /* synthetic */ Class class$com$arsdigita$cms$ui$folder$FolderBrowser;

    public FolderBrowser(FolderSelectionModel currentFolder) {
        this.setModelBuilder((TableModelBuilder)new FolderTableModelBuilder(currentFolder));
        this.setColumnModel((TableColumnModel)new DefaultTableColumnModel((Object[])(FolderBrowser.hideIndexColumn() ? s_noIndexHeaders : s_headers)));
        this.setHeader(new TableHeader(this.getColumnModel()));
        ((FolderTableModelBuilder)this.getModelBuilder()).setFolderBrowser(this);
        this.m_currentFolder = currentFolder;
        this.setClassAttr("dataTable");
        this.getHeader().setDefaultRenderer((TableCellRenderer)new com.arsdigita.cms.ui.util.DefaultTableCellRenderer());
        this.m_nameColumn = this.getColumn(0);
        this.m_nameColumn.setCellRenderer((TableCellRenderer)new NameCellRenderer());
        this.m_nameColumn.setHeaderRenderer((TableCellRenderer)new HeaderCellRenderer(SORT_KEY_NAME));
        this.getColumn(1).setHeaderRenderer((TableCellRenderer)new HeaderCellRenderer(SORT_KEY_TITLE));
        this.getColumn(3).setHeaderRenderer((TableCellRenderer)new HeaderCellRenderer(SORT_KEY_CREATION_DATE));
        this.getColumn(4).setHeaderRenderer((TableCellRenderer)new HeaderCellRenderer(SORT_KEY_LAST_MODIFIED_DATE));
        this.m_deleteColumn = this.getColumn(5);
        this.m_deleteColumn.setCellRenderer((TableCellRenderer)new ActionCellRenderer());
        this.m_deleteColumn.setAlign("center");
        if (!FolderBrowser.hideIndexColumn()) {
            this.m_indexColumn = this.getColumn(6);
            this.m_indexColumn.setCellRenderer((TableCellRenderer)new IndexToggleRenderer());
            this.m_indexColumn.setAlign("center");
            this.m_indexChanger = new IndexChanger(this.m_currentFolder);
            this.addTableActionListener(this.m_indexChanger);
        }
        this.m_folderChanger = new FolderChanger();
        this.addTableActionListener(this.m_folderChanger);
        this.m_deleter = new ItemDeleter();
        this.addTableActionListener(this.m_deleter);
        this.setEmptyView((Component)new Label(FolderBrowser.globalize("cms.ui.folder.no_items")));
        Assert.assertNotNull((Object)this.m_currentFolder.getStateParameter());
    }

    public void register(Page p) {
        super.register(p);
        p.addComponentStateParam((Component)this, this.m_currentFolder.getStateParameter());
        p.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                if (state.isVisibleOnPage((Component)FolderBrowser.this)) {
                    FolderBrowser.this.showHideFolderActions(state);
                }
            }
        });
    }

    private void showHideFolderActions(PageState state) {
        SecurityManager sm = Utilities.getSecurityManager(state);
        Folder folder = (Folder)this.m_currentFolder.getSelectedObject(state);
        Assert.assertNotNull((Object)folder);
        boolean canDelete = sm.canAccess(state.getRequest(), "delete_item", (ContentItem)folder);
        this.m_deleteColumn.setVisible(state, canDelete);
    }

    public void respond(PageState state) throws ServletException {
        String key = state.getControlEventName();
        String value = state.getControlEventValue();
        if (SORT_ACTION_UP.equals(key)) {
            this.m_sortType.set(state, (Object)value);
            this.m_sortDirection.set(state, (Object)SORT_ACTION_UP);
        } else if (SORT_ACTION_DOWN.equals(key)) {
            this.m_sortType.set(state, (Object)value);
            this.m_sortDirection.set(state, (Object)SORT_ACTION_DOWN);
        } else {
            super.respond(state);
        }
    }

    public FolderSelectionModel getFolderSelectionModel() {
        return this.m_currentFolder;
    }

    private static GlobalizedMessage globalize(String key) {
        return FolderManipulator.globalize(key);
    }

    private static boolean hideIndexColumn() {
        return ContentSection.getConfig().getHideFolderIndexCheckbox();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class IndexChanger
    extends TableActionAdapter {
        private FolderSelectionModel m_fol;

        public IndexChanger(FolderSelectionModel fol) {
            this.m_fol = fol;
        }

        public void cellSelected(TableActionEvent e) {
            PageState state = e.getPageState();
            BigDecimal rowkey = new BigDecimal((String)e.getRowKey());
            if (rowkey == null) {
                return;
            }
            try {
                ContentBundle contentItem = new ContentBundle(rowkey);
                Folder folder = (Folder)this.m_fol.getSelectedObject(state);
                ContentBundle currentIndexItem = folder.getIndexItem();
                if (currentIndexItem == null || currentIndexItem.getID().compareTo(contentItem.getID()) != 0) {
                    folder.setIndexItem(contentItem);
                } else {
                    folder.removeIndexItem();
                }
                folder.save();
            }
            catch (DataObjectNotFoundException donfe) {
                // empty catch block
            }
        }
    }

    private class FolderChanger
    extends TableActionAdapter {
        private FolderChanger() {
        }

        public void cellSelected(TableActionEvent e) {
            PageState s = e.getPageState();
            int col = e.getColumn();
            if (FolderBrowser.this.m_nameColumn != FolderBrowser.this.getColumn(col)) {
                return;
            }
            String key = (String)e.getRowKey();
            if (key.startsWith("-")) {
                FolderBrowser.this.clearSelection(s);
                FolderBrowser.this.getFolderSelectionModel().setSelectedKey(s, key.substring(1));
            }
        }
    }

    private static class FolderTableModel
    implements TableModel {
        private static final int NAME = 0;
        private static final int TITLE = 1;
        private static final int TYPE = 2;
        private static final int CREATION_DATE = 3;
        private static final int LAST_MODIFIED = 4;
        private static final int DELETABLE = 5;
        private static final int IS_INDEX = 6;
        private PageState m_state;
        private FolderBrowser m_table;
        private Folder.ItemCollection m_itemColl;
        private Folder m_fol;
        private BigDecimal m_folIndexID;

        public FolderTableModel(FolderBrowser table, PageState state, Folder.ItemCollection itemColl) {
            this.m_state = state;
            this.m_table = table;
            this.m_itemColl = itemColl;
            this.m_fol = (Folder)table.getFolderSelectionModel().getSelectedObject(state);
            if (!FolderBrowser.hideIndexColumn()) {
                ContentBundle indexItem = this.m_fol.getIndexItem();
                this.m_folIndexID = indexItem == null ? null : indexItem.getID();
            }
        }

        public int getColumnCount() {
            return FolderBrowser.hideIndexColumn() ? 6 : 7;
        }

        public boolean nextRow() {
            return this.m_itemColl.next();
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.m_itemColl;
                }
                case 1: {
                    return this.m_itemColl.getDisplayName();
                }
                case 2: {
                    return this.m_itemColl.getTypeLabel();
                }
                case 3: {
                    Date creationDate = this.m_itemColl.getCreationDate();
                    if (creationDate == null) {
                        return "--";
                    }
                    return FormatStandards.formatDate((Date)creationDate);
                }
                case 4: {
                    Date lastModified = this.m_itemColl.getLastModifiedDate();
                    if (lastModified == null) {
                        return "--";
                    }
                    return FormatStandards.formatDate((Date)lastModified);
                }
                case 5: {
                    return new Boolean(this.isDeletable());
                }
                case 6: {
                    if (FolderBrowser.hideIndexColumn()) {
                        throw new IndexOutOfBoundsException("Column index " + columnIndex + " not in table model.");
                    }
                    if (this.m_itemColl.isFolder()) {
                        return null;
                    }
                    if (this.m_folIndexID == null) {
                        return new Boolean(false);
                    }
                    return new Boolean(this.m_folIndexID.compareTo(this.m_itemColl.getBundleID()) == 0);
                }
            }
            throw new IndexOutOfBoundsException("Column index " + columnIndex + " not in table model.");
        }

        public boolean isDeletable() {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Checking to see if " + this + " is deletable"));
            }
            if (this.m_itemColl.isLive()) {
                s_log.debug((Object)"The item is live; it cannot be deleted");
                return false;
            }
            if (this.m_itemColl.isFolder()) {
                if (((Folder)this.m_itemColl.getContentItem()).isEmpty()) {
                    s_log.debug((Object)"The item is an empty folder; it may be deleted");
                    return true;
                }
                s_log.debug((Object)"The folder is not empty; it cannot be deleted");
                return false;
            }
            s_log.debug((Object)"The item is not a folder; it may be deleted");
            return true;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_itemColl.isFolder() ? this.m_itemColl.getID().negate() : this.m_itemColl.getBundleID();
        }
    }

    private class ItemDeleter
    extends TableActionAdapter {
        private ItemDeleter() {
        }

        public void cellSelected(TableActionEvent e) {
            int col = e.getColumn();
            if (FolderBrowser.this.m_deleteColumn != FolderBrowser.this.getColumn(col)) {
                return;
            }
            PageState s = e.getPageState();
            BigDecimal id = new BigDecimal(e.getRowKey().toString());
            OID oid = new OID("com.arsdigita.cms.ContentItem", (Object)id.abs());
            DomainObject item = DomainObjectFactory.newInstance((OID)oid);
            if (item != null) {
                if (item instanceof ContentBundle) {
                    ContentBundle bundle = (ContentBundle)item;
                    ItemCollection instances = bundle.getInstances();
                    while (instances.next()) {
                        instances.getContentItem().delete();
                    }
                }
                item.delete();
            }
            ((Table)e.getSource()).clearSelection(s);
        }
    }

    private final class IndexToggleRenderer
    implements TableCellRenderer {
        private IndexToggleRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (value == null) {
                return new Label(GlobalizationUtil.globalize("cms.ui.folder.na"));
            }
            ControlLink link = new ControlLink("");
            if (((Boolean)value).booleanValue()) {
                link.setClassAttr("checkBoxChecked");
            } else {
                link.setClassAttr("checkBoxUnchecked");
            }
            return link;
        }
    }

    private static class ActionCellRenderer
    implements TableCellRenderer {
        private static Label s_noAction = new Label("&nbsp;", false);
        private static ControlLink s_link;

        private ActionCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (((Boolean)value).booleanValue()) {
                return s_link;
            }
            return s_noAction;
        }

        static {
            s_noAction.lock();
            s_link = new ControlLink((Component)new Label(FolderBrowser.globalize("cms.ui.folder.delete")));
            s_link.setConfirmation("Permanently delete this item?");
        }
    }

    private class NameCellRenderer
    extends DefaultTableCellRenderer {
        public NameCellRenderer() {
            super(true);
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            Folder.ItemCollection coll = (Folder.ItemCollection)((Object)value);
            String name = coll.getName();
            if (coll.isFolder()) {
                return super.getComponent(table, state, (Object)name, isSelected, key, row, column);
            }
            ContentSection section = CMS.getContext().getContentSection();
            BigDecimal id = coll.getID();
            if (section == null) {
                return new Label(name);
            }
            ItemResolver resolver = section.getItemResolver();
            return new Link(name, resolver.generateItemURL(state, id, name, section, coll.getVersion()));
        }
    }

    private class HeaderCellRenderer
    extends com.arsdigita.cms.ui.util.DefaultTableCellRenderer {
        private String m_key;

        public HeaderCellRenderer(String key) {
            super(true);
            this.m_key = key;
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            String headerName = (String)((GlobalizedMessage)value).localize();
            String sortKey = (String)FolderBrowser.this.m_sortType.get(state);
            boolean isCurrentKey = sortKey.equals(this.m_key);
            String currentSortDirection = (String)FolderBrowser.this.m_sortDirection.get(state);
            String imageURLStub = null;
            imageURLStub = FolderBrowser.SORT_ACTION_UP.equals(currentSortDirection) ? "gray-triangle-up.gif" : "gray-triangle-down.gif";
            ControlLink cl = new ControlLink(this, headerName, currentSortDirection, isCurrentKey, table){
                private final /* synthetic */ String val$currentSortDirection;
                private final /* synthetic */ boolean val$isCurrentKey;
                private final /* synthetic */ Table val$table;
                private final /* synthetic */ HeaderCellRenderer this$1;
                {
                    this.this$1 = this$1;
                    this.val$currentSortDirection = val$currentSortDirection;
                    this.val$isCurrentKey = val$isCurrentKey;
                    this.val$table = val$table;
                }

                public void setControlEvent(PageState ps) {
                    String sortDirectionAction = null;
                    sortDirectionAction = "sortActionUp".equals(this.val$currentSortDirection) && this.val$isCurrentKey ? "sortActionDown" : "sortActionUp";
                    ps.setControlEvent((Component)this.val$table, sortDirectionAction, HeaderCellRenderer.access$700(this.this$1));
                }
            };
            Label l = new Label();
            l.setLabel("<font color=\"blue\">" + headerName + "</font>");
            l.setOutputEscaping(false);
            l.setFontWeight("b");
            SimpleContainer container = new SimpleContainer();
            container.add((Component)l);
            if (isCurrentKey) {
                Image image = new Image("/assets/" + imageURLStub);
                image.setBorder("0");
                container.add((Component)image);
            }
            cl.setChild((Component)container);
            return cl;
        }

        static /* synthetic */ String access$700(HeaderCellRenderer x0) {
            return x0.m_key;
        }
    }

    private class FolderTableModelBuilder
    extends AbstractTableModelBuilder
    implements PaginationModelBuilder {
        private FolderSelectionModel m_folder;
        private RequestLocal m_size;
        private RequestLocal m_itemColl;
        private FolderBrowser m_fb;

        public FolderTableModelBuilder(FolderSelectionModel sel) {
            this(sel, null);
        }

        public FolderTableModelBuilder(FolderSelectionModel sel, FolderBrowser fb) {
            this.m_folder = sel;
            this.m_size = new RequestLocal();
            this.m_itemColl = new RequestLocal();
            this.m_fb = fb;
        }

        public TableModel makeModel(Table t, PageState s) {
            FolderSelectionModel sel = ((FolderBrowser)t).getFolderSelectionModel();
            Folder f = (Folder)sel.getSelectedObject(s);
            if (f == null) {
                return Table.EMPTY_MODEL;
            }
            t.getRowSelectionModel().clearSelection(s);
            return new FolderTableModel((FolderBrowser)t, s, (Folder.ItemCollection)((Object)this.m_itemColl.get(s)));
        }

        public int getTotalSize(Paginator paginator, PageState state) {
            Integer size = (Integer)this.m_size.get(state);
            if (size == null) {
                Folder f = (Folder)this.m_folder.getSelectedObject(state);
                Folder.ItemCollection itemColl = f.getPrimaryInstances();
                if (itemColl == null) {
                    return 0;
                }
                size = new Integer((int)f.getPrimaryInstances().size());
                itemColl.setRange(new Integer(paginator.getFirst(state)), new Integer(paginator.getLast(state) + 1));
                String sortKey = (String)FolderBrowser.this.m_sortType.get(state);
                String direction = "asc";
                if (FolderBrowser.SORT_ACTION_DOWN.equals((String)FolderBrowser.this.m_sortDirection.get(state))) {
                    direction = "desc";
                }
                if (sortKey.equals(FolderBrowser.SORT_KEY_TITLE)) {
                    itemColl.setOrder("lower(item.displayName) " + direction);
                } else if (sortKey.equals(FolderBrowser.SORT_KEY_NAME)) {
                    itemColl.setOrder("lower(item.name) " + direction);
                } else if (sortKey.equals(FolderBrowser.SORT_KEY_LAST_MODIFIED_DATE)) {
                    itemColl.setOrder("lower(auditTrail.lastModifiedDate) " + direction);
                } else if (sortKey.equals(FolderBrowser.SORT_KEY_CREATION_DATE)) {
                    itemColl.setOrder("lower(auditTrail.creationDate) " + direction);
                }
                this.m_size.set(state, (Object)size);
                this.m_itemColl.set(state, (Object)itemColl);
            }
            return size;
        }

        public void setFolderBrowser(FolderBrowser fb) {
            this.m_fb = fb;
        }

        public boolean isVisible(PageState state) {
            return this.m_fb != null ? this.m_fb.isVisible(state) : true;
        }
    }
}

