/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.categorization.CategorizedCollection;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ui.BaseAdminPane;
import com.arsdigita.cms.ui.BaseDeleteForm;
import com.arsdigita.cms.ui.BaseTree;
import com.arsdigita.cms.ui.VisibilityComponent;
import com.arsdigita.cms.ui.category.AddUseContextForm;
import com.arsdigita.cms.ui.category.CategoryAddForm;
import com.arsdigita.cms.ui.category.CategoryEditForm;
import com.arsdigita.cms.ui.category.CategoryItemPane;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.cms.ui.category.CategoryTreeModelBuilder;
import com.arsdigita.cms.ui.category.CategoryUseContextModelBuilder;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.toolbox.ui.SelectionPanel;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public final class CategoryAdminPane
extends BaseAdminPane {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/category/CategoryAdminPane.java#13 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    public static final String CONTEXT_SELECTED = "sel_context";
    private static final String DEFAULT_USE_CONTEXT = CategoryUseContextModelBuilder.DEFAULT_USE_CONTEXT;
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$category$CategoryAdminPane == null ? (class$com$arsdigita$cms$ui$category$CategoryAdminPane = CategoryAdminPane.class$("com.arsdigita.cms.ui.category.CategoryAdminPane")) : class$com$arsdigita$cms$ui$category$CategoryAdminPane));
    private final SingleSelectionModel m_contextModel = new UseContextSelectionModel((ParameterModel)new StringParameter("sel_context"));
    private final Tree m_categoryTree;
    private final SingleSelectionModel m_model;
    private final CategoryRequestLocal m_parent;
    private final CategoryRequestLocal m_category;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$category$CategoryAdminPane;

    public CategoryAdminPane() {
        List list = new List((ListModelBuilder)new CategoryUseContextModelBuilder());
        list.setSelectionModel(this.m_contextModel);
        list.addChangeListener((ChangeListener)new ContextSelectionListener());
        this.m_categoryTree = new BaseTree(new CategoryTreeModelBuilder(this.m_contextModel));
        this.m_categoryTree.addChangeListener((ChangeListener)new SelectionPanel.SelectionListener((SelectionPanel)this));
        this.m_model = this.m_categoryTree.getSelectionModel();
        this.setSelectionModel(this.m_model);
        this.setSelector((Component)this.m_categoryTree);
        Section contextSection = new Section();
        contextSection.setHeading((Component)new Label(CategoryAdminPane.gz("cms.ui.category.use_contexts")));
        ActionGroup contextGroup = new ActionGroup();
        contextSection.setBody((Component)contextGroup);
        contextGroup.setSubject((Component)list);
        ActionLink addContextAction = new ActionLink((Component)new Label(CategoryAdminPane.gz("cms.ui.category.add_use_context")));
        AddUseContextForm addContextForm = new AddUseContextForm(this.m_contextModel);
        this.getBody().add((Component)addContextForm);
        this.getBody().connect(addContextAction, (FormSection)addContextForm);
        contextGroup.addAction((Component)new VisibilityComponent((Component)addContextAction, "category_admin"));
        Section categorySection = new Section();
        categorySection.setHeading((Component)new Label(CategoryAdminPane.gz("cms.ui.categories")));
        ActionGroup categoryGroup = new ActionGroup();
        categorySection.setBody((Component)categoryGroup);
        categoryGroup.setSubject((Component)this.m_categoryTree);
        SimpleContainer leftContainer = new SimpleContainer();
        leftContainer.add((Component)contextSection);
        leftContainer.add((Component)categorySection);
        this.setLeft((Component)leftContainer);
        this.m_parent = new ParentRequestLocal();
        this.m_category = new SelectionRequestLocal();
        this.setAdd(CategoryAdminPane.gz("cms.ui.category.add"), new CategoryAddForm(this.m_category, this.m_model));
        this.setEdit(CategoryAdminPane.gz("cms.ui.category.edit"), new CategoryEditForm(this.m_parent, this.m_category));
        this.setDelete(new DeleteLink(new Label(CategoryAdminPane.gz("cms.ui.category.delete"))), new DeleteForm(new SimpleContainer()));
        this.setIntroPane((Component)new Label(CategoryAdminPane.gz("cms.ui.category.intro")));
        this.setItemPane((Component)new CategoryItemPane(this.m_model, this.m_category, this.getAddLink(), this.getEditLink(), this.getDeleteLink()));
    }

    public void register(Page page) {
        super.register(page);
        page.addActionListener((ActionListener)new RootListener());
    }

    public String getUseContext(PageState state) {
        String selected = (String)this.m_contextModel.getSelectedKey(state);
        return DEFAULT_USE_CONTEXT.equals(selected) ? (String)null : selected;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ContextSelectionListener
    implements ChangeListener {
        public final void stateChanged(ChangeEvent e) {
            Category root;
            s_log.debug((Object)"Selection state changed; I may change the body's visible pane");
            PageState state = e.getPageState();
            CategoryAdminPane.this.getBody().reset(state);
            if (CategoryAdminPane.this.m_contextModel.isSelected(state) && (root = Category.getRootForObject((ACSObject)CMS.getContext().getContentSection(), (String)CategoryAdminPane.this.getUseContext(state))) != null) {
                CategoryAdminPane.this.m_model.setSelectedKey(state, (Object)root.getID());
            }
            if (CategoryAdminPane.this.m_model.isSelected(state)) {
                s_log.debug((Object)"The selection model is selected; displaying the item pane");
                CategoryAdminPane.this.getBody().push(state, CategoryAdminPane.this.getItemPane());
            }
        }
    }

    private class UseContextSelectionModel
    extends ParameterSingleSelectionModel {
        public UseContextSelectionModel(ParameterModel m) {
            super(m);
        }

        public Object getSelectedKey(PageState state) {
            Object val = super.getSelectedKey(state);
            if (val == null || ((String)val).length() == 0) {
                val = DEFAULT_USE_CONTEXT;
                state.setValue(this.getStateParameter(), val);
                this.fireStateChanged(state);
            }
            return val;
        }
    }

    private final class RootListener
    implements ActionListener {
        private RootListener() {
        }

        public final void actionPerformed(ActionEvent e) {
            Category root;
            PageState state = e.getPageState();
            if (!CategoryAdminPane.this.m_model.isSelected(state) && (root = Category.getRootForObject((ACSObject)CMS.getContext().getContentSection(), (String)CategoryAdminPane.this.getUseContext(state))) != null) {
                CategoryAdminPane.this.m_model.setSelectedKey(state, (Object)root.getID());
            }
        }
    }

    private final class ParentRequestLocal
    extends CategoryRequestLocal {
        private ParentRequestLocal() {
        }

        protected final Object initialValue(PageState state) {
            return CategoryAdminPane.this.m_category.getCategory(state).getDefaultParentCategory();
        }
    }

    private final class SelectionRequestLocal
    extends CategoryRequestLocal {
        private SelectionRequestLocal() {
        }

        protected final Object initialValue(PageState state) {
            String id = CategoryAdminPane.this.m_model.getSelectedKey(state).toString();
            if (id == null) {
                return null;
            }
            return new Category(new BigDecimal(id));
        }
    }

    private final class DeleteForm
    extends BaseDeleteForm {
        DeleteForm(SimpleContainer prompt) {
            super((Component)prompt);
            prompt.add((Component)new Label(DeleteForm.gz("cms.ui.category.delete_prompt")));
            Label catLabel = new Label();
            catLabel.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent pe) {
                    Label label = (Label)pe.getTarget();
                    Category cat = CategoryAdminPane.this.m_category.getCategory(pe.getPageState());
                    CategoryCollection descendants = cat.getDescendants();
                    long nDescendants = descendants.size() - 1L;
                    descendants.close();
                    CategorizedCollection descObjects = cat.getDescendantObjects();
                    long nDescObjects = descObjects.size();
                    descObjects.close();
                    StringBuffer sb = new StringBuffer(" ");
                    if (nDescendants > 0L) {
                        sb.append("This category has ");
                        sb.append(nDescendants);
                        sb.append(" descendant category(ies). ");
                    }
                    if (nDescObjects > 0L) {
                        sb.append("It has ").append(nDescObjects);
                        sb.append(" descendant object(s). ");
                    }
                    if (nDescendants > 0L || nDescObjects > 0L) {
                        sb.append("Descendants will be orphaned, if this category is removed.");
                    }
                    label.setLabel(sb.toString());
                }
            });
            prompt.add((Component)catLabel);
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            Category category = CategoryAdminPane.this.m_category.getCategory(state);
            if (category == null) {
                return;
            }
            PermissionService.assertPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.DELETE, (ACSObject)category, Kernel.getContext().getParty()));
            if (category.isRoot()) {
                Category root = Category.getRootForObject((ACSObject)CMS.getContext().getContentSection(), (String)CategoryAdminPane.this.getUseContext(state));
                if (category.equals((Object)root)) {
                    Category.clearRootForObject((ACSObject)CMS.getContext().getContentSection(), (String)CategoryAdminPane.this.getUseContext(state));
                }
                CategoryAdminPane.this.m_contextModel.setSelectedKey(state, (Object)DEFAULT_USE_CONTEXT);
            } else {
                Category parent = category.getDefaultParentCategory();
                CategoryAdminPane.this.m_model.setSelectedKey(state, (Object)parent.getID());
            }
            category.deleteCategoryAndOrphan();
        }
    }

    private final class DeleteLink
    extends ActionLink {
        private final Label m_alternativeLabel = new Label("Can't be deleted");

        DeleteLink(Label label) {
            super((Component)label);
        }

        public void generateXML(PageState state, Element parent) {
            boolean isDefaultContext;
            if (!this.isVisible(state)) {
                return;
            }
            Category cat = CategoryAdminPane.this.m_category.getCategory(state);
            String context = CategoryAdminPane.this.getUseContext(state);
            boolean bl = isDefaultContext = context == null || DEFAULT_USE_CONTEXT.equals(context);
            if (isDefaultContext && cat.isRoot()) {
                this.m_alternativeLabel.generateXML(state, parent);
            } else {
                super.generateXML(state, parent);
            }
        }
    }
}

