/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoringkit;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.AuthoringStep;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.type.ContentTypeRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class AddStep
extends Form
implements FormProcessListener,
FormInitListener {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoringkit/AddStep.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger((String)(class$com$arsdigita$cms$ui$authoringkit$AddStep == null ? (class$com$arsdigita$cms$ui$authoringkit$AddStep = AddStep.class$("com.arsdigita.cms.ui.authoringkit.AddStep")) : class$com$arsdigita$cms$ui$authoringkit$AddStep).getName());
    protected ContentTypeRequestLocal m_type;
    protected Hidden m_id;
    protected TextField m_ordering;
    protected TextField m_labelKey;
    protected TextField m_labelBundle;
    protected TextField m_component;
    protected TextField m_descriptionKey;
    protected TextField m_descriptionBundle;
    protected SaveCancelSection m_saveCancelSection;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$authoringkit$AddStep;

    public AddStep(ContentTypeRequestLocal type) {
        super("AuthoringStep");
        this.m_type = type;
        this.m_id = new Hidden((ParameterModel)new BigDecimalParameter("id"));
        this.add((Component)this.m_id);
        this.m_id.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoringkit.ordering")));
        this.m_ordering = new TextField((ParameterModel)new BigDecimalParameter("ordering"));
        this.m_ordering.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_ordering.setSize(5);
        this.add((Component)this.m_ordering);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoringkit.label_key")));
        this.m_labelKey = new TextField((ParameterModel)new StringParameter("labelKey"));
        this.m_labelKey.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_labelKey.setSize(40);
        this.m_labelKey.setMaxLength(1000);
        this.add((Component)this.m_labelKey);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoringkit.label_bundle")));
        this.m_labelBundle = new TextField((ParameterModel)new StringParameter("labelBundle"));
        this.m_labelBundle.setSize(40);
        this.m_labelBundle.setMaxLength(1000);
        this.add((Component)this.m_labelBundle);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoringkit.description_key")));
        this.m_descriptionKey = new TextField((ParameterModel)new StringParameter("descriptionKey"));
        this.m_descriptionKey.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_descriptionKey.setSize(40);
        this.m_descriptionKey.setMaxLength(1000);
        this.add((Component)this.m_descriptionKey);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoringkit.description_bundle")));
        this.m_descriptionBundle = new TextField((ParameterModel)new StringParameter("descriptionBundle"));
        this.m_descriptionBundle.setSize(40);
        this.m_descriptionBundle.setMaxLength(1000);
        this.add((Component)this.m_descriptionBundle);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoringkit.component")));
        this.m_component = new TextField((ParameterModel)new StringParameter("component"));
        this.m_component.setSize(40);
        this.m_component.setMaxLength(200);
        this.add((Component)this.m_component);
        this.m_saveCancelSection = new SaveCancelSection();
        this.add((Component)this.m_saveCancelSection, 66);
        this.addProcessListener(this);
        this.addInitListener(this);
        this.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                if (AddStep.this.isCancelled(state)) {
                    throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.cancel_hit").localize());
                }
            }
        });
    }

    public boolean isCancelled(PageState state) {
        return this.m_saveCancelSection.getCancelButton().isSelected(state);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        AuthoringStep step;
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        BigDecimal key = (BigDecimal)data.get((Object)this.m_id.getName());
        BigDecimal ordering = (BigDecimal)data.get((Object)this.m_ordering.getName());
        String labelKey = (String)data.get((Object)this.m_labelKey.getName());
        String labelBundle = (String)data.get((Object)this.m_labelBundle.getName());
        String descriptionKey = (String)data.get((Object)this.m_descriptionKey.getName());
        String descriptionBundle = (String)data.get((Object)this.m_descriptionBundle.getName());
        String component = (String)data.get((Object)this.m_component.getName());
        AuthoringKit kit = this.getKit(state);
        try {
            step = new AuthoringStep(key);
        }
        catch (DataObjectNotFoundException ex) {
            step = new AuthoringStep(SessionManager.getSession().create(new OID("com.arsdigita.cms.AuthoringStep", (Object)key)));
        }
        step.setLabel(null);
        step.setLabelKey(labelKey);
        step.setLabelBundle(labelBundle);
        step.setDescription(null);
        step.setDescriptionKey(descriptionKey);
        step.setDescriptionBundle(descriptionBundle);
        step.setComponent(component);
        step.save();
        kit.addStep(step, ordering);
        Utilities.refreshItemUI(state);
    }

    public void init(FormSectionEvent e) {
        FormData data = e.getFormData();
        try {
            if (data.get((Object)this.m_id.getName()) == null) {
                data.put((Object)this.m_id.getName(), (Object)Sequences.getNextValue());
            }
        }
        catch (SQLException s) {
            s_log.error((Object)"Could not generate Sequence ID", (Throwable)s);
            data.addError("Could not generate Sequence ID " + s.getMessage());
        }
    }

    protected AuthoringKit getKit(PageState state) {
        ContentType type = this.m_type.getContentType(state);
        try {
            return type.getAuthoringKit();
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException("Authoring kit not found");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

