/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PropertySheet;
import com.arsdigita.bebop.PropertySheetModel;
import com.arsdigita.bebop.PropertySheetModelBuilder;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.ui.authoring.TextAssetBodyLabelCellRenderer;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.util.LockableImpl;
import java.util.Iterator;

public class TextAssetBodyPropertySheet
extends DomainObjectPropertySheet {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoring/TextAssetBodyPropertySheet.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public TextAssetBodyPropertySheet(DomainObjectSelectionModel objModel) {
        super(objModel);
        this.setModelBuilder(new TMBAdapter(new DomainObjectModelBuilder()));
        this.getColumn(1).setCellRenderer((TableCellRenderer)new TextAssetBodyLabelCellRenderer());
    }

    private static class TableModelAdapter
    implements TableModel {
        private TextAssetBodyPropertiesModel m_model;
        private int m_row;

        public TableModelAdapter(TextAssetBodyPropertiesModel model) {
            this.m_model = model;
            this.m_row = -1;
        }

        public int getColumnCount() {
            return 2;
        }

        public boolean nextRow() {
            ++this.m_row;
            return this.m_model.nextRow();
        }

        public Object getElementAt(int columnIndex) {
            if (columnIndex == 0) {
                return this.m_model.getGlobalizedLabel();
            }
            return this.m_model.getObjectValue();
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_model.getAttribute();
        }

        public PropertySheetModel getPSModel() {
            return this.m_model;
        }
    }

    private static class TMBAdapter
    extends LockableImpl
    implements TableModelBuilder {
        private PropertySheetModelBuilder m_builder;

        public TMBAdapter(PropertySheetModelBuilder b) {
            this.m_builder = b;
        }

        public TableModel makeModel(Table t, PageState s) {
            return new TableModelAdapter((TextAssetBodyPropertiesModel)this.m_builder.makeModel((PropertySheet)t, s));
        }

        public void lock() {
            this.m_builder.lock();
            super.lock();
        }
    }

    private static class DomainObjectModelBuilder
    extends LockableImpl
    implements PropertySheetModelBuilder {
        private DomainObjectModelBuilder() {
        }

        public PropertySheetModel makeModel(PropertySheet sheet, PageState state) {
            TextAssetBodyPropertySheet s = (TextAssetBodyPropertySheet)sheet;
            return new TextAssetBodyPropertiesModel((TextAsset)s.getObjectSelectionModel().getSelectedObject(state), s.properties(), state);
        }
    }

    private static class TextAssetBodyPropertiesModel
    implements PropertySheetModel {
        public static final String MIME_TYPE_KEY = "mimeType.label";
        private TextAsset m_obj;
        private PageState m_state;
        private Iterator m_props;
        private DomainObjectPropertySheet.Property m_current;
        private static String ERROR = "No current property. Make sure that nextRow() was called at least once.";

        public TextAssetBodyPropertiesModel(TextAsset obj, Iterator props, PageState state) {
            this.m_obj = obj;
            this.m_props = props;
            this.m_state = state;
            this.m_current = null;
        }

        public boolean nextRow() {
            if (!this.m_props.hasNext()) {
                return false;
            }
            this.m_current = (DomainObjectPropertySheet.Property)this.m_props.next();
            return true;
        }

        public String getLabel() {
            return this.getGlobalizedLabel().getKey();
        }

        public GlobalizedMessage getGlobalizedLabel() {
            if (this.m_current == null) {
                throw new IllegalStateException(ERROR);
            }
            return this.m_current.getGlobalizedLabel();
        }

        public String getValue() {
            return this.getObjectValue().toString();
        }

        public Object getObjectValue() {
            if (this.m_current == null) {
                throw new IllegalStateException(ERROR);
            }
            if (("content".equals(this.m_current.getAttribute()) || MIME_TYPE_KEY.equals(this.m_current.getAttribute())) && this.m_obj != null && this.m_obj.getText() != null && this.m_obj.getMimeType() != null) {
                return this.m_obj;
            }
            return this.m_current.getFormatter().format((DomainObject)this.m_obj, this.m_current.getAttribute(), this.m_state);
        }

        public String getAttribute() {
            return this.m_current.getAttribute();
        }
    }
}

