/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.TooManyListenersException;

public abstract class PartyAddForm
extends SimpleContainer
implements FormInitListener,
FormProcessListener {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/PartyAddForm.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String SEARCH_QUERY = "searchQuery";
    private static final String PARTIES = "parties";
    private static final String SUBMIT = "addSubmit";
    private static final String CANCEL = "addCancel";
    private static final String SUBMIT_LABEL = "Add Members";
    private static final String DQ_PARTY_ID = "partyId";
    private static final String DQ_NAME = "name";
    private Widget m_search;
    private RequestLocal m_query;
    private CMSContainer m_noMatches;
    private CMSContainer m_matches;
    private Form m_form;
    private Hidden m_searchQuery;
    private CheckboxGroup m_parties;
    private Submit m_submit;
    private Submit m_cancel;

    private PartyAddForm() {
    }

    public PartyAddForm(Widget search) {
        this();
        this.m_search = search;
        this.m_query = new RequestLocal(){

            protected Object initialValue(PageState state) {
                return PartyAddForm.this.makeQuery(state);
            }
        };
        this.m_form = this.makeForm();
        Label title = new Label(GlobalizationUtil.globalize("cms.ui.matches"));
        title.setFontWeight("b");
        Label label = new Label(GlobalizationUtil.globalize("cms.ui.there_was_no_one_matching_the_search_criteria"));
        label.setFontWeight("em");
        this.m_noMatches = new CMSContainer();
        this.m_noMatches.add((Component)title);
        this.m_noMatches.add((Component)label);
        this.add((Component)this.m_noMatches);
        this.m_matches = new CMSContainer();
        this.m_matches.add((Component)title);
        this.m_matches.add((Component)this.m_form);
        this.add((Component)this.m_matches);
    }

    protected Form makeForm() {
        CMSForm form = new CMSForm("AddParties"){

            public final boolean isCancelled(PageState state) {
                return PartyAddForm.this.m_cancel.isSelected(state);
            }
        };
        this.m_searchQuery = new Hidden(SEARCH_QUERY);
        form.add((Component)this.m_searchQuery, 64);
        Label l = new Label("Check the box next to the name of the person(s) to assign to this role.");
        form.add((Component)l, 64);
        this.m_parties = new CheckboxGroup(PARTIES);
        this.m_parties.addValidationListener((ParameterListener)new NotNullValidationListener());
        try {
            this.m_parties.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent event) {
                    CheckboxGroup target = (CheckboxGroup)event.getTarget();
                    PageState state = event.getPageState();
                    FormData data = PartyAddForm.this.m_form.getFormData(state);
                    PartyAddForm.this.addParties(state, (OptionGroup)target);
                }
            });
        }
        catch (TooManyListenersException e) {
            UncheckedWrapperException.throwLoggedException(((Object)((Object)this)).getClass(), (String)"Too many listeners", (Throwable)e);
        }
        form.add((Component)this.m_parties, 64);
        SimpleContainer s = new SimpleContainer();
        this.m_submit = new Submit(SUBMIT, SUBMIT_LABEL);
        s.add((Component)this.m_submit);
        this.m_cancel = new Submit(CANCEL, "Cancel");
        s.add((Component)this.m_cancel);
        form.add((Component)s, 66);
        form.addInitListener(this);
        form.addProcessListener(this);
        return form;
    }

    public Form getForm() {
        return this.m_form;
    }

    protected Widget getSearchWidget() {
        return this.m_searchQuery;
    }

    public boolean isCancelled(PageState state) {
        return this.m_cancel.isSelected(state);
    }

    protected void addParties(PageState state, OptionGroup target) {
        DataQuery dq = (DataQuery)this.m_query.get(state);
        while (dq.next()) {
            BigDecimal partyId = (BigDecimal)dq.get(DQ_PARTY_ID);
            String name = (String)dq.get(DQ_NAME);
            target.addOption(new Option(partyId.toString(), name));
        }
    }

    protected abstract DataQuery makeQuery(PageState var1);

    public void init(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        this.m_searchQuery.setValue(state, this.m_search.getValue(state));
    }

    public abstract void process(FormSectionEvent var1) throws FormProcessException;

    public void generateXML(PageState state, Element parent) {
        DataQuery searchResults = (DataQuery)this.m_query.get(state);
        if (searchResults.size() > 0L) {
            this.m_matches.generateXML(state, parent);
        } else {
            this.m_noMatches.generateXML(state, parent);
        }
    }
}

