/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.ItemSearchPopup;
import com.arsdigita.cms.ui.folder.FolderManipulator;
import com.arsdigita.cms.ui.folder.FolderSelectionModel;
import com.arsdigita.cms.ui.util.DefaultTableCellRenderer;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ItemSearchFolderBrowser
extends Table {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ItemSearchFolderBrowser.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$ItemSearchFolderBrowser == null ? (class$com$arsdigita$cms$ui$ItemSearchFolderBrowser = ItemSearchFolderBrowser.class$("com.arsdigita.cms.ui.ItemSearchFolderBrowser")) : class$com$arsdigita$cms$ui$ItemSearchFolderBrowser));
    public static final int MAX_ROWS = 15;
    private static GlobalizedMessage[] s_headers = new GlobalizedMessage[]{ItemSearchFolderBrowser.globalize("cms.ui.folder.name"), ItemSearchFolderBrowser.globalize("cms.ui.folder.title"), ItemSearchFolderBrowser.globalize("cms.ui.folder.type")};
    private FolderSelectionModel m_currentFolder;
    private TableActionListener m_folderChanger;
    private TableActionListener m_deleter;
    private TableActionListener m_indexChanger;
    private TableColumn m_nameColumn;
    private Paginator m_paginator;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$ItemSearchFolderBrowser;

    public ItemSearchFolderBrowser(FolderSelectionModel currentFolder) {
        super((TableModelBuilder)((FolderTableModelBuilder)null), (Object[])s_headers);
        FolderTableModelBuilder builder = new FolderTableModelBuilder();
        this.setModelBuilder((TableModelBuilder)builder);
        this.m_paginator = new Paginator((PaginationModelBuilder)builder, 15);
        this.m_currentFolder = currentFolder;
        this.setClassAttr("dataTable");
        this.getHeader().setDefaultRenderer((TableCellRenderer)new DefaultTableCellRenderer());
        this.m_nameColumn = this.getColumn(0);
        this.m_nameColumn.setCellRenderer((TableCellRenderer)new NameCellRenderer());
        this.m_folderChanger = new FolderChanger();
        this.addTableActionListener(this.m_folderChanger);
        this.setEmptyView((Component)new Label(ItemSearchFolderBrowser.globalize("cms.ui.folder.no_items")));
        Assert.assertNotNull((Object)this.m_currentFolder.getStateParameter());
    }

    public Paginator getPaginator() {
        return this.m_paginator;
    }

    public void register(Page p) {
        super.register(p);
        p.addComponentStateParam((Component)this, this.m_currentFolder.getStateParameter());
        p.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ItemSearchFolderBrowser.this.showHideFolderActions(event.getPageState());
            }
        });
    }

    private Folder getCurrentFolder(PageState state) {
        return (Folder)this.m_currentFolder.getSelectedObject(state);
    }

    private void showHideFolderActions(PageState state) {
        SecurityManager sm = Utilities.getSecurityManager(state);
        Folder folder = this.getCurrentFolder(state);
        Assert.assertNotNull((Object)folder);
    }

    public FolderSelectionModel getFolderSelectionModel() {
        return this.m_currentFolder;
    }

    private static GlobalizedMessage globalize(String key) {
        return FolderManipulator.globalize(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FolderChanger
    extends TableActionAdapter {
        private FolderChanger() {
        }

        public void cellSelected(TableActionEvent e) {
            PageState s = e.getPageState();
            int col = e.getColumn();
            if (ItemSearchFolderBrowser.this.m_nameColumn != ItemSearchFolderBrowser.this.getColumn(col)) {
                return;
            }
            String key = (String)e.getRowKey();
            if (key.startsWith("-")) {
                ItemSearchFolderBrowser.this.clearSelection(s);
                ItemSearchFolderBrowser.this.getFolderSelectionModel().setSelectedKey(s, key.substring(1));
                ItemSearchFolderBrowser.this.m_paginator.reset(s);
            }
        }
    }

    private static class FolderTableModel
    implements TableModel {
        private static final int NAME = 0;
        private static final int TITLE = 1;
        private static final int TYPE = 2;
        private Folder.ItemCollection m_itemColl;

        public FolderTableModel(Folder.ItemCollection itemColl) {
            this.m_itemColl = itemColl;
        }

        public int getColumnCount() {
            return 3;
        }

        public boolean nextRow() {
            return this.m_itemColl != null ? this.m_itemColl.next() : false;
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.m_itemColl;
                }
                case 1: {
                    return this.m_itemColl.getDisplayName();
                }
                case 2: {
                    return this.m_itemColl.getTypeLabel();
                }
            }
            throw new IndexOutOfBoundsException("Column index " + columnIndex + " not in table model.");
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_itemColl.isFolder() ? this.m_itemColl.getID().negate() : this.m_itemColl.getID();
        }
    }

    private class NameCellRenderer
    extends com.arsdigita.bebop.table.DefaultTableCellRenderer {
        public NameCellRenderer() {
            super(true);
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            Folder.ItemCollection coll = (Folder.ItemCollection)((Object)value);
            String name = coll.getName();
            if (coll.isFolder()) {
                return super.getComponent(table, state, (Object)name, isSelected, key, row, column);
            }
            ContentSection section = CMS.getContext().getContentSection();
            BigDecimal id = (BigDecimal)key;
            if (section == null) {
                return new Label(name);
            }
            SimpleContainer container = new SimpleContainer();
            String widget = (String)state.getValue((ParameterModel)new StringParameter("widget"));
            boolean useURL = "true".equals(state.getValue((ParameterModel)new StringParameter("useURL")));
            String fillString = useURL ? ItemSearchPopup.getLiveItemURL(state.getRequest(), coll.getDomainObject().getOID()) : id + " (" + name + ")";
            Label js = new Label(this.generateJSLabel(id, widget, fillString), false);
            container.add((Component)js);
            String url = "#";
            Link link = new Link(name, url);
            link.setClassAttr("title");
            link.setOnClick("return fillItem" + id + "()");
            container.add((Component)link);
            return container;
        }

        private String generateJSLabel(BigDecimal id, String widget, String fill) {
            return " <script language=javascript>  <!-- \n function fillItem" + id + "() { \n" + " window.opener.document." + widget + ".value=\"" + fill + "\";\n" + " self.close(); \n" + " return false; \n" + " } \n" + " --> \n" + " </script> ";
        }
    }

    private class FolderTableModelBuilder
    extends AbstractTableModelBuilder
    implements PaginationModelBuilder {
        private RequestLocal m_size = new RequestLocal(this){
            private final /* synthetic */ FolderTableModelBuilder this$1;
            {
                this.this$1 = this$1;
            }

            protected Object initialValue(PageState state) {
                Folder.ItemCollection itemColl = FolderTableModelBuilder.access$300(this.this$1, state);
                if (null == itemColl) {
                    return new Integer(0);
                }
                return new Integer((int)itemColl.size());
            }
        };
        private RequestLocal m_itemColl = new RequestLocal(this){
            private final /* synthetic */ FolderTableModelBuilder this$1;
            {
                this.this$1 = this$1;
            }

            protected Object initialValue(PageState state) {
                Folder.ItemCollection itemColl = FolderTableModelBuilder.access$300(this.this$1, state);
                itemColl.addOrder("item.name");
                itemColl.setRange(new Integer(ItemSearchFolderBrowser.access$500(FolderTableModelBuilder.access$400(this.this$1)).getFirst(state)), new Integer(ItemSearchFolderBrowser.access$500(FolderTableModelBuilder.access$400(this.this$1)).getLast(state) + 1));
                return itemColl;
            }
        };

        private FolderTableModelBuilder() {
        }

        public TableModel makeModel(Table t, PageState s) {
            FolderSelectionModel sel = ((ItemSearchFolderBrowser)t).getFolderSelectionModel();
            Folder f = ItemSearchFolderBrowser.this.getCurrentFolder(s);
            if (s_log.isDebugEnabled()) {
                if (null == f) {
                    s_log.debug((Object)"Selected folder is null");
                } else {
                    s_log.debug((Object)("Selected folder: " + f.getLabel() + " " + f.getOID().toString()));
                }
            }
            if (f == null) {
                return Table.EMPTY_MODEL;
            }
            t.getRowSelectionModel().clearSelection(s);
            return new FolderTableModel((Folder.ItemCollection)((Object)this.m_itemColl.get(s)));
        }

        private Folder.ItemCollection getItemCollection(PageState state) {
            Folder f = ItemSearchFolderBrowser.this.getCurrentFolder(state);
            Folder.ItemCollection itemColl = f.getPrimaryInstances();
            if (null == itemColl) {
                return null;
            }
            BigDecimal singleTypeID = (BigDecimal)state.getValue((ParameterModel)new BigDecimalParameter("single_type"));
            if (singleTypeID != null) {
                itemColl.addEqualsFilter("type.id", singleTypeID);
            }
            itemColl.setOrder("isFolder desc");
            itemColl.addOrder("lower(item.name) ");
            return itemColl;
        }

        public int getTotalSize(Paginator paginator, PageState state) {
            Integer size = (Integer)this.m_size.get(state);
            return size;
        }

        public boolean isVisible(PageState state) {
            int size = (Integer)this.m_size.get(state);
            return ItemSearchFolderBrowser.this.isVisible(state) && size > 15;
        }

        static /* synthetic */ Folder.ItemCollection access$300(FolderTableModelBuilder x0, PageState x1) {
            return x0.getItemCollection(x1);
        }

        static /* synthetic */ ItemSearchFolderBrowser access$400(FolderTableModelBuilder x0) {
            return x0.ItemSearchFolderBrowser.this;
        }
    }
}

