/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.search;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.search.ContentTypeFilterSpecification;
import com.arsdigita.cms.search.VersionFilterSpecification;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.filters.DateRangeFilterSpecification;
import com.arsdigita.search.filters.PartyFilterSpecification;
import com.arsdigita.search.lucene.BaseQueryEngine;
import com.arsdigita.search.lucene.ObjectTypeFilter;
import com.arsdigita.search.lucene.PartyFilter;
import com.arsdigita.search.lucene.TypeSpecificFilter;
import com.arsdigita.search.lucene.UnionFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.lucene.search.DateFilter;
import org.apache.lucene.search.Filter;

public class LuceneQueryEngine
extends BaseQueryEngine {
    protected void addFilter(List list, FilterSpecification filter) {
        super.addFilter(list, filter);
        FilterType type = filter.getType();
        if ("contentType".equals(type.getKey())) {
            this.addContentTypeFilter(list, (ContentTypeFilterSpecification)filter);
        } else if ("version".equals(type.getKey())) {
            this.addVersionFilter(list, (VersionFilterSpecification)filter);
        } else if ("lastModifiedDate".equals(type.getKey())) {
            this.addDateRangeFilter(list, (DateRangeFilterSpecification)filter, "lastModifiedDate");
        } else if ("creationDate".equals(type.getKey())) {
            this.addDateRangeFilter(list, (DateRangeFilterSpecification)filter, "creationDate");
        } else if ("lastModifiedUser".equals(type.getKey())) {
            this.addPartyFilter(list, (PartyFilterSpecification)filter, "lastModifiedParty");
        } else if ("creationUser".equals(type.getKey())) {
            this.addPartyFilter(list, (PartyFilterSpecification)filter, "creationParty");
        }
    }

    protected void addDateRangeFilter(List list, DateRangeFilterSpecification filter, String paramName) {
        Date startDate = filter.getStartDate();
        Date endDate = filter.getEndDate();
        if (startDate != null && endDate != null) {
            list.add(new DateFilter(paramName, startDate, endDate));
        } else if (startDate != null) {
            list.add(DateFilter.After((String)paramName, (Date)startDate));
        } else if (endDate != null) {
            list.add(DateFilter.Before((String)paramName, (Date)startDate));
        }
    }

    protected void addPartyFilter(List list, PartyFilterSpecification filter, String filterType) {
        PartyCollection parties = filter.getParties();
        if (parties == null) {
            return;
        }
        ArrayList<PartyFilter> filters = new ArrayList<PartyFilter>();
        int count = 0;
        while (parties.next()) {
            filters.add(new PartyFilter(parties.getID(), filterType));
            ++count;
        }
        list.add(new UnionFilter(filters.toArray(new Filter[count])));
    }

    protected void addVersionFilter(List list, VersionFilterSpecification filter) {
        list.add(new TypeSpecificFilter(filter.getVersion()));
    }

    protected void addContentTypeFilter(List list, ContentTypeFilterSpecification filter) {
        ArrayList l = new ArrayList();
        ContentType[] types = filter.getTypes();
        if (types == null || types.length == 0) {
            return;
        }
        Filter[] filters = new Filter[types.length];
        for (int i = 0; i < types.length; ++i) {
            filters[i] = new ObjectTypeFilter(types[i].getAssociatedObjectType());
        }
        list.add(new UnionFilter(filters));
    }
}

