/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.LifecycleEvent;
import com.arsdigita.cms.lifecycle.LifecycleListener;
import com.arsdigita.cms.lifecycle.Phase;
import com.arsdigita.cms.lifecycle.SchedulerTask;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class Scheduler {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/lifecycle/Scheduler.java#19 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String CYCLE_ID = "cycleId";
    private static final String PHASE_ID = "phaseId";
    protected static long s_timerDelay;
    protected static long s_timerFrequency;
    private static Timer s_Timer;
    private static boolean s_running;
    private static Logger s_log;
    private static final LifecycleListener s_emptyListener;
    static /* synthetic */ Class class$com$arsdigita$cms$lifecycle$Scheduler;

    public static synchronized void startTimer() {
        if (s_Timer != null) {
            return;
        }
        s_Timer = new Timer(true);
        s_log.debug((Object)("Starting timer with timerDelay=" + s_timerDelay));
        s_Timer.schedule((TimerTask)new SchedulerTask(), s_timerDelay, s_timerFrequency);
    }

    public static synchronized void stopTimer() {
        if (s_Timer == null) {
            return;
        }
        s_Timer.cancel();
        s_Timer = null;
    }

    protected static synchronized void checkAndFire() {
        s_running = true;
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        Iterator i = Scheduler.getPendingEvents(Scheduler.getLifecycleStart(), 1, CYCLE_ID);
        txn.commitTxn();
        Scheduler.fireCycleEvents(i, true);
        txn.beginTxn();
        i = Scheduler.getPendingEvents(Scheduler.getPhaseStart(), 0, PHASE_ID);
        txn.commitTxn();
        Scheduler.firePhaseEvents(i, true);
        txn.beginTxn();
        i = Scheduler.getPendingEvents(Scheduler.getPhaseEnd(), 0, PHASE_ID);
        txn.commitTxn();
        Scheduler.firePhaseEvents(i, false);
        txn.beginTxn();
        i = Scheduler.getPendingEvents(Scheduler.getLifecycleEnd(), 1, CYCLE_ID);
        txn.commitTxn();
        Scheduler.fireCycleEvents(i, false);
        s_running = false;
    }

    private static synchronized LifecycleEvent getEvent(int eventType, DataQuery query) {
        BigDecimal objectId = (BigDecimal)query.get("objectId");
        String objectType = (String)query.get("objectType");
        Date startTime = (Date)query.get("startDateTime");
        Date endTime = (Date)query.get("endDateTime");
        return new LifecycleEvent(eventType, startTime, endTime, objectType, objectId);
    }

    private static synchronized LifecycleListener getListener(DataQuery query) {
        String listener = (String)query.get("listener");
        if (listener == null) {
            return s_emptyListener;
        }
        try {
            Class<?> listenerClass = Class.forName(listener);
            return (LifecycleListener)listenerClass.newInstance();
        }
        catch (Exception e) {
            s_log.error((Object)("Error in LifecycleEvent - getting listener: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static synchronized void run() {
        Session ssn = SessionManager.getSession();
        if (!s_running) {
            new KernelExcursion(){

                protected final void excurse() {
                    this.setEffectiveParty(Kernel.getSystemParty());
                    Scheduler.checkAndFire();
                }
            }.run();
        }
    }

    public static synchronized void runTest() {
        new KernelExcursion(){

            protected final void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                Scheduler.checkAndFire();
            }
        }.run();
    }

    protected static synchronized DataQuery getLifecycleStart() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.cms.getLifecycleStart");
        query.setParameter("startDateTime", (Object)new Date());
        return query;
    }

    protected static synchronized DataQuery getLifecycleEnd() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.cms.getLifecycleEnd");
        query.setParameter("endDateTime", (Object)new Date());
        return query;
    }

    protected static synchronized DataQuery getPhaseStart() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.cms.getPhaseStart");
        query.setParameter("startDateTime", (Object)new Date());
        return query;
    }

    protected static synchronized DataQuery getPhaseEnd() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.cms.getPhaseEnd");
        query.setParameter("endDateTime", (Object)new Date());
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Iterator getPendingEvents(DataQuery query, int eventType, String idColumn) {
        try {
            LinkedList<EventRow> rowList = new LinkedList<EventRow>();
            while (query.next()) {
                LifecycleEvent event = Scheduler.getEvent(eventType, query);
                LifecycleListener listener = Scheduler.getListener(query);
                if (listener == null) continue;
                BigDecimal id = (BigDecimal)query.get(idColumn);
                rowList.add(new EventRow(event, listener, id));
            }
            Iterator iterator = rowList.iterator();
            return iterator;
        }
        finally {
            query.close();
        }
    }

    private static synchronized void fireCycleEvents(Iterator events, boolean begin) {
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        while (events.hasNext()) {
            EventRow row = (EventRow)events.next();
            LifecycleEvent event = row.getEvent();
            LifecycleListener listener = row.getListener();
            BigDecimal id = row.getObjectID();
            Lifecycle cycle = null;
            txn.beginTxn();
            try {
                cycle = new Lifecycle(id);
            }
            catch (DataObjectNotFoundException e) {
                txn.abortTxn();
                throw new UncheckedWrapperException((String)GlobalizationUtil.globalize("cms.lifecycle.could_not_fetch_lifecycle").localize() + id, (Throwable)e);
            }
            try {
                if (begin) {
                    listener.begin(event);
                    cycle.setHasBegun(true);
                } else {
                    listener.end(event);
                    cycle.stop();
                }
                cycle.save();
                txn.commitTxn();
            }
            catch (Exception e) {
                txn.abortTxn();
                s_log.error((Object)("Error in LifecycleEvent: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static synchronized void firePhaseEvents(Iterator events, boolean begin) {
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        while (events.hasNext()) {
            EventRow row = (EventRow)events.next();
            LifecycleEvent event = row.getEvent();
            LifecycleListener listener = row.getListener();
            BigDecimal phaseID = row.getObjectID();
            Phase phase = null;
            txn.beginTxn();
            try {
                phase = new Phase(phaseID);
            }
            catch (DataObjectNotFoundException e) {
                txn.abortTxn();
                throw new UncheckedWrapperException((String)GlobalizationUtil.globalize("cms.lifecycle.could_not_fetch_phase").localize() + phaseID, (Throwable)e);
            }
            try {
                if (begin) {
                    listener.begin(event);
                    phase.setHasBegun(true);
                } else {
                    listener.end(event);
                    phase.stop();
                }
                phase.save();
                txn.commitTxn();
            }
            catch (Exception e) {
                txn.abortTxn();
                s_log.error((Object)("Error in LifecycleEvent: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_running = false;
        s_log = Logger.getLogger((String)(class$com$arsdigita$cms$lifecycle$Scheduler == null ? (class$com$arsdigita$cms$lifecycle$Scheduler = Scheduler.class$("com.arsdigita.cms.lifecycle.Scheduler")) : class$com$arsdigita$cms$lifecycle$Scheduler).getName());
        s_emptyListener = new LifecycleListener(){

            public void begin(LifecycleEvent e) {
            }

            public void end(LifecycleEvent e) {
            }
        };
    }

    private static class EventRow {
        private LifecycleEvent m_event;
        private LifecycleListener m_listener;
        private BigDecimal m_id;

        public EventRow(LifecycleEvent event, LifecycleListener listener, BigDecimal id) {
            this.m_event = event;
            this.m_listener = listener;
            this.m_id = id;
        }

        public LifecycleEvent getEvent() {
            return this.m_event;
        }

        public LifecycleListener getListener() {
            return this.m_listener;
        }

        public BigDecimal getObjectID() {
            return this.m_id;
        }
    }
}

