/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.installer;

import com.arsdigita.cms.installer.PageClassConfigHandler;
import com.arsdigita.cms.installer.ServiceInstaller;
import com.arsdigita.cms.installer.Util;
import com.arsdigita.cms.installer.WorkspaceInstaller;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.Stylesheet;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ContentCenterSetup {
    final String m_workspaceURL;
    final String m_contentCenterMap;
    private static HashMap s_pageClasses = new HashMap();
    private static HashMap s_pageURLs = new HashMap();
    private static final String SERVICE_URL = "cms-service";
    private static final String STYLESHEET = "/packages/content-section/xsl/cms.xsl";
    private static final String PACKAGE_KEY = "content-section";
    private static final String DISPATCHER_CLASS = "com.arsdigita.cms.dispatcher.ContentSectionDispatcher";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$installer$ContentSectionSetup == null ? (class$com$arsdigita$cms$installer$ContentSectionSetup = ContentCenterSetup.class$("com.arsdigita.cms.installer.ContentSectionSetup")) : class$com$arsdigita$cms$installer$ContentSectionSetup));
    static /* synthetic */ Class class$com$arsdigita$cms$installer$ContentSectionSetup;

    public ContentCenterSetup(String workspaceURL, String contentCenterMap) {
        this.m_contentCenterMap = contentCenterMap;
        this.m_workspaceURL = workspaceURL;
    }

    public static HashMap getURLToClassMap() {
        return s_pageClasses;
    }

    public static HashMap getClassToURLMap() {
        return s_pageURLs;
    }

    public void run() {
        ContentCenterSetup.setupCMSPackage();
        this.setupWorkspacePackage();
        ContentCenterSetup.setupServicePackage();
        this.setupContentCenter();
    }

    private static void setupCMSPackage() {
        if (!PackageType.typeExists((String)PACKAGE_KEY)) {
            s_log.info((Object)"Creating the CMS package type...");
            PackageType type = PackageType.create((String)PACKAGE_KEY, (String)"Content Management System", (String)"Content Management Systems", (String)"http://cms-java.arsdigita.com/");
            type.setDispatcherClass(DISPATCHER_CLASS);
            Stylesheet ss = Stylesheet.createStylesheet((String)STYLESHEET);
            ss.save();
            type.addStylesheet(ss);
            type.save();
            ContentCenterSetup.createPrivileges();
            s_log.info((Object)"Done creating the CMS package type.");
        }
    }

    private void setupWorkspacePackage() throws InitializationException {
        if (!PackageType.typeExists((String)new WorkspaceInstaller().getPackageKey())) {
            s_log.info((Object)"Initializing CMS Workspace...");
            Util.validateURLParameter("workspace", this.m_workspaceURL);
            WorkspaceInstaller workspaceInstaller = new WorkspaceInstaller();
            try {
                workspaceInstaller.createPackageType();
                PackageInstance instance = workspaceInstaller.createPackageInstance();
                workspaceInstaller.mountPackageInstance(instance, this.m_workspaceURL);
            }
            catch (DataObjectNotFoundException e) {
                throw new InitializationException("Failed to initialize the Workspace package: ", (Throwable)e);
            }
            s_log.info((Object)"Done initializing CMS Workspace.");
        }
    }

    private static void setupServicePackage() {
        if (!PackageType.typeExists((String)SERVICE_URL)) {
            String url = SERVICE_URL;
            try {
                ServiceInstaller.createPackageType();
                PackageInstance instance = ServiceInstaller.createPackageInstance();
                ServiceInstaller.mountPackageInstance(instance, url);
            }
            catch (DataObjectNotFoundException e) {
                throw new InitializationException("Failed to initialize CMS global services package: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createPrivileges() {
        String CMS_PRIVILEGES = "com.arsdigita.cms.getPrivileges";
        String PRIVILEGE = "privilege";
        DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.getPrivileges");
        try {
            while (dq.next()) {
                String privilege = (String)dq.get("privilege");
                if (PrivilegeDescriptor.get((String)privilege) != null) continue;
                PrivilegeDescriptor.createPrivilege((String)privilege);
            }
        }
        finally {
            dq.close();
        }
    }

    private void setupContentCenter() throws InitializationException {
        PageClassConfigHandler handler = new PageClassConfigHandler(s_pageClasses, s_pageURLs);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream input = loader.getResourceAsStream(this.m_contentCenterMap.substring(1));
        if (input == null) {
            throw new IllegalStateException(this.m_contentCenterMap + " not found");
        }
        InputSource source = new InputSource(input);
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser parser = spf.newSAXParser();
            parser.parse(source, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new UncheckedWrapperException("error parsing dispatcher config", (Throwable)e);
        }
        catch (SAXException e) {
            throw new UncheckedWrapperException("error parsing dispatcher config", (Throwable)e);
        }
        catch (IOException e) {
            throw new UncheckedWrapperException("error parsing dispatcher config", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

