/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.dispatcher.AbstractItemResolver;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.MasterPage;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.util.LanguageUtil;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class MultilingualItemResolver
extends AbstractItemResolver
implements ItemResolver {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/MultilingualItemResolver.java#19 $$Author: mbooth $$DateTime: 2004/04/16 09:58:42 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$dispatcher$MultilingualItemResolver == null ? (class$com$arsdigita$cms$dispatcher$MultilingualItemResolver = MultilingualItemResolver.class$("com.arsdigita.cms.dispatcher.MultilingualItemResolver")) : class$com$arsdigita$cms$dispatcher$MultilingualItemResolver));
    private static MasterPage s_masterP = null;
    private static final String ADMIN_PREFIX = "admin";
    protected static final String ITEM_ID = "item_id";
    protected static final String SEPARATOR = "&";
    static /* synthetic */ Class class$com$arsdigita$cms$dispatcher$MultilingualItemResolver;

    public MultilingualItemResolver() {
        s_log.debug((Object)"Undergoing creation");
    }

    /*
     * Enabled aggressive block sorting
     */
    public ContentItem getItem(ContentSection section, String url, String context) {
        block17: {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Resolving the item in content section " + (Object)((Object)section) + " at URL '" + url + "' for context " + context));
            }
            Assert.assertNotNull((Object)((Object)section), (String)"ContentSection section");
            Assert.assertNotNull((Object)url, (String)"String url");
            Assert.assertNotNull((Object)context, (String)"String context");
            Folder rootFolder = section.getRootFolder();
            url = this.stripTemplateFromURL(url);
            if (rootFolder == null) {
                s_log.debug((Object)"The root folder is null; returning no item");
            } else {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Using root folder " + rootFolder));
                }
                if ("live".equals(context)) {
                    s_log.debug((Object)"The use context is 'live'");
                    rootFolder = (Folder)rootFolder.getLiveVersion();
                    if (rootFolder == null) {
                        s_log.debug((Object)"The live version of the root folder is null; returning no item");
                        break block17;
                    } else {
                        s_log.debug((Object)"The root folder has a live version; recursing");
                        String prefix = section.getURL() + rootFolder.getPath();
                        if (url.startsWith(prefix)) {
                            if (s_log.isDebugEnabled()) {
                                s_log.debug((Object)("The URL starts with prefix '" + prefix + "'; removing it"));
                            }
                            url = url.substring(prefix.length());
                        }
                        ContentItem item = this.getItemFromLiveURL(url, rootFolder);
                        if (s_log.isDebugEnabled()) {
                            s_log.debug((Object)("Resolved URL '" + url + "' to item " + item));
                        }
                        return item;
                    }
                }
                if ("draft".equals(context)) {
                    s_log.debug((Object)"The use context is 'draft'");
                    if (Assert.isAssertEnabled()) {
                        Assert.assertTrue((url.indexOf(ITEM_ID) >= 0 ? 1 : 0) != 0, (String)"url must contain parameter item_id");
                    }
                    ContentItem item = this.getItemFromDraftURL(url);
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Resolved URL '" + url + "' to item " + item));
                    }
                    return item;
                }
                if (!"preview".equals(context)) {
                    throw new IllegalArgumentException("Invalid item resolver context " + context);
                }
                s_log.debug((Object)"The use context is 'preview'");
                String prefix = "preview/";
                if (url.startsWith("preview/")) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)"The URL starts with prefix 'preview/'; removing it");
                    }
                    url = url.substring("preview/".length());
                }
                ContentItem item = this.getItemFromLiveURL(url, rootFolder);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Resolved URL '" + url + "' to item " + item));
                }
                return item;
            }
        }
        s_log.debug((Object)"No item resolved; returning null");
        return null;
    }

    public String getCurrentContext(PageState state) {
        String sectionURL;
        s_log.debug((Object)"Getting the current context");
        String url = state.getRequest().getRequestURI();
        ContentSection section = CMS.getContext().getContentSection();
        if (section != null && url.startsWith(sectionURL = section.getURL())) {
            url = url.substring(sectionURL.length());
        }
        if ((url = this.stripTemplateFromURL(url)).startsWith(ADMIN_PREFIX) || url.startsWith(Utilities.getWorkspaceURL())) {
            return "draft";
        }
        return "live";
    }

    public String generateItemURL(PageState state, BigDecimal itemId, String name, ContentSection section, String context) {
        return this.generateItemURL(state, itemId, name, section, context, null);
    }

    public String generateItemURL(PageState state, BigDecimal itemId, String name, ContentSection section, String context, String templateContext) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Generating an item URL for item id " + itemId + ", section " + (Object)((Object)section) + ", and context '" + context + "' with name '" + name + "'"));
        }
        Assert.assertNotNull((Object)itemId, (String)"BigDecimal itemId");
        Assert.assertNotNull((Object)context, (String)"Sring context");
        Assert.assertNotNull((Object)((Object)section), (String)"ContentSection section");
        if ("draft".equals(context)) {
            return this.generateDraftURL(section, itemId);
        }
        if ("preview".equals(context)) {
            ContentItem item = new ContentItem(itemId);
            return this.generatePreviewURL(section, item, templateContext);
        }
        if ("live".equals(context)) {
            ContentItem item = new ContentItem(itemId);
            if (Assert.isAssertEnabled()) {
                Assert.assertNotNull((Object)item, (String)"item");
                Assert.assertTrue((boolean)"live".equals(item.getVersion()), (String)"Generating live URL; this item must be the live version");
            }
            return this.generateLiveURL(section, item, templateContext);
        }
        throw new IllegalArgumentException("Unknown context '" + context + "'");
    }

    public String generateItemURL(PageState state, ContentItem item, ContentSection section, String context) {
        return this.generateItemURL(state, item, section, context, null);
    }

    public String generateItemURL(PageState state, ContentItem item, ContentSection section, String context, String templateContext) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Generating an item URL for item " + item + ", section " + (Object)((Object)section) + ", and context " + context));
        }
        Assert.assertNotNull((Object)item, (String)"ContentItem item");
        Assert.assertNotNull((Object)context, (String)"String context");
        if (section == null) {
            section = item.getContentSection();
        }
        if ("draft".equals(context)) {
            if (Assert.isAssertEnabled()) {
                Assert.assertTrue((boolean)"draft".equals(item.getVersion()), (String)"Generating draft url: item must be draft version");
            }
            return this.generateDraftURL(section, item.getID());
        }
        if ("preview".equals(context)) {
            return this.generatePreviewURL(section, item, templateContext);
        }
        if ("live".equals(context)) {
            if (Assert.isAssertEnabled()) {
                Assert.assertTrue((boolean)"live".equals(item.getVersion()), (String)"Generating live url: item must be live version");
            }
            return this.generateLiveURL(section, item, templateContext);
        }
        throw new RuntimeException("Unknown context " + context);
    }

    public CMSPage getMasterPage(ContentItem item, HttpServletRequest request) throws ServletException {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Getting the master page for item " + item));
        }
        if (s_masterP == null) {
            s_masterP = new MasterPage();
            s_masterP.init();
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Returning master page " + s_masterP));
        }
        return s_masterP;
    }

    protected String generateDraftURL(ContentSection section, BigDecimal itemId) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Generating draft URL for item ID " + itemId + " and section " + (Object)((Object)section)));
        }
        if (Assert.isAssertEnabled()) {
            Assert.assertTrue((section != null && itemId != null ? 1 : 0) != 0, (String)"get draft url: neither secion nor item can be null");
        }
        String url = ContentItemPage.getItemURL(section.getPath() + "/", itemId, ContentItemPage.AUTHORING_TAB);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Generated draft URL " + url));
        }
        return url;
    }

    protected String generateLiveURL(ContentSection section, ContentItem item, String templateContext) {
        ContentItem bundle;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Generating live URL for item " + item + " in " + "section " + (Object)((Object)section)));
        }
        StringBuffer url = new StringBuffer(400);
        url.append(section.getPath() + "/");
        if (templateContext != null && templateContext.length() != 0) {
            url.append("tem_" + templateContext + "/");
        }
        if ((bundle = (ContentItem)item.getParent()) != null && bundle instanceof ContentBundle) {
            s_log.debug((Object)"Found a bundle; building its file name");
            String fname = bundle.getPath();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Appending the bundle's file name '" + fname + "'"));
            }
            url.append(fname);
        } else {
            s_log.debug((Object)"No bundle found; using the item's path directly");
            url.append(item.getPath());
        }
        String language = item.getLanguage();
        if (language == null) {
            s_log.debug((Object)"The item has no language; omitting the language encoding");
        } else {
            s_log.debug((Object)("Encoding the language of the item passed in, '" + language + "'"));
            url.append("." + language);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Generated live URL " + url.toString()));
        }
        return url.toString();
    }

    protected String generatePreviewURL(ContentSection section, ContentItem item, String templateContext) {
        ContentItem bundle;
        Assert.assertNotNull((Object)((Object)section), (String)"ContentSection section");
        Assert.assertNotNull((Object)item, (String)"ContentItem item");
        StringBuffer url = new StringBuffer(100);
        url.append(section.getPath());
        url.append("/");
        url.append("preview");
        url.append("/");
        if (templateContext != null && templateContext.length() != 0) {
            url.append("tem_" + templateContext + "/");
        }
        if ((bundle = (ContentItem)item.getParent()) != null && bundle instanceof ContentBundle) {
            s_log.debug((Object)"Found a bundle; using its path");
            url.append(bundle.getPath());
        } else {
            s_log.debug((Object)"No bundle found; using the item's path directly");
            url.append(item.getPath());
        }
        String language = item.getLanguage();
        if (language == null) {
            s_log.debug((Object)"The item has no language; omitting the language encoding");
        } else {
            s_log.debug((Object)("Encoding the language of the item passed in, '" + language + "'"));
            url.append("." + language);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Generated preview URL " + url.toString()));
        }
        return url.toString();
    }

    protected ContentItem getItemFromDraftURL(String url) {
        String item_id;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Looking up the item from draft URL " + url));
        }
        int pos = url.indexOf(ITEM_ID);
        if (Assert.isAssertEnabled()) {
            Assert.assertTrue((pos >= 0 ? 1 : 0) != 0, (String)"Draft URL must contain parameter item_id");
        }
        if ((pos = (item_id = url.substring(pos)).indexOf("=")) != ITEM_ID.length()) {
            s_log.debug((Object)"No suitable item_id parameter found; returning null");
            return null;
        }
        int i = item_id.indexOf(SEPARATOR);
        item_id = item_id.substring(++pos, Math.min(i, item_id.length() - 1));
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Looking up item using item ID " + item_id));
        }
        OID oid = new OID("com.arsdigita.cms.ContentItem", (Object)new BigDecimal(item_id));
        ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Returning item " + item));
        }
        return item;
    }

    protected ContentItem getItemFromLiveURL(String url, Folder parentFolder) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Resolving the item for live URL " + url + " and parent folder " + parentFolder));
        }
        if (parentFolder == null || url == null || url.equals("")) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"The url is null or parent folder was null or something else is wrong, so just return the parent folder");
            }
            return parentFolder;
        }
        int len = url.length();
        int index = url.indexOf(47);
        if (index >= 0) {
            s_log.debug((Object)"The URL starts with a slash; paring off the first URL element and recursing");
            String name = index > 0 ? url.substring(0, index) : "";
            parentFolder = name != "" ? (Folder)parentFolder.getItem(URLEncoder.encode(name), true) : parentFolder;
            url = index + 1 < len ? url.substring(index + 1) : "";
            return this.getItemFromLiveURL(url, parentFolder);
        }
        s_log.debug((Object)"Found a file element in the URL");
        String[] nameAndLang = this.getNameAndLangFromURLFrag(url);
        String name = nameAndLang[0];
        String lang = nameAndLang[1];
        ContentItem item = parentFolder.getItem(URLEncoder.encode(name), false);
        return this.getItemFromLangAndBundle(lang, item);
    }

    protected String[] getNameAndLangFromURLFrag(String url) {
        String name = null;
        String lang = null;
        ArrayList<String> exts = new ArrayList<String>(5);
        StringTokenizer tok = new StringTokenizer(url, ".");
        while (tok.hasMoreTokens()) {
            exts.add(tok.nextToken());
        }
        if (exts.size() > 0) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Found some file extensions to look at; they are " + exts));
            }
            name = (String)exts.get(0);
            String ext = null;
            Collection supportedLangs = LanguageUtil.getSupportedLanguages2LA();
            Iterator supportedLangIt = null;
            block1: for (int i = 1; i < exts.size(); ++i) {
                ext = (String)exts.get(i);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Examining extension " + ext));
                }
                if (ext != null && ext.length() == 2) {
                    supportedLangIt = supportedLangs.iterator();
                    while (supportedLangIt.hasNext()) {
                        if (!ext.equals(supportedLangIt.next())) continue;
                        lang = ext;
                        if (!s_log.isDebugEnabled()) continue block1;
                        s_log.debug((Object)("Found a match; using language " + lang));
                        continue block1;
                    }
                    continue;
                }
                if (!s_log.isDebugEnabled()) continue;
                s_log.debug((Object)("Discarding extension " + ext + "; " + "it is too short"));
            }
        } else {
            s_log.debug((Object)"The file has no extensions; no language was encoded");
            name = url;
            lang = null;
        }
        if (Assert.isAssertEnabled()) {
            Assert.assertNotNull((Object)name, (String)"String name");
            Assert.assertTrue((lang == null || lang.length() == 2 ? 1 : 0) != 0);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("File name resolved to " + name));
            s_log.debug((Object)("File language resolved to " + lang));
        }
        String[] returnArray = new String[]{name, lang};
        return returnArray;
    }

    protected ContentItem getItemFromLangAndBundle(String lang, ContentItem item) {
        if (item != null && item instanceof ContentBundle) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Found content bundle " + item));
            }
            if (lang == null) {
                s_log.debug((Object)"The URL has no language encoded in it; negotiating the language");
                ContentItem resolved = ((ContentBundle)item).negotiate(Web.getRequest().getLocales());
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Resolved URL to item " + resolved));
                }
                return resolved;
            }
            s_log.debug((Object)"The URL is encoded with a langauge; fetching the appropriate item from the bundle");
            ContentItem resolved = ((ContentBundle)item).getInstance(lang);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Resolved URL to item " + resolved));
            }
            return resolved;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("I expected to get a content bundle; I got " + item));
        }
        return item;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

