/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.NoValidURLException;
import com.arsdigita.kernel.URLFinder;
import com.arsdigita.kernel.URLFinderNotFoundException;
import com.arsdigita.kernel.URLService;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import org.apache.log4j.Logger;

public class ItemURLFinder
implements URLFinder {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$dispatcher$ItemURLFinder == null ? (class$com$arsdigita$cms$dispatcher$ItemURLFinder = ItemURLFinder.class$("com.arsdigita.cms.dispatcher.ItemURLFinder")) : class$com$arsdigita$cms$dispatcher$ItemURLFinder));
    static /* synthetic */ Class class$com$arsdigita$cms$dispatcher$ItemURLFinder;

    public String find(OID oid, String context) throws NoValidURLException {
        ContentItem item;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Locating " + oid + " in " + context));
        }
        try {
            item = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
        }
        catch (DataObjectNotFoundException ex) {
            throw new NoValidURLException("cannot instantiate item " + oid + " message: " + ex.getMessage());
        }
        if ("live".equals(context)) {
            if (item.isLive()) {
                if (!item.isLiveVersion()) {
                    item = item.getLiveVersion();
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Switched to live version " + item));
                    }
                }
            } else {
                s_log.debug((Object)"Item was not live");
                throw new NoValidURLException("item " + oid + " is not live");
            }
        }
        return this.find(item, context);
    }

    public String find(OID oid) throws NoValidURLException {
        ContentItem item;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Locating " + oid));
        }
        try {
            item = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
        }
        catch (DataObjectNotFoundException ex) {
            throw new NoValidURLException("cannot instantiate item " + oid + " message: " + ex.getMessage());
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Item version is " + item.getVersion()));
        }
        if (item.isLive() && !item.isLiveVersion()) {
            item = item.getLiveVersion();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Switched to live version " + item));
            }
        }
        return this.find(item, item.getVersion());
    }

    private String find(ContentItem item, String context) {
        ItemResolver resolver;
        ContentSection section;
        block12: {
            section = item.getContentSection();
            resolver = section.getItemResolver();
            ACSObject parent = item.getParent();
            ContentBundle bundle = null;
            if (parent instanceof ContentBundle) {
                bundle = (ContentBundle)((ContentBundle)parent).getDraftVersion();
            }
            if (bundle != null) {
                DataAssociationCursor categories = ((DataAssociation)DomainServiceInterfaceExposer.get((DomainObject)bundle, (String)"categories")).cursor();
                categories.addEqualsFilter("link.isIndex", (Object)Boolean.TRUE);
                if (categories.next()) {
                    Category indexCat = (Category)DomainObjectFactory.newInstance((DataObject)categories.getDataObject());
                    categories.close();
                    try {
                        if (s_log.isDebugEnabled()) {
                            s_log.debug((Object)(item + " is a Category index item.  Resolving URL for " + indexCat));
                        }
                        return URLService.locate((OID)indexCat.getOID(), (String)context);
                    }
                    catch (URLFinderNotFoundException ufnfe) {
                        if (s_log.isDebugEnabled()) {
                            s_log.debug((Object)("Could not find URLFinder for " + indexCat + ", continuing with URL resolution for " + item), (Throwable)ufnfe);
                        }
                    }
                    catch (NoValidURLException nvue) {
                        if (!s_log.isDebugEnabled()) break block12;
                        s_log.debug((Object)("Could not find valid URL for " + indexCat + ", continuing with URL resolution for " + item), (Throwable)nvue);
                    }
                }
            }
        }
        String url = resolver.generateItemURL(null, item, section, context);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Resolved " + item + " in " + context + " to " + url));
        }
        int sep = url.indexOf(63);
        URL destination = null;
        if (sep == -1) {
            destination = URL.there((String)url, null);
        } else {
            ParameterMap params = ParameterMap.fromString((String)url.substring(sep + 1));
            destination = URL.there((String)url.substring(0, sep), (ParameterMap)params);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("After munging, destination is " + destination));
        }
        return destination.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

