/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Link;
import com.arsdigita.cms.contenttypes.ui.LinkSelectionModel;
import com.arsdigita.cms.ui.ItemSearchWidget;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class LinkPropertyForm
extends FormSection
implements FormInitListener,
FormProcessListener,
FormValidationListener,
FormSubmissionListener {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$contenttypes$ui$LinkPropertyForm == null ? (class$com$arsdigita$cms$contenttypes$ui$LinkPropertyForm = LinkPropertyForm.class$("com.arsdigita.cms.contenttypes.ui.LinkPropertyForm")) : class$com$arsdigita$cms$contenttypes$ui$LinkPropertyForm));
    public static final String ID = "link_edit";
    public static final String SSL_PROTOCOL = "https://";
    public static final String HTTP_PROTOCOL = "http://";
    private TextArea m_description;
    private TextField m_title;
    private TextField m_targetURI;
    private RadioGroup m_linkType;
    private ItemSelectionModel m_itemModel;
    private LinkSelectionModel m_linkModel;
    private SaveCancelSection m_saveCancelSection;
    private ItemSearchWidget m_itemSearch;
    private final String ITEM_SEARCH = "contentItem";
    static /* synthetic */ Class class$com$arsdigita$cms$contenttypes$ui$LinkPropertyForm;

    public LinkPropertyForm(ItemSelectionModel itemModel, LinkSelectionModel link) {
        super((Container)new ColumnPanel(2));
        s_log.debug((Object)"property form constructor");
        this.m_linkModel = link;
        this.m_itemModel = itemModel;
        this.addWidgets();
        this.addSaveCancelSection();
        this.addInitListener(this);
        this.addValidationListener(this);
        this.addProcessListener(this);
        this.addSubmissionListener(this);
    }

    protected void addWidgets() {
        this.m_title = new TextField("title");
        this.m_title.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.contenttypes.ui.title")));
        this.add((Component)this.m_title);
        this.m_description = new TextArea("description");
        this.m_description.setCols(40);
        this.m_description.setRows(5);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.contenttypes.ui.description")));
        this.add((Component)this.m_description);
        this.add((Component)new Label("<script language=\"javascript\">\n<!-- \nfunction toggle_link_fields(status) { \n  document.forms['linkEditForm'].targetURI.disabled = status; \n  document.forms['linkEditForm'].contentItem.disabled = !status; \n  document.forms['linkEditForm'].contentItem_search.disabled = !status; \n  document.forms['linkEditForm'].contentItem_clear.disabled = !status; \n}\n// -->\n</script>\n", false));
        this.add((Component)new Label("Choose either an External Link or a Content Item", "b"), 64);
        this.m_linkType = new RadioGroup("linkType");
        Option m_external = new Option("externalLink", "External Link");
        m_external.setOnClick("toggle_link_fields(false)");
        Option m_internal = new Option("internalLink", "Content Item");
        m_internal.setOnClick("toggle_link_fields(true)");
        this.m_linkType.addOption(m_external);
        this.m_linkType.addOption(m_internal);
        this.m_linkType.setOptionSelected(m_external);
        this.m_linkType.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)new Label("Link Type (Choose one):"));
        this.add((Component)this.m_linkType);
        this.m_targetURI = new TextField("targetURI");
        this.m_targetURI.setOnFocus("toggle_link_fields(false)");
        this.m_targetURI.setHint("Enter a URL such as http://www.example.com/");
        this.add((Component)new Label("External URL: "));
        this.add((Component)this.m_targetURI);
        this.add((Component)new Label("Content Item:"));
        this.m_itemSearch = new ItemSearchWidget("contentItem");
        this.m_itemSearch.getSearchButton().setOnFocus("toggle_link_fields(true)");
        this.m_itemSearch.getClearButton().setOnFocus("toggle_link_fields(true)");
        this.add((Component)this.m_itemSearch);
        this.add((Component)new Label("<script language=\"javascript\">\n<!-- \nif (document.forms['linkEditForm'].linkType[0].checked) { \n  toggle_link_fields(false); \n} else { \n  toggle_link_fields(true); \n} \n// -->\n</script>\n", false));
    }

    public void addSaveCancelSection() {
        this.m_saveCancelSection = new SaveCancelSection();
        try {
            this.m_saveCancelSection.getCancelButton().addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    Submit target = (Submit)e.getTarget();
                    if (LinkPropertyForm.this.m_linkModel.isSelected(e.getPageState())) {
                        target.setButtonLabel("Cancel");
                    } else {
                        target.setButtonLabel("Reset");
                    }
                }
            });
            this.m_saveCancelSection.getSaveButton().addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    Submit target = (Submit)e.getTarget();
                    if (LinkPropertyForm.this.m_linkModel.isSelected(e.getPageState())) {
                        target.setButtonLabel("Save");
                    } else {
                        target.setButtonLabel("Create");
                    }
                }
            });
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("this cannot happen", (Throwable)e);
        }
        this.add((Component)this.m_saveCancelSection, 64);
    }

    public SaveCancelSection getSaveCancelSection() {
        return this.m_saveCancelSection;
    }

    protected LinkSelectionModel getLinkSelectionModel() {
        return this.m_linkModel;
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        if (this.m_saveCancelSection.getCancelButton().isSelected(e.getPageState())) {
            s_log.debug((Object)"cancel in submission listener");
            this.m_linkModel.clearSelection(e.getPageState());
            this.init(e);
            throw new FormProcessException("cancelled");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        FormData data = event.getFormData();
        if ("externalLink".equals((String)this.m_linkType.getValue(state))) {
            String externalURI = (String)this.m_targetURI.getValue(state);
            if (externalURI == null || externalURI.length() == 0) {
                throw new FormProcessException("The URI field is required for an external link.");
            }
            try {
                URL url = new URL((String)this.m_targetURI.getValue(state));
                return;
            }
            catch (MalformedURLException ex) {
                try {
                    boolean hasProtocol;
                    String targetURI = (String)this.m_targetURI.getValue(state);
                    boolean httpsLink = targetURI.startsWith(SSL_PROTOCOL);
                    boolean bl = hasProtocol = targetURI.indexOf("://") != -1;
                    String newURI = httpsLink ? HTTP_PROTOCOL + targetURI.substring(SSL_PROTOCOL.length()) : (hasProtocol ? targetURI : HTTP_PROTOCOL + targetURI);
                    URL url = new URL(newURI);
                    if (httpsLink) return;
                    this.m_targetURI.setValue(state, (Object)newURI);
                    return;
                }
                catch (MalformedURLException ex2) {
                    throw new FormProcessException("The URL is not valid: " + ex.getMessage() + ". \n" + "Valid URLs must begin with \"http://\" .");
                }
            }
        } else {
            if (!"internalLink".equals((String)this.m_linkType.getValue(state)) || data.get((Object)"contentItem") != null) return;
            throw new FormProcessException("Item selection is required for internal link.");
        }
    }

    protected ContentItem getContentItem(PageState s) {
        return (ContentItem)this.m_itemModel.getSelectedObject(s);
    }

    protected Link createLink(PageState s) {
        ContentItem item = this.getContentItem(s);
        Assert.exists((Object)item);
        Link link = new Link();
        return link;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(FormSectionEvent fse) throws FormProcessException {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        s_log.debug((Object)"Init");
        this.setVisible(state, true);
        if (this.m_linkModel.isSelected(state)) {
            s_log.debug((Object)"Edit");
            Link link = this.m_linkModel.getSelectedLink(state);
            try {
                this.m_title.setValue(state, (Object)link.getTitle());
                this.m_description.setValue(state, (Object)link.getDescription());
                this.m_targetURI.setValue(state, (Object)link.getTargetURI());
                this.m_linkType.setValue(state, (Object)link.getTargetType());
                if (!"internalLink".equals(link.getTargetType())) return;
                data.put((Object)"contentItem", (Object)link.getTargetItem());
                return;
            }
            catch (IllegalStateException e) {
                s_log.error((Object)e.getMessage());
                throw e;
            }
        } else {
            s_log.debug((Object)"new link");
            this.m_title.setValue(state, null);
            this.m_description.setValue(state, null);
            this.m_targetURI.setValue(state, null);
            this.m_linkType.setValue(state, (Object)"externalLink");
            data.put((Object)"contentItem", null);
        }
    }

    public void process(FormSectionEvent fse) throws FormProcessException {
        PageState state = fse.getPageState();
        if (this.getSaveCancelSection().getCancelButton().isSelected(state)) {
            this.m_linkModel.clearSelection(state);
            s_log.debug((Object)"link save canceled");
        } else {
            Link link;
            if (this.m_linkModel.isSelected(state)) {
                s_log.debug((Object)"processing link edit");
                link = this.m_linkModel.getSelectedLink(state);
            } else {
                s_log.debug((Object)"processing new link");
                link = this.createLink(state);
            }
            this.setLinkProperties(link, fse);
            s_log.debug((Object)("Created Link with ID: " + link.getOID().toString() + "Title " + link.getTitle()));
        }
        this.m_linkModel.clearSelection(state);
        this.init(fse);
    }

    protected void setLinkProperties(Link link, FormSectionEvent fse) {
        PageState state = fse.getPageState();
        FormData data = fse.getFormData();
        link.setTitle((String)this.m_title.getValue(state));
        link.setDescription((String)this.m_description.getValue(state));
        link.setTargetType((String)this.m_linkType.getValue(state));
        if ("externalLink".equals(this.m_linkType.getValue(state))) {
            link.setTargetURI((String)this.m_targetURI.getValue(state));
            link.setTargetItem(null);
        } else {
            link.setTargetURI(null);
            link.setTargetItem((ContentItem)data.get((Object)"contentItem"));
        }
        link.save();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

