/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.search.ContentPageMetadataProvider;
import com.arsdigita.db.DbHelper;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.xml.TraversalHandler;
import com.arsdigita.persistence.pdl.ManifestSource;
import com.arsdigita.persistence.pdl.NameFilter;
import com.arsdigita.persistence.pdl.PDLFilter;
import com.arsdigita.persistence.pdl.PDLSource;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.Initializer;
import com.arsdigita.runtime.LegacyInitEvent;
import com.arsdigita.runtime.PDLInitializer;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.search.MetadataProvider;
import com.arsdigita.search.MetadataProviderRegistry;
import com.arsdigita.util.StringUtils;
import com.arsdigita.xml.XML;
import org.apache.log4j.Logger;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ContentTypeInitializer
extends CompoundInitializer {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$contenttypes$ContentTypeInitializer == null ? (class$com$arsdigita$cms$contenttypes$ContentTypeInitializer = ContentTypeInitializer.class$("com.arsdigita.cms.contenttypes.ContentTypeInitializer")) : class$com$arsdigita$cms$contenttypes$ContentTypeInitializer));
    private final String m_objectType;
    public static final String[] EMPTY_ARRAY = new String[0];
    static /* synthetic */ Class class$com$arsdigita$cms$contenttypes$ContentTypeInitializer;

    protected ContentTypeInitializer(String manifestFile, String objectType) {
        String url = RuntimeConfig.getConfig().getJDBCURL();
        int database = DbHelper.getDatabaseFromURL((String)url);
        this.add((Initializer)new PDLInitializer((PDLSource)new ManifestSource(manifestFile, (PDLFilter)new NameFilter(DbHelper.getDatabaseSuffix((int)database), "pdl"))));
        this.m_objectType = objectType;
    }

    public void init(LegacyInitEvent evt) {
        super.init(evt);
        String traversal = this.getTraversalXML();
        if (!StringUtils.emptyString((String)traversal)) {
            XML.parseResource((String)traversal, (DefaultHandler)new TraversalHandler());
        }
        try {
            ContentType type = ContentType.findByAssociatedObjectType(this.m_objectType);
            MetadataProviderRegistry.registerAdapter((String)this.m_objectType, (MetadataProvider)new ContentPageMetadataProvider());
            String[] stylesheets = this.getStylesheets();
            for (int i = 0; i < stylesheets.length; ++i) {
                String stylesheet = stylesheets[i];
                ContentType.registerXSLFile(type, stylesheet);
            }
        }
        catch (DataObjectNotFoundException e) {
            s_log.debug((Object)("Unable to register the stylesheet for " + this.m_objectType + " because the content type was not found. " + "This is normal during the load script but " + "should not appear during server startup."));
        }
    }

    public String getTraversalXML() {
        return "";
    }

    public String[] getStylesheets() {
        return EMPTY_ARRAY;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

