/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.SimpleCache;
import com.arsdigita.cms.publishToFile.LocalRequestPassword;
import com.arsdigita.cms.util.SecurityConstants;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.toolbox.Security;
import com.arsdigita.ui.login.LoginHelper;
import com.arsdigita.util.Assert;
import com.arsdigita.workflow.simple.Engine;
import com.arsdigita.workflow.simple.Workflow;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SecurityManager
implements Security,
SecurityConstants {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/SecurityManager.java#23 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$SecurityManager == null ? (class$com$arsdigita$cms$SecurityManager = SecurityManager.class$("com.arsdigita.cms.SecurityManager")) : class$com$arsdigita$cms$SecurityManager));
    public static final PrivilegeDescriptor CMS_PREVIEW_ITEM_DESCRIPTOR = new PrivilegeDescriptor("cms_preview_item");
    private ContentSection m_section;
    private SimpleCache m_cache;
    static /* synthetic */ Class class$com$arsdigita$cms$SecurityManager;

    public SecurityManager(ContentSection section) {
        this.m_section = section;
        this.m_cache = new SimpleCache();
    }

    public final boolean canAccess(String action) {
        return this.canAccess(Kernel.getContext().getParty(), action);
    }

    public boolean canAccess(Party party, String action) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Access check: party " + party + ", action " + action));
        }
        if (action.equals("workflow_admin")) {
            return this.canAdministerWorkflow(party);
        }
        if (action.equals("lifecycle_admin")) {
            return this.canAdministerLifecycles(party);
        }
        if (action.equals("staff_admin")) {
            return this.canAdministerRoles(party);
        }
        if (action.equals("content_type_admin")) {
            return this.canAdministerContentTypes(party);
        }
        if (action.equals("category_admin")) {
            return this.canAdministerCategories(party);
        }
        if (action.equals("publish")) {
            return this.canPublishItems(party);
        }
        if (action.equals("new_item")) {
            return this.canCreateItems(party);
        }
        if (action.equals("admin_pages")) {
            return this.canViewAdminPages(party);
        }
        if (action.equals("public_pages")) {
            return this.canViewPublicPages(party);
        }
        if (action.equals("preview_pages")) {
            return this.canViewPreviewPages(party);
        }
        if (action.equals("delete_images")) {
            return this.canDeleteImages(party);
        }
        if (action.equals("apply_alternate_workflows")) {
            return this.canApplyAlternateWorkflows(party);
        }
        throw new IllegalArgumentException("Unknown action for access check: " + action);
    }

    public boolean canAccess(HttpServletRequest request, String action) {
        Party party = Kernel.getContext().getParty();
        boolean canAccess = this.canAccess(party, action);
        if (!canAccess) {
            canAccess = LocalRequestPassword.validLocalRequest(request);
        }
        return canAccess;
    }

    public boolean canAccess(User user, String action, ContentItem item) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Access check: user " + user + ", object " + item + ", action " + action));
        }
        if (action.equals("edit_item")) {
            return this.canEditItem(user, item);
        }
        if (action.equals("apply_workflow")) {
            return this.canApplyWorkflow(user, item);
        }
        if (action.equals("delete_item")) {
            return this.canDeleteItem(user, item);
        }
        if (action.equals("schedule_publication")) {
            return this.canSchedulePublication(user, item);
        }
        if (action.equals("publish")) {
            return this.canPublishItems((Party)user, item);
        }
        if (action.equals("public_pages")) {
            return this.canViewPublicPages(user, item);
        }
        if (action.equals("preview_pages")) {
            return this.canViewPreviewPages(user, item);
        }
        if (action.equals("new_item")) {
            return this.canCreateItems(user, item);
        }
        if (action.equals("apply_alternate_workflows")) {
            return this.canApplyAlternateWorkflows(user, item);
        }
        if (action.equals("staff_admin")) {
            return this.canAdministerRoles((Party)user, item);
        }
        if (action.equals("workflow_admin")) {
            return this.canAdministerWorkflow((Party)user);
        }
        if (action.equals("lifecycle_admin")) {
            return this.canAdministerLifecycles((Party)user);
        }
        if (action.equals("staff_admin")) {
            return this.canAdministerRoles((Party)user);
        }
        if (action.equals("content_type_admin")) {
            return this.canAdministerContentTypes((Party)user);
        }
        if (action.equals("admin_pages")) {
            return this.canViewAdminPages((Party)user);
        }
        throw new IllegalArgumentException("Unknown action for access check: " + action);
    }

    public boolean canAccess(HttpServletRequest request, String action, ContentItem item) {
        User user = KernelHelper.getCurrentUser((HttpServletRequest)request);
        boolean canAccess = this.canAccess(user, action, item);
        if (!canAccess) {
            canAccess = LocalRequestPassword.validLocalRequest(request);
        }
        return canAccess;
    }

    protected boolean canAdministerLifecycles(Party party) {
        return this.hasPermission(party, "cms_lifecycle_admin");
    }

    protected boolean canAdministerWorkflow(Party party) {
        return this.hasPermission(party, "cms_workflow_admin");
    }

    protected boolean canAdministerRoles(Party party) {
        return this.hasPermission(party, "cms_staff_admin");
    }

    protected boolean canAdministerRoles(Party party, ContentItem item) {
        return this.hasPermission(party, "cms_staff_admin", item);
    }

    protected boolean canAdministerContentTypes(Party party) {
        return this.hasPermission(party, "cms_content_type_admin");
    }

    protected boolean canAdministerCategories(Party party) {
        return this.hasPermission(party, "cms_category_admin");
    }

    protected boolean canPublishItems(Party party) {
        return this.hasPermission(party, "cms_publish");
    }

    protected boolean canPublishItems(Party party, ContentItem item) {
        return this.hasPermission(party, "cms_publish", item);
    }

    protected boolean canCreateItems(Party party) {
        return this.hasPermission(party, "cms_new_item");
    }

    protected boolean canCreateItems(User user, ContentItem item) {
        return this.hasPermission((Party)user, "cms_new_item", item);
    }

    protected boolean canApplyAlternateWorkflows(Party party) {
        return this.hasPermission(party, "cms_apply_alternate_workflows");
    }

    protected boolean canApplyAlternateWorkflows(User user, ContentItem item) {
        return this.hasPermission((Party)user, "cms_apply_alternate_workflows", item);
    }

    protected boolean canViewPublicPages(Party party) {
        return this.hasPermission(party, "cms_read_item");
    }

    protected boolean canViewPublicPages(User user, ContentItem item) {
        return this.hasPermission((Party)user, "cms_read_item", item);
    }

    protected boolean canViewPreviewPages(Party party) {
        return this.hasPermission(party, "cms_preview_item") || this.hasPermission(party, "cms_edit_item");
    }

    protected boolean canViewPreviewPages(User user, ContentItem item) {
        return this.hasPermission((Party)user, "cms_preview_item", item) || this.hasPermission((Party)user, "cms_edit_item", item);
    }

    protected boolean canViewAdminPages(Party party) {
        return this.hasPermission(party, PrivilegeDescriptor.READ);
    }

    protected boolean canDeleteImages(Party party) {
        return this.hasPermission(party, "cms_item_admin");
    }

    protected boolean canEditItem(User user, ContentItem item) {
        if (user == null) {
            return false;
        }
        if (!this.hasPermission((Party)user, "cms_edit_item", item)) {
            return false;
        }
        Workflow wf = Workflow.getObjectWorkflow((ACSObject)item);
        if (wf == null) {
            return this.hasPermission((Party)user, "cms_item_admin", item);
        }
        if (wf.isFinished() || wf.getProcessState() == 1) {
            return this.hasPermission((Party)user, "cms_item_admin", item);
        }
        Engine engine = Engine.getInstance();
        Iterator i = engine.getEnabledTasks(user, wf.getID()).iterator();
        while (i.hasNext()) {
            CMSTask t = (CMSTask)((Object)i.next());
            if (!t.isLocked() || !user.equals((Object)t.getLockedUser())) continue;
            return true;
        }
        return false;
    }

    protected boolean canSchedulePublication(User user, ContentItem item) {
        if (user != null && this.canPublishItems((Party)user, item)) {
            Workflow wf = Workflow.getObjectWorkflow((ACSObject)item);
            if (wf == null || wf.getProcessState() == 1 || wf.isFinished()) {
                return true;
            }
            Engine engine = Engine.getInstance();
            Iterator i = engine.getEnabledTasks(user, wf.getID()).iterator();
            boolean j = false;
            while (i.hasNext()) {
                CMSTask t = (CMSTask)((Object)i.next());
                if (!t.getTaskType().equals(CMSTask.DEPLOY)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean canDeleteItem(User user, ContentItem item) {
        return this.hasPermission((Party)user, "cms_delete_item", item);
    }

    protected boolean canApplyWorkflow(User user, ContentItem item) {
        if (user == null) {
            return false;
        }
        if (!this.hasPermission((Party)user, "cms_edit_item")) {
            return true;
        }
        if (Workflow.getObjectWorkflowID((ACSObject)item) != null) {
            return false;
        }
        return this.hasPermission((Party)user, "cms_new_item", item) || this.hasPermission((Party)user, "cms_workflow_admin");
    }

    private boolean hasPermission(Party party, String privilege) {
        PrivilegeDescriptor pd = PrivilegeDescriptor.get((String)privilege);
        Assert.assertNotNull((Object)pd, (String)("PrivilegeDescriptor.get(\"" + privilege + "\")"));
        return this.hasPermission(party, pd);
    }

    private boolean hasPermission(Party party, PrivilegeDescriptor pd) {
        PermissionDescriptor perm = new PermissionDescriptor(pd, (ACSObject)this.m_section, party);
        return PermissionService.checkPermission((PermissionDescriptor)perm);
    }

    private boolean hasPermission(Party party, String privilege, ContentItem item) {
        PrivilegeDescriptor pd = PrivilegeDescriptor.get((String)privilege);
        Assert.assertNotNull((Object)pd, (String)("PrivilegeDescriptor.get(\"" + privilege + "\")"));
        return this.hasPermission(party, pd, item);
    }

    private boolean hasPermission(Party party, PrivilegeDescriptor pd, ContentItem item) {
        Assert.assertNotNull((Object)pd, (String)"PrivilegeDescriptor");
        PermissionDescriptor perm = new PermissionDescriptor(pd, (ACSObject)item, party);
        return PermissionService.checkPermission((PermissionDescriptor)perm);
    }

    public static void requireSignIn(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (KernelHelper.getCurrentUser((HttpServletRequest)request) != null) {
            return;
        }
        String url = Initializer.getSecurityHelper().getLoginURL(request) + "?" + "return_url" + "=" + UserContext.encodeReturnURL((HttpServletRequest)request);
        LoginHelper.sendRedirect((HttpServletRequest)request, (HttpServletResponse)response, (String)url);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

