/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.publishToFile.QueueManager;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

class PublishedLink
extends DomainObject {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$PublishedLink == null ? (class$com$arsdigita$cms$PublishedLink = PublishedLink.class$("com.arsdigita.cms.PublishedLink")) : class$com$arsdigita$cms$PublishedLink));
    static final String SOURCE_MASTER_ITEM = "pending";
    static final String PENDING_SOURCE = "pendingSource";
    static final String PROPERTY_NAME = "propertyName";
    static final String DRAFT_TARGET = "draftTarget";
    static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.PublishedLink";
    static /* synthetic */ Class class$com$arsdigita$cms$PublishedLink;
    static /* synthetic */ Class class$com$arsdigita$persistence$DataObject;
    static /* synthetic */ Class class$java$lang$String;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected PublishedLink() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    protected PublishedLink(DataObject data) {
        super(data);
    }

    protected PublishedLink(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    static PublishedLink create(ContentItem sourceMasterItem, DomainObject linkSource, String propertyName, ContentItem linkTarget) {
        OID oid = new OID(BASE_DATA_OBJECT_TYPE);
        oid.set(SOURCE_MASTER_ITEM, (Object)DomainServiceInterfaceExposer.getDataObject((DomainObject)sourceMasterItem));
        oid.set(PROPERTY_NAME, (Object)propertyName);
        oid.set(DRAFT_TARGET, (Object)DomainServiceInterfaceExposer.getDataObject((DomainObject)linkTarget));
        if (linkSource instanceof ACSObject) {
            oid.set(PENDING_SOURCE, (Object)DomainServiceInterfaceExposer.getDataObject((DomainObject)linkSource));
        } else {
            Assert.fail((String)("Cannot set PublishedLink source " + linkSource + "; it is not an " + "ACSObject"));
        }
        PublishedLink link = null;
        try {
            link = new PublishedLink(oid);
        }
        catch (DataObjectNotFoundException e) {
            link = new PublishedLink(SessionManager.getSession().create(oid));
        }
        return link;
    }

    ContentItem getSourceMasterItem() {
        DataObject item = (DataObject)this.get(SOURCE_MASTER_ITEM);
        return item == null ? null : (ContentItem)DomainObjectFactory.newInstance((DataObject)item);
    }

    DomainObject getLinkSource() {
        DataObject item = (DataObject)this.get(PENDING_SOURCE);
        return item == null ? null : DomainObjectFactory.newInstance((DataObject)item);
    }

    String getPropertyName() {
        return (String)this.get(PROPERTY_NAME);
    }

    ContentItem getLinkTarget() {
        DataObject item = (DataObject)this.get(DRAFT_TARGET);
        return item == null ? null : (ContentItem)DomainObjectFactory.newInstance((DataObject)item);
    }

    public static void updateLiveLinks(ContentItem item) {
        Session session = SessionManager.getSession();
        HashSet itemsToRefresh = new HashSet();
        ContentItem draftItem = item.getDraftVersion();
        DataCollection linksToItem = session.retrieve(BASE_DATA_OBJECT_TYPE);
        linksToItem.addEqualsFilter("draftTarget.id", (Object)draftItem.getID());
        linksToItem.addEqualsFilter("pending.version", (Object)"live");
        PublishedLink.updateLiveLinksFromCollection(linksToItem, itemsToRefresh);
        linksToItem.close();
        DataCollection linksFromItem = session.retrieve(BASE_DATA_OBJECT_TYPE);
        linksFromItem.addEqualsFilter("pending.id", (Object)item.getID());
        PublishedLink.updateLiveLinksFromCollection(linksFromItem, null);
        linksFromItem.close();
        Iterator refreshIterator = itemsToRefresh.iterator();
        while (refreshIterator.hasNext()) {
            OID oid = (OID)refreshIterator.next();
            ContentItem refreshItem = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
            if (!refreshItem.canPublishToFS()) continue;
            QueueManager.queueRepublish(refreshItem);
        }
    }

    private static void updateLiveLinksFromCollection(DataCollection coll, Set itemsToRefresh) {
        while (coll.next()) {
            DataObject master = (DataObject)coll.get(SOURCE_MASTER_ITEM);
            DataObject src = (DataObject)coll.get(PENDING_SOURCE);
            src.specialize((String)src.get("objectType"));
            String propertyName = (String)coll.get(PROPERTY_NAME);
            Assert.exists((Object)src, (Class)(class$com$arsdigita$persistence$DataObject == null ? PublishedLink.class$("com.arsdigita.persistence.DataObject") : class$com$arsdigita$persistence$DataObject));
            Assert.exists((Object)propertyName, (Class)(class$java$lang$String == null ? PublishedLink.class$("java.lang.String") : class$java$lang$String));
            DataObject target = null;
            DataObject draftTarget = (DataObject)coll.get(DRAFT_TARGET);
            DataAssociationCursor targetVersions = ((DataAssociation)draftTarget.get("slaveVersions")).cursor();
            targetVersions.addEqualsFilter("version", (Object)"live");
            if (targetVersions.next()) {
                target = targetVersions.getDataObject();
            }
            targetVersions.close();
            if (target == null) continue;
            ObjectType ot = src.getObjectType();
            Property prop = ot.getProperty(propertyName);
            Assert.assertNotNull((Object)prop, (String)(propertyName + " for type " + ot.getQualifiedName() + ", ID: " + src.get("id")));
            if (prop.isCollection()) {
                DataAssociation da = (DataAssociation)src.get(propertyName);
                da.add(target);
            } else {
                src.set(propertyName, (Object)target);
            }
            if (itemsToRefresh == null || master == null) continue;
            itemsToRefresh.add(master.getOID());
        }
    }

    public static void refreshOnUnpublish(ContentItem item) {
        Session session = SessionManager.getSession();
        HashSet<OID> itemsToRefresh = new HashSet<OID>();
        DataCollection linksToItem = session.retrieve(BASE_DATA_OBJECT_TYPE);
        linksToItem.addEqualsFilter("draftTarget.id", (Object)item.getID());
        linksToItem.addEqualsFilter("pending.version", (Object)"live");
        while (linksToItem.next()) {
            DataObject master = (DataObject)linksToItem.get(SOURCE_MASTER_ITEM);
            if (master == null) continue;
            itemsToRefresh.add(master.getOID());
        }
        Iterator refreshIterator = itemsToRefresh.iterator();
        while (refreshIterator.hasNext()) {
            OID oid = (OID)refreshIterator.next();
            ContentItem refreshItem = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
            if (!refreshItem.canPublishToFS()) continue;
            QueueManager.queueRepublish(refreshItem);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

