/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentTypeWorkflowTemplate;
import com.arsdigita.cms.CustomCopy;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.ItemCopier;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ContentBundle
extends ContentItem {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ContentBundle.java#32 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ContentBundle == null ? (class$com$arsdigita$cms$ContentBundle = ContentBundle.class$("com.arsdigita.cms.ContentBundle")) : class$com$arsdigita$cms$ContentBundle));
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.ContentBundle";
    public static final String INSTANCES = "instances";
    public static final String DEFAULT_LANGUAGE = "defaultLanguage";
    private boolean m_wasNew = false;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentBundle;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentItem;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentType;

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public ContentBundle(ContentItem primary) {
        super(BASE_DATA_OBJECT_TYPE);
        Assert.exists((Object)primary, (Class)(class$com$arsdigita$cms$ContentItem == null ? (class$com$arsdigita$cms$ContentItem = ContentBundle.class$("com.arsdigita.cms.ContentItem")) : class$com$arsdigita$cms$ContentItem));
        this.setDefaultLanguage(primary.getLanguage());
        this.setContentType(primary.getContentType());
        this.addInstance(primary);
        super.setName(primary.getName());
    }

    public ContentBundle(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ContentBundle(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public ContentBundle(DataObject object) {
        super(object);
    }

    public ContentBundle(String type) {
        super(type);
    }

    protected ContentItem makeCopy() {
        ContentBundle newItem = (ContentBundle)super.makeCopy();
        WorkflowTemplate template = ContentTypeWorkflowTemplate.getWorkflowTemplate(newItem.getContentSection(), newItem.getContentType());
        if (template != null) {
            s_log.debug((Object)"Setting up new workflow template");
            ItemCollection instances = this.getInstances();
            while (instances.next()) {
                ContentItem instance = instances.getContentItem();
                s_log.debug((Object)("Item id is: " + instance.getID()));
                Workflow workflow = template.instantiateNewWorkflow();
                workflow.setObjectID(instance.getID());
                workflow.start(Web.getContext().getUser());
                workflow.save();
            }
        }
        return newItem;
    }

    public final String getDefaultLanguage() {
        return (String)this.get(DEFAULT_LANGUAGE);
    }

    public final void setDefaultLanguage(String language) {
        if (Assert.isEnabled()) {
            Assert.exists((Object)language, (Class)(class$java$lang$String == null ? (class$java$lang$String = ContentBundle.class$("java.lang.String")) : class$java$lang$String));
            Assert.truth((language.length() == 2 ? 1 : 0) != 0, (String)(language + " is not an ISO639 language code"));
        }
        this.set(DEFAULT_LANGUAGE, language);
    }

    public void addInstance(ContentItem instance) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Adding " + instance + " to bundle " + this));
        }
        if (Assert.isEnabled()) {
            Assert.exists((Object)instance, (Class)(class$com$arsdigita$cms$ContentItem == null ? (class$com$arsdigita$cms$ContentItem = ContentBundle.class$("com.arsdigita.cms.ContentItem")) : class$com$arsdigita$cms$ContentItem));
            Assert.falsity((boolean)this.hasInstance(instance.getLanguage()), (String)("The bundle already contains an instance for the language " + instance.getLanguage()));
        }
        instance.setParent((ACSObject)this);
        instance.setContentSection(this.getContentSection());
        if (Assert.isEnabled()) {
            Assert.equal((Object)this, (Object)instance.getParent());
        }
    }

    public void removeInstance(ContentItem instance) {
        if (Assert.isEnabled()) {
            Assert.exists((Object)instance, (Class)(class$com$arsdigita$cms$ContentItem == null ? (class$com$arsdigita$cms$ContentItem = ContentBundle.class$("com.arsdigita.cms.ContentItem")) : class$com$arsdigita$cms$ContentItem));
            Assert.equal((Object)this, (Object)instance.getParent());
            Assert.unequal((Object)instance, (Object)this.getPrimaryInstance());
        }
        instance.setParent(null);
        if (Assert.isEnabled()) {
            Assert.truth((instance.getParent() == null ? 1 : 0) != 0);
        }
    }

    public final ContentItem getPrimaryInstance() {
        return this.getInstance(this.getDefaultLanguage());
    }

    public final ItemCollection getInstances() {
        return new ItemCollection((DataCollection)this.instances());
    }

    public final ContentItem getInstance(String language) {
        if (Assert.isEnabled()) {
            Assert.exists((Object)language, (Class)(class$java$lang$String == null ? (class$java$lang$String = ContentBundle.class$("java.lang.String")) : class$java$lang$String));
            Assert.truth((language.length() == 2 ? 1 : 0) != 0, (String)(language + " does not look like a valid language " + "code"));
        }
        DataAssociationCursor instances = this.instances();
        instances.addEqualsFilter("language", (Object)language);
        Object dataObject = null;
        if (instances.next()) {
            DataObject data = instances.getDataObject();
            if (Assert.isEnabled()) {
                // empty if block
            }
            instances.close();
            return (ContentItem)DomainObjectFactory.newInstance((DataObject)data);
        }
        instances.close();
        return null;
    }

    public final boolean hasInstance(ContentItem instance) {
        Assert.exists((Object)instance, (Class)(class$com$arsdigita$cms$ContentItem == null ? (class$com$arsdigita$cms$ContentItem = ContentBundle.class$("com.arsdigita.cms.ContentItem")) : class$com$arsdigita$cms$ContentItem));
        DataAssociationCursor instances = this.instances();
        instances.addEqualsFilter("id", (Object)instance.getID());
        return !instances.isEmpty();
    }

    public final boolean hasInstance(String language) {
        if (Assert.isEnabled()) {
            Assert.exists((Object)language, (Class)(class$java$lang$String == null ? (class$java$lang$String = ContentBundle.class$("java.lang.String")) : class$java$lang$String));
            Assert.truth((language.length() == 2 ? 1 : 0) != 0, (String)(language + " is not an ISO639 language code"));
        }
        DataAssociationCursor instances = this.instances();
        instances.addEqualsFilter("language", (Object)language);
        return !instances.isEmpty();
    }

    public final Collection getLanguages() {
        ItemCollection items = this.getInstances();
        ArrayList<String> list = new ArrayList<String>();
        while (items.next()) {
            list.add(items.getLanguage());
        }
        items.close();
        if (Assert.isEnabled()) {
            Assert.truth((!list.isEmpty() || this.getInstances().isEmpty() ? 1 : 0) != 0);
        }
        return list;
    }

    public ContentItem negotiate(Locale[] locales) {
        Assert.assertNotNull((Object)locales);
        DataAssociationCursor instancesCursor = this.instances();
        DataObject dataObject = null;
        int bestMatch = 0;
        DataObject matchingInstance = null;
        String language = null;
        while (instancesCursor.next()) {
            dataObject = instancesCursor.getDataObject();
            language = (String)dataObject.get("language");
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("negotiate: language= " + language));
            }
            if (language != null) {
                for (int i = 0; i < locales.length; ++i) {
                    if (!language.equals(locales[i].getLanguage()) || i >= bestMatch && matchingInstance != null) continue;
                    bestMatch = i;
                    matchingInstance = dataObject;
                    if (!s_log.isDebugEnabled()) continue;
                    s_log.debug((Object)("negotiate: bestMatch= " + i + ", language= " + language));
                }
            }
            if (bestMatch != 0 || matchingInstance == null) continue;
            s_log.debug((Object)"negotiate: best possible match found, exiting");
            break;
        }
        instancesCursor.close();
        if (matchingInstance != null) {
            return (ContentItem)DomainObjectFactory.newInstance(matchingInstance);
        }
        s_log.info((Object)"negotiate: no match found!");
        return null;
    }

    public ContentItem negotiate(Enumeration locales) {
        Assert.assertNotNull((Object)locales);
        Locale loc = null;
        ArrayList<String> languageCodes = new ArrayList<String>();
        int i = 0;
        while (locales.hasMoreElements()) {
            loc = (Locale)locales.nextElement();
            languageCodes.add(loc.getLanguage());
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("negotiate: pref " + i + ": " + loc.getLanguage()));
            }
            ++i;
        }
        DataAssociationCursor instances = this.instances();
        DataObject dataObject = null;
        int bestMatch = 0;
        DataObject match = null;
        String language = null;
        while (instances.next()) {
            dataObject = instances.getDataObject();
            language = (String)dataObject.get("language");
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("negotiate: language= " + language));
            }
            if (language != null) {
                for (int i2 = 0; i2 < languageCodes.size(); ++i2) {
                    if (!language.equals((String)languageCodes.get(i2)) || i2 >= bestMatch && match != null) continue;
                    bestMatch = i2;
                    match = dataObject;
                    if (!s_log.isDebugEnabled()) continue;
                    s_log.debug((Object)("negotiate: bestMatch= " + i2 + ", language= " + language));
                }
            }
            if (bestMatch != 0 || match == null) continue;
            s_log.debug((Object)"negotiate: best possible match found, exiting");
            break;
        }
        instances.close();
        return (ContentItem)DomainObjectFactory.newInstance(match);
    }

    protected void beforeSave() {
        super.beforeSave();
        ContentItem primary = this.getPrimaryInstance();
        Assert.exists((Object)((Object)this.getContentType()), (Class)(class$com$arsdigita$cms$ContentType == null ? (class$com$arsdigita$cms$ContentType = ContentBundle.class$("com.arsdigita.cms.ContentType")) : class$com$arsdigita$cms$ContentType));
        if (primary != null) {
            primary.setContentSection(this.getContentSection());
        }
    }

    protected boolean canPublishToFS() {
        return false;
    }

    protected void publishToFS() {
        throw new UnsupportedOperationException();
    }

    public ContentItem publish(LifecycleDefinition definition, Date start) {
        throw new UnsupportedOperationException();
    }

    public Lifecycle getLifecycle() {
        return null;
    }

    public void setLifecycle(Lifecycle lifecycle) {
    }

    public boolean copyProperty(CustomCopy source, Property property, ItemCopier copier) {
        if (copier.getCopyType() == 1 && INSTANCES.equals(property.getName())) {
            return true;
        }
        return super.copyProperty(source, property, copier);
    }

    public boolean copyServices(ContentItem source) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Copying services on bundle " + this.getName() + " " + this.getID() + " using source " + source.getID()));
        }
        CategoryCollection categories = source.getCategoryCollection();
        while (categories.next()) {
            Category category = categories.getCategory();
            category.addChild((ACSObject)this);
            category.save();
        }
        categories.close();
        return true;
    }

    protected void initialize() {
        super.initialize();
        this.m_wasNew = this.isNew();
    }

    protected void afterSave() {
        if (this.m_wasNew) {
            this.getPrimaryInstance().setContentSection(this.getContentSection());
        }
        super.afterSave();
    }

    private DataAssociationCursor instances() {
        DataAssociationCursor cursor = ((DataAssociation)super.get(INSTANCES)).cursor();
        return cursor;
    }

    private DataAssociationCursor instances(String version) {
        DataAssociationCursor cursor = this.instances();
        cursor.addEqualsFilter("version", (Object)version);
        return cursor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

