/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.parameters.BooleanParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.ui.workflow.CommentAddForm;
import com.arsdigita.cms.ui.workflow.TaskRequestLocal;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Engine;
import com.arsdigita.workflow.simple.Task;
import com.arsdigita.workflow.simple.TaskException;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public final class TaskFinishForm
extends CommentAddForm {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/TaskFinishForm.java#12 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$workflow$TaskFinishForm == null ? (class$com$arsdigita$cms$ui$workflow$TaskFinishForm = TaskFinishForm.class$("com.arsdigita.cms.ui.workflow.TaskFinishForm")) : class$com$arsdigita$cms$ui$workflow$TaskFinishForm));
    private final TaskRequestLocal m_task;
    private final Label m_approvePrompt;
    private final RadioGroup m_approve;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$workflow$TaskFinishForm;

    public TaskFinishForm(TaskRequestLocal task) {
        super(task);
        this.m_task = task;
        this.m_approve = new RadioGroup((ParameterModel)new BooleanParameter("approve"));
        this.m_approve.addOption(new Option("true", TaskFinishForm.lz("cms.ui.workflow.task.approve")));
        this.m_approve.addOption(new Option("false", TaskFinishForm.lz("cms.ui.workflow.task.reject")));
        this.m_approvePrompt = new Label(TaskFinishForm.gz("cms.ui.workflow.task.approve_prompt"));
        this.addComponent((Component)this.m_approvePrompt);
        this.addComponent((Component)this.m_approve);
        this.addInitListener(new InitListener());
        this.addValidationListener(new ValidationListener());
        this.addProcessListener(new ProcessListener());
    }

    private static boolean requiresApproval(CMSTask task) {
        return !task.getTaskType().equals(CMSTask.AUTHOR);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ProcessListener
    implements FormProcessListener {
        private ProcessListener() {
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            s_log.debug((Object)"Processing task finish");
            PageState state = e.getPageState();
            CMSTask task = TaskFinishForm.this.m_task.getTask(state);
            boolean finishedTask = false;
            if (TaskFinishForm.requiresApproval(task)) {
                s_log.debug((Object)"The task requires approval; checking to see if it's approved");
                Boolean isApproved = (Boolean)TaskFinishForm.this.m_approve.getValue(state);
                if (isApproved.equals(Boolean.TRUE)) {
                    s_log.debug((Object)"The task is approved; finishing the task");
                    try {
                        task.finish(Web.getContext().getUser());
                        finishedTask = true;
                    }
                    catch (TaskException te) {
                        throw new UncheckedWrapperException((Throwable)te);
                    }
                } else {
                    s_log.debug((Object)"The task is rejected; reenabling dependent tasks");
                    Iterator iter = task.getDependencies();
                    while (iter.hasNext()) {
                        Task dependent = (Task)iter.next();
                        if (s_log.isDebugEnabled()) {
                            s_log.debug((Object)("Reenabling task " + dependent.getLabel()));
                        }
                        dependent.enable();
                        dependent.save();
                    }
                }
            } else {
                s_log.debug((Object)"The task does not require approval; finishing it");
                try {
                    task.finish(Web.getContext().getUser());
                    finishedTask = true;
                }
                catch (TaskException te) {
                    throw new UncheckedWrapperException((Throwable)te);
                }
            }
            if (finishedTask) {
                Iterator tasks = Engine.getInstance().getEnabledTasks(Web.getContext().getUser(), task.getParentID()).iterator();
                while (tasks.hasNext()) {
                    CMSTask thisTask = (CMSTask)((Object)tasks.next());
                    if (!thisTask.getTaskType().equals(CMSTask.DEPLOY)) continue;
                    throw new RedirectSignal(URL.there((HttpServletRequest)state.getRequest(), (String)ContentItemPage.getItemURL(task.getItem(), ContentItemPage.PUBLISHING_TAB)), true);
                }
                if (ContentSection.getConfig().getUseStreamlinedCreation()) {
                    throw new RedirectSignal(URL.there((HttpServletRequest)state.getRequest(), (String)Utilities.getWorkspaceURL()), true);
                }
            }
        }
    }

    private class ValidationListener
    implements FormValidationListener {
        private ValidationListener() {
        }

        public final void validate(FormSectionEvent e) throws FormProcessException {
            s_log.debug((Object)"Validating task finish");
            PageState state = e.getPageState();
            CMSTask task = TaskFinishForm.this.m_task.getTask(state);
            if (TaskFinishForm.requiresApproval(task) && TaskFinishForm.this.m_approve.getValue(state) == null) {
                throw new FormProcessException(TaskFinishForm.lz("cms.ui.workflow.task.approval_or_reject_required"));
            }
        }
    }

    private class InitListener
    implements FormInitListener {
        private InitListener() {
        }

        public final void init(FormSectionEvent e) {
            s_log.debug((Object)"Initializing task finish");
            PageState state = e.getPageState();
            if (TaskFinishForm.this.isVisible(state)) {
                CMSTask task = TaskFinishForm.this.m_task.getTask(state);
                if (TaskFinishForm.requiresApproval(task)) {
                    TaskFinishForm.this.m_approvePrompt.setVisible(state, true);
                    TaskFinishForm.this.m_approve.setVisible(state, true);
                } else {
                    TaskFinishForm.this.m_approvePrompt.setVisible(state, false);
                    TaskFinishForm.this.m_approve.setVisible(state, false);
                }
            }
        }
    }
}

