/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.cms.ui.workflow.WorkflowRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Engine;
import com.arsdigita.workflow.simple.Workflow;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public final class AssignedTaskSection
extends Section {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/AssignedTaskSection.java#8 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$workflow$AssignedTaskSection == null ? (class$com$arsdigita$cms$ui$workflow$AssignedTaskSection = AssignedTaskSection.class$("com.arsdigita.cms.ui.workflow.AssignedTaskSection")) : class$com$arsdigita$cms$ui$workflow$AssignedTaskSection));
    private final WorkflowRequestLocal m_workflow;
    private final WorkflowFacade m_facade;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$workflow$AssignedTaskSection;

    public AssignedTaskSection(WorkflowRequestLocal workflow, Component subject) {
        super(AssignedTaskSection.gz("cms.ui.workflow.task.assigned"));
        this.m_workflow = workflow;
        this.m_facade = new WorkflowFacade(this.m_workflow);
        ActionGroup group = new ActionGroup();
        this.setBody((Component)group);
        group.setSubject(subject);
        group.addAction((Component)new LockLink());
        group.addAction((Component)new UnlockLink());
    }

    public final boolean isVisible(PageState state) {
        return this.m_workflow.getWorkflow(state) != null;
    }

    protected static final GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    protected static final String lz(String key) {
        return (String)AssignedTaskSection.gz(key).localize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class WorkflowFacade {
        private final WorkflowRequestLocal m_flow;
        private final TaskListRequestLocal m_tasks;

        WorkflowFacade(WorkflowRequestLocal flow) {
            this.m_flow = flow;
            this.m_tasks = new TaskListRequestLocal();
        }

        final void lockTasks(PageState state) {
            Iterator iter = this.m_tasks.getTasks(state).iterator();
            while (iter.hasNext()) {
                CMSTask task = (CMSTask)((Object)iter.next());
                if (!this.relevant(task) || task.isLocked()) continue;
                task.lock(Web.getContext().getUser());
                task.save();
            }
        }

        final void unlockTasks(PageState state) {
            Iterator iter = this.m_tasks.getTasks(state).iterator();
            while (iter.hasNext()) {
                CMSTask task = (CMSTask)((Object)iter.next());
                if (!this.relevant(task) || !task.isLocked()) continue;
                task.unlock(Web.getContext().getUser());
                task.save();
            }
        }

        final boolean tasksLocked(PageState state) {
            Iterator iter = this.m_tasks.getTasks(state).iterator();
            while (iter.hasNext()) {
                CMSTask task = (CMSTask)((Object)iter.next());
                if (!this.relevant(task) || task.isLocked()) continue;
                return false;
            }
            return true;
        }

        final boolean tasksExist(PageState state) {
            return !this.m_tasks.getTasks(state).isEmpty();
        }

        private boolean relevant(CMSTask task) {
            return task.getTaskType().equals(CMSTask.AUTHOR) || task.getTaskType().equals(CMSTask.EDIT);
        }

        private class TaskListRequestLocal
        extends RequestLocal {
            private TaskListRequestLocal() {
            }

            protected final Object initialValue(PageState state) {
                Workflow workflow = WorkflowFacade.this.m_flow.getWorkflow(state);
                Engine engine = Engine.getInstance();
                return engine.getEnabledTasks(Web.getContext().getUser(), workflow.getID());
            }

            final ArrayList getTasks(PageState state) {
                return (ArrayList)this.get(state);
            }
        }
    }

    private class UnlockLink
    extends ActionLink {
        UnlockLink() {
            super((Component)new Label(AssignedTaskSection.gz("cms.ui.workflow.task.assigned.unlock_all")));
            this.addActionListener(new Listener());
        }

        public final boolean isVisible(PageState state) {
            return AssignedTaskSection.this.m_facade.tasksExist(state) && AssignedTaskSection.this.m_facade.tasksLocked(state);
        }

        private class Listener
        implements ActionListener {
            private Listener() {
            }

            public final void actionPerformed(ActionEvent e) {
                AssignedTaskSection.this.m_facade.unlockTasks(e.getPageState());
            }
        }
    }

    private class LockLink
    extends ActionLink {
        LockLink() {
            super((Component)new Label(AssignedTaskSection.gz("cms.ui.workflow.task.assigned.lock_all")));
            this.addActionListener(new Listener());
        }

        public final boolean isVisible(PageState state) {
            return AssignedTaskSection.this.m_facade.tasksExist(state) && !AssignedTaskSection.this.m_facade.tasksLocked(state);
        }

        private class Listener
        implements ActionListener {
            private Listener() {
            }

            public final void actionPerformed(ActionEvent e) {
                AssignedTaskSection.this.m_facade.lockTasks(e.getPageState());
            }
        }
    }
}

