/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.role;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ui.BaseForm;
import com.arsdigita.cms.ui.role.RoleRequestLocal;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Role;
import com.arsdigita.kernel.RoleCollection;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class BaseRoleForm
extends BaseForm {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/role/BaseRoleForm.java#10 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$role$BaseRoleForm == null ? (class$com$arsdigita$cms$ui$role$BaseRoleForm = BaseRoleForm.class$("com.arsdigita.cms.ui.role.BaseRoleForm")) : class$com$arsdigita$cms$ui$role$BaseRoleForm));
    final BaseForm.Name m_name;
    final BaseForm.Description m_description;
    CheckboxGroup m_privileges;
    private boolean m_useViewersGroup;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$role$BaseRoleForm;

    public BaseRoleForm(String key, GlobalizedMessage message, boolean useViewersGroup) {
        super(key, message);
        this.m_useViewersGroup = useViewersGroup;
        this.m_name = new BaseForm.Name("label", 200, true);
        this.addField(BaseRoleForm.gz("cms.ui.name"), (Component)this.m_name);
        this.m_description = new BaseForm.Description("description", 4000, false);
        this.addField(BaseRoleForm.gz("cms.ui.description"), (Component)this.m_description);
        this.m_privileges = new CheckboxGroup("privileges");
        this.addField(BaseRoleForm.gz("cms.ui.role.privileges"), (Component)this.m_privileges);
        try {
            this.m_privileges.addPrintListener((PrintListener)new PrivilegePrinter());
        }
        catch (TooManyListenersException tmle) {
            throw new UncheckedWrapperException((Throwable)tmle);
        }
        this.addAction(new BaseForm.Finish());
        this.addAction(new BaseForm.Cancel());
        this.addSecurityListener("staff_admin");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NameUniqueListener
    implements ParameterListener {
        private final RoleRequestLocal m_role;

        NameUniqueListener(RoleRequestLocal role) {
            this.m_role = role;
        }

        public final void validate(ParameterEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            ContentSection section = CMS.getContext().getContentSection();
            String name = (String)BaseRoleForm.this.m_name.getValue(state);
            RoleCollection roles = BaseRoleForm.this.m_useViewersGroup ? section.getViewersGroup().getRoles() : section.getStaffGroup().getRoles();
            while (roles.next()) {
                Role role = roles.getRole();
                if (!roles.getRole().getName().equalsIgnoreCase(name) || this.m_role != null && this.m_role.getRole(state).equals((Object)role)) continue;
                roles.close();
                throw new FormProcessException(BaseRoleForm.lz("cms.ui.role.name_not_unique"));
            }
            roles.close();
        }
    }

    private class PrivilegePrinter
    implements PrintListener {
        private PrivilegePrinter() {
        }

        public final void prepare(PrintEvent e) {
            CheckboxGroup target = (CheckboxGroup)e.getTarget();
            PageState state = e.getPageState();
            DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.getPrivileges");
            query.addOrder("sortOrder");
            while (query.next()) {
                target.addOption(new Option((String)query.get("privilege"), (String)query.get("prettyName")));
            }
            query.close();
        }
    }
}

