/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.portlet;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.portal.PortletConfigFormSection;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.MultilingualItemResolver;
import com.arsdigita.cms.portlet.ContentItemPortlet;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.portal.Portlet;
import com.arsdigita.web.URL;
import org.apache.log4j.Logger;

public class ContentItemPortletEditor
extends PortletConfigFormSection {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$portlet$ContentItemPortletEditor == null ? (class$com$arsdigita$cms$ui$portlet$ContentItemPortletEditor = ContentItemPortletEditor.class$("com.arsdigita.cms.ui.portlet.ContentItemPortletEditor")) : class$com$arsdigita$cms$ui$portlet$ContentItemPortletEditor));
    private TextField m_url;
    private RequestLocal m_contentItem = new RequestLocal(){

        protected Object initialValue(PageState ps) {
            ContentItem item;
            String dp;
            String url = (String)ContentItemPortletEditor.this.m_url.getValue(ps);
            if (url.startsWith(dp = URL.getDispatcherPath())) {
                url = url.substring(dp.length());
            }
            SiteNode node = null;
            try {
                node = SiteNode.getSiteNode((String)url);
            }
            catch (DataObjectNotFoundException ex) {
                s_log.debug((Object)("Couldn't fetch sitenode for " + url));
                return null;
            }
            ContentSection section = null;
            section = ContentSection.getSectionFromNode(node);
            ItemResolver resolver = section.getItemResolver();
            String base = node.getURL();
            url = url.substring(base.length(), url.length());
            if (url.endsWith(".jsp")) {
                url = url.substring(0, url.length() - 4);
            }
            if ((item = resolver.getItem(section, url, "live")) == null) {
                s_log.debug((Object)("Couldn't resolve item " + url));
                return null;
            }
            return item;
        }
    };
    static /* synthetic */ Class class$com$arsdigita$cms$ui$portlet$ContentItemPortletEditor;

    public ContentItemPortletEditor(ResourceType resType, RequestLocal parentAppRL) {
        super(resType, parentAppRL);
    }

    public ContentItemPortletEditor(RequestLocal application) {
        super(application);
    }

    public void addWidgets() {
        super.addWidgets();
        this.m_url = new TextField((ParameterModel)new StringParameter("url"));
        this.m_url.setSize(50);
        this.m_url.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_url.addValidationListener((ParameterListener)new StringInRangeValidationListener(1, 250));
        this.add((Component)new Label("Item URL:", "b"), 4);
        this.add((Component)this.m_url);
    }

    public void initWidgets(PageState state, Portlet portlet) throws FormProcessException {
        super.initWidgets(state, portlet);
        if (portlet != null) {
            ContentItemPortlet myportlet = (ContentItemPortlet)portlet;
            MultilingualItemResolver resolver = new MultilingualItemResolver();
            ContentItem item = myportlet.getContentItem();
            if (item != null) {
                this.m_url.setValue(state, (Object)resolver.generateItemURL(state, item, item.getContentSection(), "live"));
            } else {
                this.m_url.setValue(state, (Object)"");
            }
        }
    }

    public void validateWidgets(PageState state, Portlet portlet) throws FormProcessException {
        super.validateWidgets(state, portlet);
        Object item = this.m_contentItem.get(state);
        if (item == null) {
            throw new FormProcessException("cannot find content item");
        }
    }

    public void processWidgets(PageState state, Portlet portlet) throws FormProcessException {
        super.processWidgets(state, portlet);
        ContentItem item = (ContentItem)this.m_contentItem.get(state);
        ContentItemPortlet myportlet = (ContentItemPortlet)portlet;
        myportlet.setContentItem(item);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

