/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.permissions;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.UserAddForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.dispatcher.AccessDeniedException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class ObjectAddAdmin
extends UserAddForm {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/permissions/ObjectAddAdmin.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private ACSObjectSelectionModel m_object;
    private static final String NAME_FILTER = "upper(firstName || lastName || email) like '%' || upper(:search) || '%'";

    public ObjectAddAdmin(ACSObjectSelectionModel object, TextField search) {
        super((Widget)search, "ObjectAddAdmin");
        this.m_object = object;
    }

    protected DataQuery makeQuery(PageState s) {
        Assert.truth((boolean)this.m_object.isSelected(s));
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.objectAdminUserSearch");
        ACSObject object = (ACSObject)this.m_object.getSelectedObject(s);
        String searchQuery = (String)this.getSearchWidget().getValue(s);
        this.makeFilter(query, object.getID(), searchQuery);
        query.addOrder("upper(lastName), upper(firstName), upper(email)");
        return query;
    }

    private void makeFilter(DataQuery dq, BigDecimal folderId, String search) {
        dq.setParameter("excludedObjectId", (Object)folderId);
        if (search != null) {
            dq.clearFilter();
            Filter filter = dq.addFilter(NAME_FILTER);
            filter.set("search", (Object)search);
        }
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        FormData data = event.getFormData();
        PageState state = event.getPageState();
        Assert.truth((boolean)this.m_object.isSelected(state));
        SecurityManager sm = Utilities.getSecurityManager(state);
        boolean isAdmin = sm.canAccess(state.getRequest(), "staff_admin");
        if (!isAdmin) {
            throw new AccessDeniedException((String)GlobalizationUtil.globalize("cms.ui.permissions.not_an_object_adminstrator").localize());
        }
        String[] users = (String[])data.get((Object)"users");
        if (users != null) {
            ACSObject object = (ACSObject)this.m_object.getSelectedObject(state);
            try {
                for (int i = 0; i < users.length; ++i) {
                    User user = User.retrieve((BigDecimal)new BigDecimal(users[i]));
                    PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, object, (Party)user);
                    if (PermissionService.checkPermission((PermissionDescriptor)perm)) continue;
                    PermissionService.grantPermission((PermissionDescriptor)perm);
                }
            }
            catch (DataObjectNotFoundException e) {
                throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.permissions.cannot_add_user").localize(), (Throwable)e);
            }
        } else {
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.permissions.no_users_were_selected").localize());
        }
        this.fireCompletionEvent(state);
    }
}

