/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.lifecycle.Duration;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.PhaseDefinition;
import com.arsdigita.cms.lifecycle.PhaseDefinitionCollection;
import com.arsdigita.cms.ui.lifecycle.LifecycleDefinitionRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Assert;
import com.arsdigita.util.LockableImpl;

class PhaseTableModelBuilder
extends LockableImpl
implements TableModelBuilder {
    private final LifecycleDefinitionRequestLocal m_cycle;

    public PhaseTableModelBuilder(LifecycleDefinitionRequestLocal cycle) {
        this.m_cycle = cycle;
    }

    public final TableModel makeModel(Table table, PageState state) {
        return new PhaseTableModel(this.m_cycle.getLifecycleDefinition(state));
    }

    private static GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    private static String lz(String key) {
        return (String)PhaseTableModelBuilder.gz(key).localize();
    }

    private static class PhaseTableModel
    implements TableModel {
        private PhaseDefinition m_phase;
        private final PhaseDefinitionCollection m_phases;

        public PhaseTableModel(LifecycleDefinition cycle) {
            this.m_phases = cycle.getPhaseDefinitions();
            this.m_phases.addOrder("defaultDelay, defaultDuration");
            this.m_phase = null;
        }

        public final int getColumnCount() {
            return 6;
        }

        public final boolean nextRow() {
            if (this.m_phases.next()) {
                this.m_phase = this.m_phases.getPhaseDefinition();
                return true;
            }
            return false;
        }

        public final Object getElementAt(int column) {
            Assert.assertNotNull((Object)((Object)this.m_phase), (String)"PhaseDefinition m_phase");
            switch (column) {
                case 0: {
                    return this.m_phase.getLabel();
                }
                case 1: {
                    return this.m_phase.getDescription();
                }
                case 2: {
                    return Duration.formatDuration(this.m_phase.getDefaultDelay());
                }
                case 3: {
                    Integer duration = this.m_phase.getDefaultDuration();
                    if (duration == null) {
                        return PhaseTableModelBuilder.lz("cms.ui.lifecycle.forever");
                    }
                    return Duration.formatDuration(duration);
                }
                case 4: {
                    return PhaseTableModelBuilder.lz("cms.ui.lifecycle.phase.edit");
                }
                case 5: {
                    return PhaseTableModelBuilder.lz("cms.ui.lifecycle.phase.delete");
                }
            }
            throw new IllegalStateException();
        }

        public Object getKeyAt(int columnIndex) {
            if (this.m_phase == null) {
                throw new IllegalStateException();
            }
            return this.m_phase.getID();
        }
    }
}

