/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.NumberInRangeValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.lifecycle.Duration;
import com.arsdigita.cms.lifecycle.PhaseDefinition;
import com.arsdigita.cms.lifecycle.PhaseDefinitionCollection;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.FormSecurityListener;
import com.arsdigita.cms.ui.lifecycle.PhaseRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;

class EditPhaseForm
extends CMSForm {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/lifecycle/EditPhaseForm.java#8 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final String PHASE_ID = "id";
    private static final String LABEL = "label";
    private static final String DESCRIPTION = "description";
    private static final String DELAY_DAYS = "delay_days";
    private static final String DELAY_HOURS = "delay_hours";
    private static final String DELAY_MINUTES = "delay_minutes";
    private static final String DURATION_DAYS = "duration_days";
    private static final String DURATION_HOURS = "duration_hours";
    private static final String DURATION_MINUTES = "duration_minutes";
    private static final String SUBMIT = "submit";
    private static final String CANCEL = "cancel";
    private final PhaseRequestLocal m_phase;
    private TextField m_label;
    private TextArea m_description;
    private TextField m_delayDays;
    private TextField m_delayHours;
    private TextField m_delayMinutes;
    private TextField m_durDays;
    private TextField m_durHours;
    private TextField m_durMinutes;
    private Submit m_submit;
    private Submit m_cancel;

    public EditPhaseForm(PhaseRequestLocal phase) {
        super("EditPhaseDefinition");
        this.m_phase = phase;
        this.add((Component)new Label());
        this.add((Component)new FormErrorDisplay((Form)this));
        this.add((Component)new Label(EditPhaseForm.gz("cms.ui.name")));
        this.m_label = new TextField((ParameterModel)new TrimmedStringParameter(LABEL));
        this.m_label.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        this.m_label.setSize(40);
        this.m_label.setMaxLength(1000);
        this.add((Component)this.m_label);
        this.add((Component)new Label(EditPhaseForm.gz("cms.ui.description")));
        this.m_description = new TextArea((ParameterModel)new TrimmedStringParameter(DESCRIPTION));
        this.m_description.addValidationListener((ParameterListener)new StringLengthValidationListener(4000));
        this.m_description.setCols(40);
        this.m_description.setRows(5);
        this.m_description.setWrap(2);
        this.add((Component)this.m_description);
        this.m_delayDays = new TextField((ParameterModel)new IntegerParameter(DELAY_DAYS));
        this.m_delayDays.addValidationListener((ParameterListener)new NumberInRangeValidationListener(0L, 21900L));
        this.m_delayDays.setSize(7);
        this.m_delayDays.setClassAttr("DaysField");
        this.m_delayHours = new TextField((ParameterModel)new IntegerParameter(DELAY_HOURS));
        this.m_delayHours.addValidationListener((ParameterListener)new NumberInRangeValidationListener(0L, 168L));
        this.m_delayHours.setClassAttr("HoursField");
        this.m_delayHours.setSize(7);
        this.m_delayMinutes = new TextField((ParameterModel)new IntegerParameter(DELAY_MINUTES));
        this.m_delayMinutes.addValidationListener((ParameterListener)new NumberInRangeValidationListener(0L, 1440L));
        this.m_delayMinutes.setSize(7);
        this.m_delayMinutes.setClassAttr("MinutesField");
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.lifecycle.start_delay")));
        SimpleContainer de = new SimpleContainer();
        de.add((Component)new Label(EditPhaseForm.gz("cms.ui.lifecycle.phase.days")));
        de.add((Component)this.m_delayDays);
        de.add((Component)new Label(EditPhaseForm.gz("cms.ui.lifecycle.phase.hours")));
        de.add((Component)this.m_delayHours);
        de.add((Component)new Label(EditPhaseForm.gz("cms.ui.lifecycle.phase.mins")));
        de.add((Component)this.m_delayMinutes);
        this.add((Component)de);
        this.m_durDays = new TextField((ParameterModel)new IntegerParameter(DURATION_DAYS));
        this.m_durDays.addValidationListener((ParameterListener)new NumberInRangeValidationListener(0L, 21900L));
        this.m_durDays.setSize(7);
        this.m_durDays.setClassAttr("DaysField");
        this.m_durHours = new TextField((ParameterModel)new IntegerParameter(DURATION_HOURS));
        this.m_durHours.addValidationListener((ParameterListener)new NumberInRangeValidationListener(0L, 168L));
        this.m_durHours.setSize(7);
        this.m_durHours.setClassAttr("HoursField");
        this.m_durMinutes = new TextField((ParameterModel)new IntegerParameter(DURATION_MINUTES));
        this.m_durMinutes.addValidationListener((ParameterListener)new NumberInRangeValidationListener(0L, 1440L));
        this.m_durMinutes.setSize(7);
        this.m_durMinutes.setClassAttr("MinutesField");
        this.add((Component)new Label(EditPhaseForm.gz("cms.ui.lifecycle.duration")));
        SimpleContainer du = new SimpleContainer();
        du.add((Component)new Label(EditPhaseForm.gz("cms.ui.lifecycle.phase.days")));
        du.add((Component)this.m_durDays);
        du.add((Component)new Label(EditPhaseForm.gz("cms.ui.lifecycle.phase.hours")));
        du.add((Component)this.m_durHours);
        du.add((Component)new Label(EditPhaseForm.gz("cms.ui.lifecycle.phase.mins")));
        du.add((Component)this.m_durMinutes);
        this.add((Component)du);
        SimpleContainer s = new SimpleContainer();
        this.m_submit = new Submit(SUBMIT);
        this.m_submit.setButtonLabel("Edit Phase");
        s.add((Component)this.m_submit);
        this.m_cancel = new Submit(CANCEL);
        this.m_cancel.setButtonLabel("Cancel");
        s.add((Component)this.m_cancel);
        this.add((Component)s, 66);
        this.addInitListener(new FormInitListener(){

            public final void init(FormSectionEvent event) throws FormProcessException {
                EditPhaseForm.this.initializePhaseDefinition(event.getPageState());
            }
        });
        this.addSubmissionListener(new FormSecurityListener("lifecycle_admin"));
        this.addValidationListener(new FormValidationListener(){

            public final void validate(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                EditPhaseForm.this.validateDuration(state);
                EditPhaseForm.this.validateUniqueName(state);
            }
        });
        this.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent event) throws FormProcessException {
                EditPhaseForm.this.updatePhaseDefinition(event.getPageState());
            }
        });
    }

    public boolean isCancelled(PageState state) {
        return this.m_cancel.isSelected(state);
    }

    private void initializePhaseDefinition(PageState state) throws FormProcessException {
        PhaseDefinition pd = this.m_phase.getPhase(state);
        this.m_label.setValue(state, (Object)pd.getLabel());
        this.m_description.setValue(state, (Object)pd.getDescription());
        Integer[] delay = Duration.formatDHM(pd.getDefaultDelay());
        this.m_delayDays.setValue(state, (Object)delay[0]);
        this.m_delayHours.setValue(state, (Object)delay[1]);
        this.m_delayMinutes.setValue(state, (Object)delay[2]);
        Integer duration = pd.getDefaultDuration();
        if (duration != null) {
            Integer[] dhm = Duration.formatDHM(duration);
            this.m_durDays.setValue(state, (Object)dhm[0]);
            this.m_durHours.setValue(state, (Object)dhm[1]);
            this.m_durMinutes.setValue(state, (Object)dhm[2]);
        }
    }

    private void updatePhaseDefinition(PageState state) throws FormProcessException {
        String label = (String)this.m_label.getValue(state);
        String description = (String)this.m_description.getValue(state);
        Integer delayDays = (Integer)this.m_delayDays.getValue(state);
        Integer delayHours = (Integer)this.m_delayHours.getValue(state);
        Integer delayMinutes = (Integer)this.m_delayMinutes.getValue(state);
        Integer durDays = (Integer)this.m_durDays.getValue(state);
        Integer durHours = (Integer)this.m_durHours.getValue(state);
        Integer durMinutes = (Integer)this.m_durMinutes.getValue(state);
        PhaseDefinition pd = this.m_phase.getPhase(state);
        pd.setLabel(label);
        pd.setDescription(description);
        pd.setDefaultDelay(delayDays, delayHours, delayMinutes);
        pd.setDefaultDuration(durDays, durHours, durMinutes);
        pd.save();
    }

    private void validateUniqueName(PageState state) throws FormProcessException {
        String newLabel = (String)this.m_label.getValue(state);
        PhaseDefinition pd = this.m_phase.getPhase(state);
        PhaseDefinitionCollection phaseDefs = pd.getLifecycleDefinition().getPhaseDefinitions();
        if (!pd.getLabel().equalsIgnoreCase(newLabel)) {
            while (phaseDefs.next()) {
                PhaseDefinition phaseDef = phaseDefs.getPhaseDefinition();
                if (!phaseDef.getLabel().equalsIgnoreCase(newLabel)) continue;
                phaseDefs.close();
                throw new FormProcessException(EditPhaseForm.lz("cms.ui.lifecycle.phase.name_not_unique"));
            }
        }
    }

    private void validateDuration(PageState state) throws FormProcessException {
        int minutes;
        int hours;
        Integer durDays = (Integer)this.m_durDays.getValue(state);
        Integer durHours = (Integer)this.m_durHours.getValue(state);
        Integer durMinutes = (Integer)this.m_durMinutes.getValue(state);
        if (durDays == null && durHours == null && durMinutes == null) {
            return;
        }
        int days = durDays != null ? durDays : 0;
        if (days + (hours = durHours != null ? durHours : 0) + (minutes = durMinutes != null ? durMinutes : 0) == 0) {
            throw new FormProcessException(EditPhaseForm.lz("cms.ui.phase.duration_negative"));
        }
    }

    private static GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    private static String lz(String key) {
        return (String)EditPhaseForm.gz(key).localize();
    }
}

