/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.item;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.FormatStandards;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Graph;
import com.arsdigita.util.GraphSet;
import com.arsdigita.util.Graphs;
import com.arsdigita.versioning.Transaction;
import com.arsdigita.versioning.TransactionCollection;
import com.arsdigita.versioning.Versions;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Engine;
import com.arsdigita.workflow.simple.Task;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.TaskComment;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;

public class Summary
extends CMSContainer {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/item/Summary.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String SUMMARY = "itemAdminSummary";
    private static final String RESTART_WORKFLOW = "restartWorkflow";
    private final ItemSelectionModel m_item;

    public Summary(ItemSelectionModel m) {
        this.m_item = m;
    }

    public void generateXML(PageState state, Element parent) {
        if (this.isVisible(state)) {
            ContentItem item = this.getContentItem(state);
            ContentSection section = this.getContentSection(state);
            User user = Web.getContext().getUser();
            Element itemElement = new Element("cms:itemSummary", "http://www.arsdigita.com/cms/1.0");
            itemElement.addAttribute("name", item.getName());
            String objectType = item.getObjectType().getName();
            String descriptionAttribute = "";
            if (objectType.equals("NewsItem") || objectType.equals("Article")) {
                descriptionAttribute = "lead";
            } else if (objectType.equals("FileStorageItem") || objectType.equals("Minutes")) {
                descriptionAttribute = "description";
            } else if (objectType.equals("Job")) {
                descriptionAttribute = "jobDescription";
            } else if (objectType.equals("MultiPartArticle") || objectType.equals("Agenda") || objectType.equals("PressRelease") || objectType.equals("Service")) {
                descriptionAttribute = "summary";
            }
            if (!descriptionAttribute.equals("")) {
                itemElement.addAttribute("description", (String)DomainServiceInterfaceExposer.get((DomainObject)item, (String)descriptionAttribute));
            }
            try {
                ContentPage page = new ContentPage(item.getID());
                itemElement.addAttribute("title", page.getTitle());
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
            Element subjectsElement = new Element("cms:subjectCategories", "http://www.arsdigita.com/cms/1.0");
            itemElement.addContent(subjectsElement);
            Object itemCategory = null;
            Category subjectCategory = Category.getRootForObject((ACSObject)section, (String)"subject");
            if (subjectCategory != null) {
                CategoryCollection categories = item.getCategoryCollection();
                while (categories.next()) {
                    Category category = categories.getCategory();
                    CategoryCollection parents = category.getDefaultAscendants();
                    parents.addOrder("defaultAncestors");
                    if (!parents.next()) continue;
                    Category parentCategory = parents.getCategory();
                    if (parentCategory.equals((Object)subjectCategory)) {
                        Element subjectElement = new Element("cms:subjectCategory", "http://www.arsdigita.com/cms/1.0");
                        subjectElement.addAttribute("name", category.getName());
                        subjectElement.setText(category.getQualifiedName(" -&gt; ", true));
                        subjectsElement.addContent(subjectElement);
                    }
                    parents.close();
                }
            }
            Element linkElement = new Element("cms:linkSummary", "http://www.arsdigita.com/cms/1.0");
            linkElement.addAttribute("url", "/redirect?oid=" + item.getDraftVersion().getOID() + "&context=" + "live");
            Element workflowElement = new Element("cms:workflowSummary", "http://www.arsdigita.com/cms/1.0");
            Workflow workflow = Workflow.getObjectWorkflow((ACSObject)item);
            SecurityManager sm = CMS.getContext().getSecurityManager();
            if (this.canWorkflowBeExtended(user, item, workflow)) {
                try {
                    state.setControlEvent((Component)this, RESTART_WORKFLOW, item.getID().toString());
                    workflowElement.addAttribute("restartWorkflowURL", state.stateAsURL());
                    state.clearControlEvent();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (workflow == null) {
                workflowElement.addAttribute("noWorkflow", "1");
            } else {
                List l;
                Iterator it;
                workflowElement.addAttribute("name", workflow.getDisplayName());
                TaskCollection tc = workflow.getTaskCollection();
                GraphSet g = new GraphSet();
                while (tc.next()) {
                    Task t = tc.getTask();
                    TaskCollection deps = t.getRequiredTasks();
                    StringBuffer buffer = new StringBuffer();
                    while (deps.next()) {
                        Task dep = deps.getTask();
                        g.addEdge((Object)t, (Object)dep, null);
                        buffer.append(dep.getLabel() + ", ");
                    }
                    int len = buffer.length();
                    if (len >= 2) {
                        buffer.setLength(len - 2);
                    } else {
                        g.addNode((Object)t);
                    }
                    deps.close();
                }
                ArrayList<Task> taskList = new ArrayList<Task>();
                while (g.nodeCount() > 0 && (it = (l = Graphs.getSinkNodes((Graph)g)).iterator()).hasNext()) {
                    Task t = (Task)it.next();
                    taskList.add(0, t);
                    g.removeNode((Object)t);
                }
                Iterator tasks = taskList.iterator();
                while (tasks.hasNext()) {
                    Task task = (Task)tasks.next();
                    Element taskElement = new Element("cms:task", "http://www.arsdigita.com/cms/1.0");
                    taskElement.addAttribute("name", task.getDisplayName());
                    taskElement.addAttribute("state", task.getStateString());
                    Iterator comments = task.getComments();
                    while (comments.hasNext()) {
                        TaskComment comment = (TaskComment)comments.next();
                        Element commentElement = new Element("cms:taskComment", "http://www.arsdigita.com/cms/1.0");
                        User author = comment.getUser();
                        String authorName = "Anonymous";
                        if (author != null) {
                            authorName = author.getDisplayName();
                        }
                        commentElement.addAttribute("author", authorName);
                        commentElement.addAttribute("comment", comment.getComment());
                        commentElement.addAttribute("date", FormatStandards.formatDate((Date)comment.getDate()));
                        taskElement.addContent(commentElement);
                    }
                    workflowElement.addContent(taskElement);
                }
            }
            Element transactionElement = new Element("cms:transactionSummary", "http://www.arsdigita.com/cms/1.0");
            transactionElement.addAttribute("creationDate", FormatStandards.formatDate((Date)item.getCreationDate()));
            transactionElement.addAttribute("lastModifiedDate", FormatStandards.formatDate((Date)item.getLastModifiedDate()));
            TransactionCollection transactions = Versions.getTaggedTransactions((OID)item.getOID());
            while (transactions.next()) {
                Transaction transaction = transactions.getTransaction();
                Element element = new Element("cms:transaction", "http://www.arsdigita.com/cms/1.0");
                element.addAttribute("date", FormatStandards.formatDate((Date)transaction.getTimestamp()));
                String authorName = "Anonymous";
                User author = transaction.getUser();
                if (author != null) {
                    authorName = author.getDisplayName();
                }
                element.addAttribute("author", authorName);
                String url = section.getItemResolver().generateItemURL(state, item, section, "preview") + "?transID=" + transaction.getID();
                element.addAttribute("url", url);
                transactionElement.addContent(element);
            }
            transactions.close();
            Element categoryElement = new Element("cms:categorySummary", "http://www.arsdigita.com/cms/1.0");
            CategoryCollection categories = item.getCategoryCollection();
            while (categories.next()) {
                Category category = categories.getCategory();
                Element element = new Element("cms:category", "http://www.arsdigita.com/cms/1.0");
                element.setText(category.getQualifiedName(" -&gt; ", true));
                categoryElement.addContent(element);
            }
            categories.close();
            Element lifecycleElement = new Element("cms:lifecycleSummary", "http://www.arsdigita.com/cms/1.0");
            Lifecycle lifecycle = item.getLifecycle();
            if (lifecycle == null) {
                lifecycleElement.addAttribute("noLifecycle", "1");
            } else {
                lifecycleElement.addAttribute("name", lifecycle.getLabel());
                lifecycleElement.addAttribute("startDate", FormatStandards.formatDate((Date)lifecycle.getStartDate()));
                Date endDate = lifecycle.getEndDate();
                if (endDate == null) {
                    lifecycleElement.addAttribute("endDateString", "last forever");
                } else {
                    lifecycleElement.addAttribute("endDateString", "expire on " + FormatStandards.formatDate((Date)endDate));
                    lifecycleElement.addAttribute("endDate", FormatStandards.formatDate((Date)endDate));
                }
                lifecycleElement.addAttribute("hasBegun", new Boolean(lifecycle.hasBegun()).toString());
                lifecycleElement.addAttribute("hasEnded", new Boolean(lifecycle.hasEnded()).toString());
            }
            parent.addContent(itemElement);
            parent.addContent(categoryElement);
            parent.addContent(linkElement);
            parent.addContent(lifecycleElement);
            parent.addContent(workflowElement);
            parent.addContent(transactionElement);
        }
    }

    protected ContentItem getContentItem(PageState state) {
        ContentItem item = (ContentItem)this.m_item.getSelectedObject(state);
        Assert.assertNotNull((Object)item);
        return item;
    }

    protected ContentSection getContentSection(PageState state) {
        ContentSection section = CMS.getContext().getContentSection();
        return section;
    }

    public void respond(PageState state) throws ServletException {
        String key = state.getControlEventName();
        String value = state.getControlEventValue();
        if (RESTART_WORKFLOW.equals(key)) {
            User user = Web.getContext().getUser();
            ContentItem item = this.getContentItem(state);
            ContentSection section = item.getContentSection();
            Workflow w = Workflow.getObjectWorkflow((ACSObject)item);
            if (this.canWorkflowBeExtended(user, item, w)) {
                CMSTask task;
                Engine engine;
                Iterator i;
                WorkflowTemplate template = w.getWorkflowTemplate();
                if (template != null) {
                    template.extendWorkflow(w);
                    w.save();
                }
                if ((i = (engine = Engine.getInstance()).getEnabledTasks(user, w.getID()).iterator()).hasNext() && !(task = (CMSTask)((Object)i.next())).isLocked()) {
                    task.lock(user);
                }
            }
            String redirectURL = Web.getConfig().getDispatcherServletPath() + item.getContentSection().getPath() + "/admin/item.jsp?item_id=" + item.getID() + "&set_tab=1";
            throw new RedirectSignal(redirectURL, true);
        }
        throw new ServletException("Unknown control event: " + key);
    }

    protected boolean canWorkflowBeExtended(User user, ContentItem item, Workflow workflow) {
        boolean canBeExtended = true;
        if (workflow == null) {
            canBeExtended = false;
        } else if (!workflow.isFinished()) {
            canBeExtended = false;
        } else {
            TaskCollection templates = item.getContentSection().getWorkflowTemplates();
            Filter f = templates.addInSubqueryFilter("id", "com.arsdigita.cms.getWorkflowTemplateUserFilter");
            f.set("userId", (Object)Web.getContext().getUser().getID());
            templates.addEqualsFilter("id", (Object)workflow.getWorkflowTemplate().getID());
            PrivilegeDescriptor pd = PrivilegeDescriptor.get((String)"cms_workflow_admin");
            PermissionDescriptor perm = new PermissionDescriptor(pd, (ACSObject)item, (Party)user);
            if (!templates.next() && !PermissionService.checkPermission((PermissionDescriptor)perm)) {
                canBeExtended = false;
            }
            templates.close();
        }
        return canBeExtended;
    }
}

