/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.item;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeWorkflowTemplate;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.ui.authoring.LanguageWidget;
import com.arsdigita.cms.ui.item.ItemLanguagesTable;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.util.LanguageUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.LayoutPanel;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Pair;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import java.util.Collection;
import java.util.Iterator;
import java.util.TooManyListenersException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ItemLanguages
extends LayoutPanel {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/item/ItemLanguages.java#10 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$item$ItemLanguages == null ? (class$com$arsdigita$cms$ui$item$ItemLanguages = ItemLanguages.class$("com.arsdigita.cms.ui.item.ItemLanguages")) : class$com$arsdigita$cms$ui$item$ItemLanguages));
    private final ItemSelectionModel m_model;
    private final LanguageWidget m_language;
    private final Submit m_change;
    private final Submit m_create;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$item$ItemLanguages;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentSection;

    public ItemLanguages(ItemSelectionModel model) {
        this.m_model = model;
        Section section = new Section(ItemLanguages.gz("cms.ui.item.languages"));
        this.setBody((Component)section);
        ActionGroup group = new ActionGroup();
        section.setBody((Component)group);
        group.setSubject((Component)new ItemLanguagesTable(this.m_model));
        Form form = new Form("newLanguage", (Container)new BoxPanel(1));
        group.addAction((Component)form);
        form.setRedirecting(true);
        this.m_language = new LanguageWidget("language"){

            protected void setupOptions() {
            }
        };
        try {
            this.m_language.addPrintListener(new OptionPrinter());
        }
        catch (TooManyListenersException tmle) {
            new UncheckedWrapperException((Throwable)tmle);
        }
        form.add((Component)this.m_language);
        this.m_change = new Submit("change", ItemLanguages.gz("cms.ui.item.language.change"));
        form.add((Component)this.m_change);
        this.m_create = new Submit("create", ItemLanguages.gz("cms.ui.item.language.add"));
        form.add((Component)this.m_create);
        form.addProcessListener((FormProcessListener)new ProcessListener());
    }

    protected static final GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    protected static final String lz(String key) {
        return (String)ItemLanguages.gz(key).localize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ProcessListener
    implements FormProcessListener {
        private ProcessListener() {
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            String lang = (String)ItemLanguages.this.m_language.getValue(state);
            ContentPage item = (ContentPage)ItemLanguages.this.m_model.getSelectedItem(state);
            ContentBundle bundle = item.getContentBundle();
            String name = bundle.getName();
            if (ItemLanguages.this.m_create.isSelected(state)) {
                ContentSection section = item.getContentSection();
                Assert.exists((Object)((Object)section), (Class)(class$com$arsdigita$cms$ContentSection == null ? (class$com$arsdigita$cms$ContentSection = ItemLanguages.class$("com.arsdigita.cms.ContentSection")) : class$com$arsdigita$cms$ContentSection));
                ContentType type = item.getContentType();
                item = (ContentPage)item.copy();
                item.setLanguage(lang);
                item.setName(name);
                WorkflowTemplate template = ContentTypeWorkflowTemplate.getWorkflowTemplate(section, type);
                if (template != null) {
                    Workflow w = template.instantiateNewWorkflow();
                    w.setObjectID(item.getID());
                    w.start(KernelHelper.getCurrentUser((HttpServletRequest)state.getRequest()));
                    w.save();
                }
                ItemLanguages.this.m_model.setSelectedObject(state, (DomainObject)item);
                String target = URL.getDispatcherPath() + ContentItemPage.getItemURL(item, ContentItemPage.AUTHORING_TAB);
                throw new RedirectSignal(target, true);
            }
            if (ItemLanguages.this.m_change.isSelected(state)) {
                String oldLang = item.getLanguage();
                item.setLanguage(lang);
                item.setName(name);
                item.save();
                if (bundle.getDefaultLanguage().equals(oldLang)) {
                    bundle.setDefaultLanguage(lang);
                    bundle.save();
                }
            }
        }
    }

    private class OptionPrinter
    implements PrintListener {
        private OptionPrinter() {
        }

        public final void prepare(PrintEvent e) {
            PageState state = e.getPageState();
            OptionGroup optionGroup = (OptionGroup)e.getTarget();
            ContentPage item = (ContentPage)ItemLanguages.this.m_model.getSelectedItem(state);
            Collection languages = LanguageUtil.convertToG11N(LanguageUtil.getCreatableLanguages(item));
            Iterator iter = languages.iterator();
            while (iter.hasNext()) {
                Pair pair = (Pair)iter.next();
                String langCode = (String)pair.getKey();
                GlobalizedMessage langName = (GlobalizedMessage)pair.getValue();
                optionGroup.addOption(new Option(langCode, (Component)new Label(langName)));
            }
        }
    }
}

