/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ui.category.CategoryCollectionListModel;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.cms.ui.category.SortableCategoryList;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.util.LockableImpl;

public class SubcategoryList
extends SortableCategoryList {
    private final CategoryRequestLocal m_parent;
    private final SingleSelectionModel m_model;

    public SubcategoryList(CategoryRequestLocal parent, SingleSelectionModel model) {
        super(parent);
        this.m_parent = parent;
        this.m_model = model;
        this.setIdAttr("subcategories_list");
        this.setModelBuilder(new SubcategoryModelBuilder());
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                String id = (String)SubcategoryList.this.getSelectedKey(state);
                if (id != null) {
                    SubcategoryList.this.m_model.setSelectedKey(state, (Object)id);
                }
            }
        });
        Label label = new Label(GlobalizationUtil.globalize("cms.ui.category.subcategory.none"));
        label.setFontWeight("i");
        this.setEmptyView((Component)label);
    }

    private class SubcategoryModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        private SubcategoryModelBuilder() {
        }

        public ListModel makeModel(List list, PageState state) {
            Category category = SubcategoryList.this.m_parent.getCategory(state);
            if (category != null && category.hasChildCategories()) {
                CategoryCollection children = category.getChildren();
                children.addOrder("link.sortKey");
                return new CategoryCollectionListModel(children);
            }
            return List.EMPTY_MODEL;
        }
    }
}

