/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.categorization.CategorizedCollection;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.cms.ui.category.SortableCategoryList;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;
import javax.servlet.ServletException;

public class CategorizedObjectsList
extends SortableCategoryList {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/category/CategorizedObjectsList.java#17 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    public static final String CATEGORIZED_OBJECTS = "co";

    public CategorizedObjectsList(CategoryRequestLocal category) {
        super(category);
        this.setModelBuilder(new CategorizedObjectsModelBuilder());
        Label label = new Label(GlobalizationUtil.globalize("cms.ui.category.item.none"));
        label.setFontWeight("i");
        this.setEmptyView((Component)label);
    }

    public void respond(PageState ps) throws ServletException {
        String event = ps.getControlEventName();
        if ("next".equals(event) || "prev".equals(event)) {
            BigDecimal selectedID = new BigDecimal(ps.getControlEventValue());
            Category parent = this.getCategory(ps);
            if (CMS.getContext().getSecurityManager().canAccess("category_admin")) {
                parent.swapSortKeys(selectedID, this.getSwapID(parent, selectedID, event));
            }
        } else {
            super.respond(ps);
        }
    }

    protected BigDecimal getSwapID(Category category, BigDecimal selectedID, String event) {
        BigDecimal priorID = null;
        BigDecimal swapID = null;
        boolean foundSelectedID = false;
        if (category != null && category.hasChildObjects()) {
            CategorizedCollection items = category.getObjects("com.arsdigita.cms.ContentItem");
            items.addEqualsFilter("version", (Object)"live");
            items.sort(true);
            while (items.next()) {
                BigDecimal thisID = items.getACSObject().getID();
                if (foundSelectedID && "next".equals(event)) {
                    swapID = thisID;
                    break;
                }
                if (thisID.equals(selectedID)) {
                    foundSelectedID = true;
                    if ("prev".equals(event)) {
                        swapID = priorID;
                        break;
                    }
                }
                priorID = thisID;
            }
            items.close();
        }
        return swapID;
    }

    private static class CategorizedCollectionListModel
    implements ListModel {
        private CategorizedCollection m_objs;
        private ACSObject m_object;

        public CategorizedCollectionListModel(CategorizedCollection coll) {
            this.m_objs = coll;
            this.m_object = null;
        }

        public boolean next() {
            if (this.m_objs.next()) {
                this.m_object = (ACSObject)this.m_objs.getDomainObject();
                return true;
            }
            return false;
        }

        public Object getElement() {
            return this.m_object.getDisplayName();
        }

        public String getKey() {
            return this.m_object.getID().toString();
        }
    }

    private class CategorizedObjectsModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        private CategorizedObjectsModelBuilder() {
        }

        public final ListModel makeModel(List list, PageState state) {
            Category category = CategorizedObjectsList.this.getCategory(state);
            if (category != null && category.hasChildObjects()) {
                CategorizedCollection items = category.getObjects("com.arsdigita.cms.ContentItem");
                items.addEqualsFilter("version", (Object)"live");
                items.sort(true);
                return new CategorizedCollectionListModel(items);
            }
            return List.EMPTY_MODEL;
        }
    }
}

