/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.categorization.RootCategoryCollection;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.xml.Element;
import com.arsdigita.xml.XML;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class ItemCategorySummary
extends SimpleComponent {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$authoring$ItemCategorySummary == null ? (class$com$arsdigita$cms$ui$authoring$ItemCategorySummary = ItemCategorySummary.class$("com.arsdigita.cms.ui.authoring.ItemCategorySummary")) : class$com$arsdigita$cms$ui$authoring$ItemCategorySummary));
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_ADD_JS = "addJS";
    private Map m_listeners = new HashMap();
    static /* synthetic */ Class class$com$arsdigita$cms$ui$authoring$ItemCategorySummary;

    public ItemCategorySummary() {
        this.registerAction(ACTION_DELETE, new DeleteActionListener());
    }

    protected void registerAction(String name, ActionListener listener) {
        this.m_listeners.put(name, listener);
    }

    public void respond(PageState state) throws ServletException {
        super.respond(state);
        Assert.truth((boolean)this.canEdit(state), (String)"User can edit item");
        String name = state.getControlEventName();
        ActionListener listener = (ActionListener)this.m_listeners.get(name);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Got event " + name + " listener " + listener));
        }
        if (listener != null) {
            listener.actionPerformed(new ActionEvent((Component)this, state));
        }
    }

    private boolean canEdit(PageState state) {
        SecurityManager sm = new SecurityManager(CMS.getContext().getContentSection());
        return sm.canAccess(state.getRequest(), "edit_item", CMS.getContext().getContentItem());
    }

    public void generateXML(PageState state, Element parent) {
        ContentSection section = CMS.getContext().getContentSection();
        ContentItem item = CMS.getContext().getContentItem();
        boolean canEdit = this.canEdit(state);
        Element content = parent.newChildElement("cms:categoryStepSummary", "http://www.arsdigita.com/cms/1.0");
        this.exportAttributes(content);
        Element rootCats = content.newChildElement("cms:categoryRoots", "http://www.arsdigita.com/cms/1.0");
        RootCategoryCollection roots = Category.getRootCategories((ACSObject)section);
        while (roots.next()) {
            Element root = rootCats.newChildElement("cms:categoryRoot", "http://www.arsdigita.com/cms/1.0");
            root.addAttribute("name", roots.getName());
            root.addAttribute("description", roots.getDescription());
            root.addAttribute("context", roots.getUseContext());
            if (!canEdit) continue;
            state.setControlEvent((Component)this, ACTION_ADD, roots.getCategory().getID().toString());
            try {
                root.addAttribute("addAction", XML.format((Object)state.stateAsURL()));
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("cannot generate URL", (Throwable)ex);
            }
            state.clearControlEvent();
            state.setControlEvent((Component)this, ACTION_ADD_JS, roots.getCategory().getID().toString());
            try {
                root.addAttribute("addJSAction", XML.format((Object)state.stateAsURL()));
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("cannot generate URL", (Throwable)ex);
            }
            state.clearControlEvent();
        }
        Element itemCats = content.newChildElement("cms:itemCategories", "http://www.arsdigita.com/cms/1.0");
        CategoryCollection cats = item.getCategoryCollection();
        while (cats.next()) {
            Category cat = cats.getCategory();
            StringBuffer path = new StringBuffer();
            CategoryCollection parents = cat.getDefaultAscendants();
            parents.addOrder("defaultAncestors");
            while (parents.next()) {
                Category par = parents.getCategory();
                if (path.length() != 0) {
                    path.append(" -> ");
                }
                path.append(par.getName());
            }
            Element el = itemCats.newChildElement("cms:itemCategory", "http://www.arsdigita.com/cms/1.0");
            el.addAttribute("name", cat.getName());
            el.addAttribute("description", cat.getDescription());
            el.addAttribute("path", XML.format((Object)path));
            if (!canEdit) continue;
            state.setControlEvent((Component)this, ACTION_DELETE, cat.getID().toString());
            try {
                el.addAttribute("deleteAction", XML.format((Object)state.stateAsURL()));
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("cannot generate URL", (Throwable)ex);
            }
            state.clearControlEvent();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DeleteActionListener
    implements ActionListener {
        private DeleteActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            String value = state.getControlEventValue();
            Category cat = (Category)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.categorization.Category", (Object)new BigDecimal(value)));
            ContentItem item = CMS.getContext().getContentItem();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Removing category " + cat + " from " + item + " parent " + item.getParent()));
            }
            cat.removeChild(item.getParent());
            state.clearControlEvent();
            throw new RedirectSignal(state.toURL(), true);
        }
    }
}

