/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ArticleImageAssociation;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.ImageBrowser;
import com.arsdigita.cms.ui.ImageChooser;
import com.arsdigita.cms.ui.authoring.ImageSelectionForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ArticleImageChooser
extends SimpleContainer {
    public static final String CHOSEN_IMAGE = "chim";
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoring/ArticleImageChooser.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$authoring$ArticleImageChooser == null ? (class$com$arsdigita$cms$ui$authoring$ArticleImageChooser = ArticleImageChooser.class$("com.arsdigita.cms.ui.authoring.ArticleImageChooser")) : class$com$arsdigita$cms$ui$authoring$ArticleImageChooser));
    private final ItemSelectionModel m_assets;
    private final ItemSelectionModel m_choiceModel;
    private ImageChooser m_chooser;
    private ImageSelectionForm m_form;
    private BigDecimalParameter m_chosenImage;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$authoring$ArticleImageChooser;

    public ArticleImageChooser(ItemSelectionModel itemModel, ItemSelectionModel assetModel) {
        this.m_assets = assetModel;
        this.m_chooser = new ImageChooser();
        this.add((Component)this.m_chooser);
        this.m_chooser.addImageActionListener((TableActionListener)new ImageBrowser.LinkActionListener(){

            public void linkClicked(PageState state, BigDecimal imageId) {
                s_log.debug((Object)("SELECTING: " + imageId));
                ArticleImageChooser.this.selectImage(state, imageId);
            }

            public void deleteClicked(PageState state, BigDecimal imageId) {
                s_log.debug((Object)("DELETING: " + imageId));
                ArticleImageChooser.this.deleteImage(state, imageId);
            }
        });
        this.m_chosenImage = new BigDecimalParameter(CHOSEN_IMAGE);
        ContentType t = assetModel.getContentType();
        this.m_choiceModel = t == null ? new ItemSelectionModel(assetModel.getJavaClass().getName(), assetModel.getObjectType(), this.m_chosenImage) : new ItemSelectionModel(assetModel.getContentType(), this.m_chosenImage);
        this.m_form = new ImageSelectionForm(itemModel, this.m_choiceModel);
        this.m_form.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent e) throws FormProcessException {
                PageState state = e.getPageState();
                if (ArticleImageChooser.this.m_form.getSaveCancelSection().getCancelButton().isSelected(state)) {
                    ArticleImageChooser.this.deselectImage(state);
                    throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.authoring.submission_cancelled").localize());
                }
            }
        });
        this.m_form.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent e) throws FormProcessException {
                PageState state = e.getPageState();
                ArticleImageChooser.this.m_assets.setSelectedObject(state, ArticleImageChooser.this.m_choiceModel.getSelectedObject(state));
            }
        });
        this.add((Component)this.m_form);
    }

    public void register(Page p) {
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_chosenImage);
        p.setVisibleDefault((Component)this.m_form, false);
    }

    public ImageSelectionForm getImageSelectionForm() {
        return this.m_form;
    }

    public ImageChooser getImageChooser() {
        return this.m_chooser;
    }

    public void selectImage(PageState s, BigDecimal imageId) {
        s.setVisible((Component)this.m_form, true);
        s.setVisible((Component)this.m_chooser, false);
        this.m_choiceModel.setSelectedKey(s, imageId);
    }

    public void deleteImage(PageState s, BigDecimal imageId) {
        SecurityManager sm = Utilities.getSecurityManager(s);
        if (sm.canAccess(s.getRequest(), "delete_images")) {
            try {
                ImageAsset asset = (ImageAsset)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.ImageAsset", (Object)imageId));
                if (!ArticleImageAssociation.imageHasAssociation(asset)) {
                    asset.setLive(null);
                    ItemCollection pendingVersions = asset.getPendingVersions();
                    while (pendingVersions.next()) {
                        ContentItem item = pendingVersions.getContentItem();
                        asset.removePendingVersion(item);
                    }
                    asset.delete();
                }
            }
            catch (DataObjectNotFoundException e) {
                // empty catch block
            }
        }
    }

    public void deselectImage(PageState s) {
        s.setVisible((Component)this.m_form, false);
        s.setVisible((Component)this.m_chooser, true);
        this.m_choiceModel.clearSelection(s);
        this.m_chooser.clearSelection(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

