/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.Article;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ImageAssetCollection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.ArticleImageDisplay;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.ui.ImageChooser;
import com.arsdigita.cms.ui.SecurityPropertyEditor;
import com.arsdigita.cms.ui.SingleImageSelectionModel;
import com.arsdigita.cms.ui.authoring.ArticleImageChooser;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.AuthoringStepComponent;
import com.arsdigita.cms.ui.authoring.ImagePropertiesForm;
import com.arsdigita.cms.ui.authoring.ImageSelectionForm;
import com.arsdigita.cms.ui.authoring.ImageUploadForm;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.ui.workflow.WorkflowLockedContainer;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

public class ArticleImage
extends SimpleContainer
implements AuthoringStepComponent {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoring/ArticleImage.java#19 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String IMAGE_ASSET = "image_asset";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$authoring$ArticleImage == null ? (class$com$arsdigita$cms$ui$authoring$ArticleImage = ArticleImage.class$("com.arsdigita.cms.ui.authoring.ArticleImage")) : class$com$arsdigita$cms$ui$authoring$ArticleImage));
    private final ItemSelectionModel m_article;
    private final AuthoringKitWizard m_parent;
    private SingleImageSelectionModel m_assets;
    private BigDecimalParameter m_assetParam;
    private ArticleWithoutImage m_noImagePane;
    private ArticleImageChooser m_noImageChooser;
    private ArticleWithImage m_imagePane;
    private ArticleImageChooser m_imageChooser;
    private StringParameter m_streamlinedCreationParam;
    private static final String STREAMLINED = "_streamlined";
    private static final String STREAMLINED_DONE = "1";
    static /* synthetic */ Class class$com$arsdigita$cms$ui$authoring$ArticleImage;

    public ArticleImage(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        this.m_parent = parent;
        this.m_article = itemModel;
        this.m_streamlinedCreationParam = new StringParameter(parent.getContentType().getAssociatedObjectType() + "_image_done");
        this.m_assetParam = new BigDecimalParameter(IMAGE_ASSET);
        this.m_assets = new SingleImageSelectionModel(this.m_assetParam, this.m_article);
        this.m_noImagePane = new ArticleWithoutImage(this.m_article, this.m_assets);
        this.m_noImageChooser = this.m_noImagePane.getChooser();
        final ImageSelectionForm noImageForm = this.m_noImageChooser.getImageSelectionForm();
        noImageForm.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                ArticleImage.this.m_imagePane.showDisplayPane(state);
                ArticleImage.this.maybeForwardToNextStep(state);
            }
        });
        noImageForm.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                if (noImageForm.getSaveCancelSection().getCancelButton().isSelected(state)) {
                    ArticleImage.this.cancelStreamlinedCreation(state);
                }
            }
        });
        this.add((Component)this.m_noImagePane);
        this.m_imagePane = new ArticleWithImage(this.m_article, this.m_assets);
        this.m_imageChooser = this.m_imagePane.getChooser();
        final ImageSelectionForm imageForm = this.m_imageChooser.getImageSelectionForm();
        imageForm.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                ArticleImage.this.m_imagePane.showDisplayPane(state);
                ArticleImage.this.maybeForwardToNextStep(state);
            }
        });
        this.m_imagePane.getList().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                ArticleImage.this.m_imageChooser.deselectImage(state);
                ArticleImage.this.m_imageChooser.getImageChooser().clearKeyword(state);
                ArticleImage.this.m_noImageChooser.deselectImage(state);
                ArticleImage.this.m_noImageChooser.getImageChooser().clearKeyword(state);
            }
        });
        imageForm.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                if (imageForm.getSaveCancelSection().getCancelButton().isSelected(state)) {
                    ArticleImage.this.cancelStreamlinedCreation(state);
                }
            }
        });
        this.add((Component)this.m_imagePane);
        parent.getList().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                Article art = (Article)ArticleImage.this.m_article.getSelectedObject(state);
                ImageAssetCollection col = art.getImages();
                ImageAsset img = null;
                if (col.next()) {
                    img = col.getImage();
                }
                col.close();
                ArticleImage.this.m_assets.setSelectedObject(state, (DomainObject)img);
                ArticleImage.this.m_imagePane.showDisplayPane(state);
                ArticleImage.this.m_imageChooser.deselectImage(state);
                ArticleImage.this.m_noImageChooser.deselectImage(state);
            }
        });
    }

    private ArticleImageChooser addChooser(SecurityPropertyEditor e) {
        ArticleImageChooser c = new ArticleImageChooser(this.m_article, this.m_assets);
        c.getImageSelectionForm().addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent param_e) throws FormProcessException {
                ArticleImage.this.m_imagePane.showDisplayPane(param_e.getPageState());
            }
        });
        ImageChooser ch = c.getImageChooser();
        e.addCancelListener((FormSection)ch.getForm(), ch.getFormCancelButton());
        e.addComponent("browse", "Select existing image", new WorkflowLockedComponentAccess((Component)c, this.m_article));
        return c;
    }

    public void register(Page p) {
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_assetParam);
        p.addGlobalStateParam((ParameterModel)this.m_streamlinedCreationParam);
    }

    public void generateXML(PageState state, Element parent) {
        if (this.m_assets.getSelectedObject(state) == null) {
            this.m_noImagePane.generateXML(state, parent);
        } else {
            this.m_imagePane.generateXML(state, parent);
        }
    }

    public AuthoringKitWizard getParentWizard() {
        return this.m_parent;
    }

    public ItemSelectionModel getItemSelectionModel() {
        return this.m_article;
    }

    public void maybeForwardToNextStep(PageState state) {
        if (ContentItemPage.isStreamlinedCreationActive(state) && !STREAMLINED_DONE.equals(state.getValue((ParameterModel)this.m_streamlinedCreationParam))) {
            state.setValue((ParameterModel)this.m_streamlinedCreationParam, (Object)STREAMLINED_DONE);
            this.fireCompletionEvent(state);
        }
    }

    public void cancelStreamlinedCreation(PageState state) {
        if (ContentItemPage.isStreamlinedCreationActive(state)) {
            state.setValue((ParameterModel)this.m_streamlinedCreationParam, (Object)STREAMLINED_DONE);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ ArticleWithoutImage access$900(ArticleImage x0) {
        return x0.m_noImagePane;
    }

    private class ArticleWithImage
    extends SecurityPropertyEditor {
        private final ItemSelectionModel m_articleWithImage;
        private final ItemSelectionModel m_assetsWithImage;
        private CMSContainer m_display;
        private ActionLink m_editLink;
        private ActionLink m_uploadLink;
        private ActionLink m_selectLink;
        private ActionLink m_removeLink;
        private ImageUploadForm m_uploadFormWithImage;
        private ImagePropertiesForm m_editFormWithImage;
        private ArticleImageChooser m_chooserWithImage;

        public ArticleWithImage(ItemSelectionModel article, ItemSelectionModel assets) {
            this.m_articleWithImage = article;
            this.m_assetsWithImage = assets;
            this.m_display = new CMSContainer();
            this.m_display.add((Component)new ArticleImageDisplay(this.m_articleWithImage, this.m_assetsWithImage));
            this.m_editLink = new ActionLink((String)GlobalizationUtil.globalize("cms.ui.authoring.edit_caption").localize());
            this.m_editLink.setClassAttr("actionLink");
            this.m_editLink.setIdAttr("edit_link");
            this.m_display.add((Component)new WorkflowLockedContainer((Component)this.m_editLink, this.m_articleWithImage));
            this.m_uploadLink = new ActionLink((String)GlobalizationUtil.globalize("cms.ui.authoring.upload_a_new_image").localize());
            this.m_uploadLink.setClassAttr("actionLink");
            this.m_uploadLink.setIdAttr("upload_link");
            this.m_display.add((Component)new WorkflowLockedContainer((Component)this.m_uploadLink, this.m_articleWithImage));
            this.m_selectLink = new ActionLink((String)GlobalizationUtil.globalize("cms.ui.authoring.select_an_existing_image").localize());
            this.m_selectLink.setClassAttr("actionLink");
            this.m_selectLink.setIdAttr("select_link");
            this.m_display.add((Component)new WorkflowLockedContainer((Component)this.m_selectLink, this.m_articleWithImage));
            this.m_removeLink = new ActionLink((String)GlobalizationUtil.globalize("cms.ui.authoring.remove_image").localize());
            this.m_removeLink.setClassAttr("actionLink");
            this.m_removeLink.setIdAttr("remove_image_link");
            this.m_removeLink.setConfirmation("Are you sure you wish to remove this image from the article?");
            this.m_removeLink.addActionListener(new ActionListener(this){
                private final /* synthetic */ ArticleWithImage this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent event) {
                    PageState state = event.getPageState();
                    ImageAsset img = ArticleWithImage.access$500(this.this$1, state);
                    Article articleTarget = ArticleWithImage.access$600(this.this$1, state);
                    articleTarget.removeImage(img);
                    articleTarget.save();
                    ArticleWithImage.access$700(this.this$1).setSelectedObject(state, null);
                    ArticleImage.access$100(ArticleWithImage.access$800(this.this$1)).deselectImage(state);
                    ArticleImage.access$100(ArticleWithImage.access$800(this.this$1)).getImageChooser().clearKeyword(state);
                    ArticleImage.access$200(ArticleWithImage.access$800(this.this$1)).deselectImage(state);
                    ArticleImage.access$200(ArticleWithImage.access$800(this.this$1)).getImageChooser().clearKeyword(state);
                    ArticleImage.access$900(ArticleWithImage.access$800(this.this$1)).showDisplayPane(event.getPageState());
                    Utilities.disableBrowserCache(state.getResponse());
                }
            });
            this.m_display.add((Component)new WorkflowLockedContainer((Component)this.m_removeLink, this.m_articleWithImage));
            this.setDisplayComponent((Component)this.m_display);
            this.m_editFormWithImage = new ImagePropertiesForm(this.m_articleWithImage, this.m_assetsWithImage);
            this.addComponent("edit", new WorkflowLockedComponentAccess((Component)this.m_editFormWithImage, this.m_articleWithImage));
            this.addListeners((FormSection)this.m_editFormWithImage, this.m_editFormWithImage.getSaveCancelSection().getCancelButton());
            this.addVisibilityListener(this.m_editLink, "edit");
            this.m_uploadFormWithImage = new ImageUploadForm(this.m_articleWithImage, this.m_assetsWithImage, ArticleImage.this);
            this.addComponent("upload", new WorkflowLockedComponentAccess((Component)this.m_uploadFormWithImage, this.m_articleWithImage));
            this.addListeners((FormSection)this.m_uploadFormWithImage, this.m_uploadFormWithImage.getSaveCancelSection().getCancelButton());
            this.addVisibilityListener(this.m_uploadLink, "upload");
            this.m_chooserWithImage = new ArticleImageChooser(this.m_articleWithImage, this.m_assetsWithImage);
            ImageChooser imgChooser = this.m_chooserWithImage.getImageChooser();
            this.addCancelListener((FormSection)imgChooser.getForm(), imgChooser.getFormCancelButton());
            this.addComponent("browse", new WorkflowLockedComponentAccess((Component)this.m_chooserWithImage, this.m_articleWithImage));
            this.addVisibilityListener(this.m_selectLink, "browse");
        }

        public ArticleImageChooser getChooser() {
            return this.m_chooserWithImage;
        }

        private ImageAsset getImageAsset(PageState state) {
            ImageAsset image = (ImageAsset)this.m_assetsWithImage.getSelectedObject(state);
            Assert.assertNotNull((Object)image, (String)"Image asset");
            return image;
        }

        private Article getArticle(PageState state) {
            Article article = (Article)this.m_articleWithImage.getSelectedObject(state);
            Assert.assertNotNull((Object)article, (String)"Article");
            return article;
        }

        static /* synthetic */ ImageAsset access$500(ArticleWithImage x0, PageState x1) {
            return x0.getImageAsset(x1);
        }

        static /* synthetic */ Article access$600(ArticleWithImage x0, PageState x1) {
            return x0.getArticle(x1);
        }

        static /* synthetic */ ItemSelectionModel access$700(ArticleWithImage x0) {
            return x0.m_assetsWithImage;
        }

        static /* synthetic */ ArticleImage access$800(ArticleWithImage x0) {
            return x0.ArticleImage.this;
        }
    }

    private class ArticleWithoutImage
    extends SecurityPropertyEditor {
        private final ItemSelectionModel m_articleWithoutImage;
        private final ItemSelectionModel m_assetsWithoutImage;
        private ImageUploadForm m_uploadFormWithoutImage;
        private ArticleImageChooser m_chooserWithoutImage;

        public ArticleWithoutImage(ItemSelectionModel article, ItemSelectionModel assets) {
            this.m_articleWithoutImage = article;
            this.m_assetsWithoutImage = assets;
            Label l = new Label(GlobalizationUtil.globalize("cms.ui.authoring.this_article_does_not_have_an_image"));
            l.setFontWeight("i");
            this.setDisplayComponent((Component)l);
            this.m_uploadFormWithoutImage = new ImageUploadForm(this.m_articleWithoutImage, this.m_assetsWithoutImage, ArticleImage.this);
            this.add("upload", "Upload a new image", new WorkflowLockedComponentAccess((Component)this.m_uploadFormWithoutImage, this.m_articleWithoutImage), this.m_uploadFormWithoutImage.getSaveCancelSection().getCancelButton());
            this.m_chooserWithoutImage = new ArticleImageChooser(this.m_articleWithoutImage, this.m_assetsWithoutImage);
            ImageChooser imgChooser = this.m_chooserWithoutImage.getImageChooser();
            this.addCancelListener((FormSection)imgChooser.getForm(), imgChooser.getFormCancelButton());
            this.addComponent("browse", "Select existing image", new WorkflowLockedComponentAccess((Component)this.m_chooserWithoutImage, this.m_articleWithoutImage));
        }

        public ArticleImageChooser getChooser() {
            return this.m_chooserWithoutImage;
        }
    }
}

