/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PropertyEditor;
import com.arsdigita.bebop.PropertyEditorModel;
import com.arsdigita.bebop.PropertyEditorModelBuilder;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.toolbox.Security;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SecurityPropertyEditor
extends PropertyEditor {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/SecurityPropertyEditor.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private HashMap m_accessChecks = new HashMap();

    public SecurityPropertyEditor() {
        this(null);
    }

    public SecurityPropertyEditor(Component display) {
        super(display);
        this.setModelBuilder((PropertyEditorModelBuilder)new AccessListModelBuilder());
    }

    public void addComponent(String key, ComponentAccess ca) {
        super.addComponent(key, ca.getComponent());
        this.m_accessChecks.put(key, ca);
    }

    public void addComponent(String key, String label, ComponentAccess ca) {
        this.addComponent(key, ca);
        this.getLabelsMap().put((Object)key, (Object)label);
    }

    public void setComponentAccess(String key, ComponentAccess access) {
        Assert.assertNotLocked((Lockable)this);
        Component c = this.getComponent(key);
        Assert.assertNotNull((Object)c, (String)"the specified component");
        Assert.assertTrue((boolean)access.getComponent().equals(c), (String)"The specified component does not match the component that id already in the PropertyEditor");
        this.m_accessChecks.put(key, access);
    }

    public void add(String key, String label, ComponentAccess ca) {
        Component c = ca.getComponent();
        if (c instanceof Form) {
            Form form = (Form)c;
            this.m_accessChecks.put(key, ca);
            this.add(key, label, form);
            this.addSecurityListener((FormSection)form);
        } else if (c instanceof FormSection) {
            FormSection section = (FormSection)ca.getComponent();
            this.m_accessChecks.put(key, ca);
            this.add(key, label, section);
            this.addSecurityListener(section);
        } else {
            throw new IllegalArgumentException("The ComponentAccess object did not contain a form section.");
        }
    }

    public void add(String key, String label, ComponentAccess ca, Submit cancelButton) {
        this.add(key, label, ca);
        this.addCancelListener((FormSection)ca.getComponent(), cancelButton);
    }

    public void addSecurityListener(FormSection form) {
        form.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent e) throws FormProcessException {
                PageState state = e.getPageState();
                SecurityManager sm = Utilities.getSecurityManager(state);
                String key = (String)SecurityPropertyEditor.this.getList().getSelectedKey(state);
                ComponentAccess ca = (ComponentAccess)SecurityPropertyEditor.this.m_accessChecks.get(key);
                if (key == null || ca == null) {
                    return;
                }
                if (!ca.canAccess(state, (Security)sm)) {
                    SecurityPropertyEditor.this.showDisplayPane(state);
                    throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.insufficient_privileges").localize());
                }
            }
        });
    }

    public void addListeners(FormSection form, Submit cancelButton) {
        this.addSecurityListener(form);
        super.addListeners(form, cancelButton);
    }

    protected final Map getAccessMap() {
        return this.m_accessChecks;
    }

    protected static class AccessListModel
    extends PropertyEditor.DefaultModel {
        private Map m_access;
        private PageState m_state;
        private SecurityManager m_manager;

        public AccessListModel(Iterator iter, Map access, PageState state) {
            super(iter);
            this.m_access = access;
            this.m_state = state;
            this.m_manager = Utilities.getSecurityManager(this.m_state);
        }

        public boolean next() {
            while (super.next()) {
                Object key = this.getKey();
                ComponentAccess ca = (ComponentAccess)this.m_access.get(key);
                if (ca == null) {
                    return true;
                }
                if (!ca.canAccess(this.m_state, (Security)this.m_manager)) continue;
                return true;
            }
            return false;
        }
    }

    protected static class AccessListModelBuilder
    extends PropertyEditor.DefaultModelBuilder {
        public PropertyEditorModel makeModel(PropertyEditor p, PageState s) {
            return new AccessListModel(this.getProperties(p), ((SecurityPropertyEditor)p).getAccessMap(), s);
        }
    }
}

