/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.cms.ImageAssetCollection;
import com.arsdigita.cms.ReusableImageAsset;
import com.arsdigita.cms.ui.DefaultImageBrowserModel;
import com.arsdigita.cms.ui.EmptyImageBrowserModel;
import com.arsdigita.cms.ui.ImageBrowser;
import com.arsdigita.cms.ui.ImageBrowserModel;
import com.arsdigita.cms.ui.ImageBrowserModelBuilder;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import com.arsdigita.util.LockableImpl;

public class DefaultImageBrowserModelBuilder
extends LockableImpl
implements ImageBrowserModelBuilder,
PaginationModelBuilder {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/DefaultImageBrowserModelBuilder.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private SingleSelectionModel m_keywordModel;
    private static ImageBrowserModel EMPTY_MODEL = new EmptyImageBrowserModel();
    private ImageBrowser m_imageBrowser;
    private RequestLocal m_size;
    private RequestLocal m_imageColl;
    private String m_context;

    public DefaultImageBrowserModelBuilder(SingleSelectionModel keywordModel, String context) {
        this.m_keywordModel = keywordModel;
        this.m_context = context;
        this.m_size = new RequestLocal();
        this.m_imageColl = new RequestLocal();
    }

    public DefaultImageBrowserModelBuilder(SingleSelectionModel keywordModel) {
        this(keywordModel, "draft");
    }

    public ImageBrowserModel makeModel(ImageBrowser browser, PageState s) {
        return new DefaultImageBrowserModel((ImageAssetCollection)((Object)this.m_imageColl.get(s)));
    }

    public SingleSelectionModel getKeywordModel() {
        return this.m_keywordModel;
    }

    public void setContext(String context) {
        Assert.assertNotLocked((Lockable)this);
        this.m_context = context;
    }

    public int getTotalSize(Paginator paginator, PageState state) {
        Integer size = (Integer)this.m_size.get(state);
        if (size == null) {
            String key = (String)this.m_keywordModel.getSelectedKey(state);
            ImageAssetCollection c = ReusableImageAsset.getReusableImagesByKeyword(key, this.m_context);
            if (c == null) {
                return 0;
            }
            size = new Integer((int)ReusableImageAsset.getReusableImagesByKeyword(key, this.m_context).size());
            c.setRange(new Integer(paginator.getFirst(state)), new Integer(paginator.getLast(state) + 1));
            this.m_size.set(state, (Object)size);
            this.m_imageColl.set(state, (Object)c);
        }
        return size;
    }

    public void setImageBrowser(ImageBrowser ib) {
        this.m_imageBrowser = ib;
    }

    public boolean isVisible(PageState state) {
        return this.m_imageBrowser != null ? this.m_imageBrowser.isVisible(state) : true;
    }
}

