/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.ui.FormSecurityListener;
import com.arsdigita.cms.ui.item.ContentItemRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.util.SecurityConstants;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.toolbox.ui.Cancellable;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

public abstract class BaseForm
extends Form
implements Cancellable,
SecurityConstants {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/BaseForm.java#15 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$BaseForm == null ? (class$com$arsdigita$cms$ui$BaseForm = BaseForm.class$("com.arsdigita.cms.ui.BaseForm")) : class$com$arsdigita$cms$ui$BaseForm));
    private final BodySection m_body;
    private final BoxPanel m_actions;
    private Cancel m_cancel;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$BaseForm;

    protected BaseForm(String name, Label heading) {
        super(name, (Container)new GridPanel(1));
        this.setRedirecting(true);
        this.m_body = new BodySection(heading);
        this.m_actions = new BoxPanel(1);
        this.add((Component)this.m_body);
        this.add((Component)this.m_actions);
        this.addComponent((Component)new FormErrorDisplay((Form)this));
    }

    protected BaseForm(String name, GlobalizedMessage heading) {
        this(name, new Label(heading));
    }

    protected final void addComponent(Component component) {
        this.m_body.add(component, 64);
    }

    protected final void addField(Label name, Component widget) {
        this.m_body.add((Component)name);
        this.m_body.add(widget);
    }

    protected final void addField(GlobalizedMessage name, Component widget) {
        this.addField(new Label(name), widget);
    }

    protected final void addAction(Submit button) {
        this.m_actions.add((Component)button);
    }

    protected final void addAction(Cancel button) {
        this.m_cancel = button;
        this.m_actions.add((Component)button);
    }

    protected final void addSecurityListener(String action) {
        this.addSubmissionListener(new FormSecurityListener(action));
    }

    protected final void addSecurityListener(String action, ContentItemRequestLocal item) {
        this.addSubmissionListener(new FormSecurityListener(action, item));
    }

    public boolean isCancelled(PageState state) {
        return this.m_cancel != null && this.m_cancel.isSelected(state);
    }

    protected static final GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    protected static final String lz(String key) {
        return (String)BaseForm.gz(key).localize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected final class Cancel
    extends Submit {
        public Cancel() {
            super("cancel", BaseForm.gz("cms.ui.cancel"));
        }
    }

    protected final class Finish
    extends Submit {
        public Finish() {
            super("finish", BaseForm.gz("cms.ui.finish"));
        }
    }

    protected final class Description
    extends TextArea {
        public Description(String key, int maxLength, boolean isRequired) {
            super((ParameterModel)new TrimmedStringParameter(key));
            Assert.truth((maxLength > 0 ? 1 : 0) != 0, (String)"Max length cannot be negative");
            if (isRequired) {
                this.addValidationListener((ParameterListener)NotNullValidationListener.DEFAULT);
            }
            this.addValidationListener((ParameterListener)new StringLengthValidationListener(maxLength));
            this.setCols(40);
            this.setRows(5);
            this.setWrap(2);
        }
    }

    protected final class Name
    extends TextField {
        public Name(String key, int max, boolean required) {
            super((ParameterModel)new TrimmedStringParameter(key));
            if (required) {
                this.addValidationListener((ParameterListener)new NotEmptyValidationListener());
            }
            this.setSize(40);
            this.setMaxLength(max);
        }
    }

    private class BodySection
    extends Section {
        final SimpleContainer m_container;

        BodySection(Label heading) {
            this.setHeading((Component)heading);
            this.m_container = new GridPanel(2);
            this.setBody((Component)this.m_container);
        }

        final void add(Component component) {
            this.m_container.add(component);
        }

        final void add(Component component, int hints) {
            this.m_container.add(component, hints);
        }
    }
}

