/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.Article;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.ImageDisplay;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;

public class ArticleImageDisplay
extends ImageDisplay {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ArticleImageDisplay.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final ItemSelectionModel m_article;

    public ArticleImageDisplay(ItemSelectionModel article, ItemSelectionModel assets) {
        super(assets);
        this.m_article = article;
    }

    public final ItemSelectionModel getArticleSelectionModel() {
        return this.m_article;
    }

    protected Article getArticle(PageState state) {
        Article article = (Article)this.m_article.getSelectedObject(state);
        Assert.assertNotNull((Object)article, (String)"Article");
        return article;
    }

    protected void generateImagePropertiesXML(ImageAsset image, PageState state, Element element) {
        super.generateImagePropertiesXML(image, state, element);
        Article article = this.getArticle(state);
        String caption = article.getCaption(image);
        if (caption != null) {
            element.addAttribute("caption", caption);
        }
    }
}

