/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.publishToFile;

import com.arsdigita.cms.Asset;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateCollection;
import com.arsdigita.cms.TemplateManager;
import com.arsdigita.cms.TemplateManagerFactory;
import com.arsdigita.cms.dispatcher.TemplateResolver;
import com.arsdigita.cms.publishToFile.DestinationStub;
import com.arsdigita.cms.publishToFile.HttpHTMLProvider;
import com.arsdigita.cms.publishToFile.LinkScanner;
import com.arsdigita.cms.publishToFile.PublishToFileException;
import com.arsdigita.cms.publishToFile.PublishToFileListener;
import com.arsdigita.cms.publishToFile.PublishedFile;
import com.arsdigita.cms.publishToFile.PublishedHTMLProvider;
import com.arsdigita.cms.publishToFile.QueueEntry;
import com.arsdigita.cms.publishToFile.RetrievedFile;
import com.arsdigita.cms.publishToFile.Utilities;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.Assert;
import com.arsdigita.util.servlet.HttpHost;
import com.arsdigita.util.servlet.HttpResourceLocator;
import com.arsdigita.web.Host;
import com.arsdigita.web.Web;
import com.arsdigita.web.WebConfig;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PublishToFile
implements PublishToFileListener {
    public static final int DEFAULT_TIMEOUT = 60;
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$publishToFile$PublishToFile == null ? (class$com$arsdigita$cms$publishToFile$PublishToFile = PublishToFile.class$("com.arsdigita.cms.publishToFile.PublishToFile")) : class$com$arsdigita$cms$publishToFile$PublishToFile));
    private static int s_timeout = 60;
    private static Map s_destinations = new HashMap();
    private final PublishedHTMLProvider m_provider;
    static /* synthetic */ Class class$com$arsdigita$cms$publishToFile$PublishToFile;
    static /* synthetic */ Class class$com$arsdigita$persistence$metadata$ObjectType;
    static /* synthetic */ Class class$com$arsdigita$cms$publishToFile$DestinationStub;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentBundle;

    public PublishToFile() {
        this.m_provider = new HttpHTMLProvider(s_timeout);
    }

    public PublishToFile(PublishedHTMLProvider provider) {
        this.m_provider = provider;
    }

    public static void setRequestTimeout(int timeout) {
        s_timeout = timeout;
    }

    static void addDestination(String objectType, DestinationStub dest) {
        PublishToFile.addDestination(MetadataRoot.getMetadataRoot().getObjectType(objectType), dest);
    }

    static void addDestination(ObjectType type, DestinationStub dest) {
        Assert.exists((Object)type, (Class)(class$com$arsdigita$persistence$metadata$ObjectType == null ? (class$com$arsdigita$persistence$metadata$ObjectType = PublishToFile.class$("com.arsdigita.persistence.metadata.ObjectType")) : class$com$arsdigita$persistence$metadata$ObjectType));
        Assert.exists((Object)dest, (Class)(class$com$arsdigita$cms$publishToFile$DestinationStub == null ? (class$com$arsdigita$cms$publishToFile$DestinationStub = PublishToFile.class$("com.arsdigita.cms.publishToFile.DestinationStub")) : class$com$arsdigita$cms$publishToFile$DestinationStub));
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Adding destination " + dest + " for " + type.getQualifiedName()));
        }
        s_destinations.put(type, dest);
    }

    public static DestinationStub getDestination(String objectType) {
        return PublishToFile.getDestination(MetadataRoot.getMetadataRoot().getObjectType(objectType));
    }

    public static DestinationStub getDestination(ObjectType type) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Searching for destination for " + type.getQualifiedName()));
        }
        for (ObjectType current = type; current != null; current = current.getSupertype()) {
            if (!s_destinations.containsKey(current)) continue;
            DestinationStub dest = (DestinationStub)s_destinations.get(current);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Got destination " + dest));
            }
            return dest;
        }
        s_log.debug((Object)"No destination found");
        return null;
    }

    public static URL getSource(String path) {
        if (Assert.isEnabled()) {
            Assert.exists((Object)path, (Class)(class$java$lang$String == null ? (class$java$lang$String = PublishToFile.class$("java.lang.String")) : class$java$lang$String));
            Assert.truth((boolean)path.startsWith("/"), (String)"Path starts with '/'");
        }
        WebConfig config = Web.getConfig();
        HttpHost host = Web.getConfig().getHost();
        HttpResourceLocator hrl = new HttpResourceLocator(host, config.getDispatcherContextPath(), config.getDispatcherServletPath(), path, null);
        return hrl.toURL();
    }

    static String stripSourceBase(String url) {
        String sourceBase = PublishToFile.getSource("/").toString();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Maybe strip " + sourceBase + " from " + url));
        }
        return url.startsWith(sourceBase) ? url.substring(sourceBase.length()) : url;
    }

    public final boolean doTask(QueueEntry qe) throws PublishToFileException {
        if (qe.isPublishTask()) {
            return this.publish(qe);
        }
        if (qe.isUnpublishTask()) {
            return this.unpublish(qe);
        }
        if (qe.isRepublishTask()) {
            return this.republish(qe);
        }
        if (qe.isMoveTask()) {
            return this.move(qe);
        }
        throw new PublishToFileException("Unsupported  " + (Object)((Object)qe) + " task passed to the queue");
    }

    public void transactionStart() {
    }

    public void transactionEnd() {
    }

    protected boolean move(QueueEntry qe) {
        ContentItem liveItem = qe.getItem();
        ContentItem dstFolder = Utilities.getContentItemOrNull(new BigDecimal(qe.getDestination()));
        if (liveItem == null || dstFolder == null) {
            return false;
        }
        Utilities.updateContentSection(liveItem, dstFolder.getContentSection());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean publish(QueueEntry qe) {
        ContentItem item = qe.getItem();
        if (item == null) {
            s_log.warn((Object)("Item to publish no longer exists. ID = " + qe.getItemId()));
            return false;
        }
        Assert.assertTrue((!(item instanceof ContentBundle) ? 1 : 0) != 0);
        if (item instanceof Template) {
            Template template = (Template)item;
            ContentSection section = template.getContentSection();
            if (section != null) {
                TemplateResolver resolver = section.getTemplateResolver();
                String fileName = null;
                fileName = template.getMimeType() != null && "text/xml".equals(template.getMimeType().getMimeType()) ? resolver.getTemplateXSLPath(template) : resolver.getTemplatePath(template);
                String templateRoot = ContentSection.getConfig().getTemplateRoot();
                Assert.truth((boolean)fileName.startsWith(templateRoot), (String)"filename starts with templateRoot");
                PublishedFile f = PublishedFile.loadOrCreate(template, fileName.substring(templateRoot.length()), qe.getHost());
                this.writeAsset(template, f);
                f.save();
            }
            return true;
        }
        if (item instanceof Asset) {
            void var5_10;
            String fileName;
            Asset asset = (Asset)item;
            ACSObject parent = asset.getParent();
            if (parent == null) {
                fileName = Utilities.getAssetPath(asset);
            } else if (parent instanceof Folder) {
                fileName = Utilities.getAssetPath(asset, (Folder)parent);
            } else {
                throw new PublishToFileException("can not independently publish asset: " + asset + " that has parent " + asset.getParent() + " that is not a folder");
            }
            PublishedFile f = PublishedFile.loadOrCreate(asset, (String)var5_10, qe.getHost());
            this.writeAsset(asset, f);
            f.save();
            return true;
        }
        ContentBundle bundle = (ContentBundle)item.getParent();
        Folder folder = (Folder)bundle.getParent();
        return this.publishPage(item, folder, qe.getHost());
    }

    protected boolean republish(QueueEntry qe) {
        return this.unpublish(qe) && this.publish(qe);
    }

    protected boolean unpublish(QueueEntry qe) {
        BigDecimal itemId = qe.getItemId();
        ContentItem item = qe.getItem();
        PublishedFile.deleteAll(itemId, qe.getHost());
        return true;
    }

    private static String getFileExtension(String contentType) {
        if (contentType == null || contentType == "") {
            return ".html";
        }
        int i = contentType.indexOf(59);
        MimeType type = MimeType.loadMimeType((String)(contentType = i > 0 ? contentType.substring(0, i) : contentType));
        if (type == null) {
            s_log.error((Object)("Unknown content type in published item: " + contentType + " assuming extension 'html'"));
            return ".html";
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("File extension for " + contentType + " is " + type.getFileExtension()));
        }
        return "." + type.getFileExtension();
    }

    private boolean publishPage(ContentItem item, Folder where, Host host) {
        String url = PublishToFile.getSource(Utilities.getItemURL(item)).toString();
        s_log.info((Object)("Publishing page from URL '" + url + "' item = " + item));
        String publicUrl = url + '?' + "templateContext" + '=' + "public";
        if (!this.publishPageAtDocRoot(this.readHTML(publicUrl), where, item, null, host)) {
            return false;
        }
        this.publishOtherTemplates(url, item, where, host);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishOtherTemplates(String url, ContentItem item, Folder where, Host host) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("publishAllTemplates url " + url));
            s_log.debug((Object)("item is " + item.getName() + " with id " + item.getID()));
            s_log.debug((Object)("folder where is " + where.getName() + " with id " + where.getID()));
        }
        ContentItem draft = item.getWorkingVersion();
        TemplateManager manager = TemplateManagerFactory.getInstance();
        TemplateCollection coll = manager.getUseContexts(draft);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("getting template collection for draft item with id " + draft.getID()));
            s_log.debug((Object)("templateCollection coll has size " + coll.size()));
        }
        try {
            while (coll.next()) {
                String context = coll.getUseContext();
                if ("public".equals(context)) continue;
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Publishing Template " + context));
                }
                this.publishPageAtDocRoot(this.readHTML(url + '?' + "templateContext" + '=' + context), where, item, context, host);
            }
        }
        finally {
            coll.close();
        }
    }

    private RetrievedFile readHTML(String location) {
        return this.m_provider.fetchHTML(location);
    }

    protected boolean publishPageAtDocRoot(RetrievedFile rf, Folder parent, ContentItem item, String media, Host host) {
        String fileExt = PublishToFile.getFileExtension(rf.contentType);
        String html = rf.body;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("content item before getting bundle is " + item.getName() + " with id " + item.getID()));
        }
        ContentBundle bundle = (ContentBundle)item.getParent();
        Assert.exists((Object)bundle, (Class)(class$com$arsdigita$cms$ContentBundle == null ? (class$com$arsdigita$cms$ContentBundle = PublishToFile.class$("com.arsdigita.cms.ContentBundle")) : class$com$arsdigita$cms$ContentBundle));
        String sLangExt = item.getLanguage();
        s_log.debug((Object)("item language is " + sLangExt));
        sLangExt = sLangExt != null && sLangExt.length() > 0 ? "." + sLangExt : "";
        String path = Utilities.getItemLocation(bundle) + Utilities.getMediaIndicator(media) + sLangExt + fileExt;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("media is " + media));
            s_log.debug((Object)("MediaIndicator is " + Utilities.getMediaIndicator(media)));
            s_log.debug((Object)("item.getName is " + item.getName()));
            s_log.debug((Object)("item language is " + item.getLanguage()));
            s_log.debug((Object)("fileExt is " + fileExt));
            s_log.debug((Object)("path for publishPage is " + path));
        }
        LinkScanner scanner = new LinkScanner(html);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("first time t.size() is " + scanner.size()));
        }
        for (int i = 0; i < scanner.size(); ++i) {
            ContentItem target = scanner.getTarget(i);
            String targetURL = this.getTargetURL(target);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("i is " + i + "; t.getTarget(i) is " + target + "; getTargetURL is " + targetURL));
            }
            scanner.setTargetURL(i, targetURL);
        }
        PublishedFile f = PublishedFile.loadOrCreate(item, path, host);
        try {
            OutputStreamWriter out = new OutputStreamWriter(f.getOutputStream());
            scanner.transform(out);
            ((Writer)out).close();
        }
        catch (IOException ex) {
            throw new PublishToFileException("Unable to write item " + item + " to filesystem.", ex);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("t.size() is " + scanner.size()));
        }
        for (int i = 0; i < scanner.size(); ++i) {
            if (scanner.getTarget(i) == null || !this.isLocal(scanner.getTarget(i))) continue;
            Asset asset = (Asset)scanner.getTarget(i);
            String fileName = Utilities.getAssetPath(asset);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("asset filename is: " + fileName));
            }
            PublishedFile ass = PublishedFile.loadOrCreate(asset, fileName, host);
            File af = ass.getFile();
            this.writeAsset(asset, ass);
            ass.save();
        }
        f.save();
        return true;
    }

    private void writeAsset(Asset asset, PublishedFile f) {
        Assert.assertTrue((boolean)"live".equals(asset.getVersion()));
        File fsf = f.getFile();
        try {
            asset.writeToFile(fsf);
        }
        catch (IOException io) {
            throw new PublishToFileException("Failed to write asset " + asset + " to " + fsf.getPath(), io);
        }
    }

    protected String getTargetURL(ContentItem target) {
        String itemPath = null;
        if (target == null) {
            return null;
        }
        itemPath = target instanceof Asset ? Utilities.getAssetPath((Asset)target) : Utilities.getItemLocation(target);
        Assert.truth((boolean)itemPath.startsWith("/"), (String)"item path starts with /");
        DestinationStub stub = PublishToFile.getDestination(target.getSpecificObjectType());
        String stubURL = stub.getURLStub();
        if (stubURL.endsWith("/")) {
            stubURL = stubURL.substring(0, stubURL.length() - 1);
        }
        return stubURL + itemPath;
    }

    protected boolean isLocal(ContentItem asset) {
        return asset instanceof Asset;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

