/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.lifecycle.LifecycleEvent;
import com.arsdigita.cms.lifecycle.LifecycleListener;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

public class PublishLifecycleListener
implements LifecycleListener {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/lifecycle/PublishLifecycleListener.java#16 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$lifecycle$PublishLifecycleListener == null ? (class$com$arsdigita$cms$lifecycle$PublishLifecycleListener = PublishLifecycleListener.class$("com.arsdigita.cms.lifecycle.PublishLifecycleListener")) : class$com$arsdigita$cms$lifecycle$PublishLifecycleListener));
    static /* synthetic */ Class class$com$arsdigita$cms$lifecycle$PublishLifecycleListener;

    public void begin(LifecycleEvent event) {
        s_log.info((Object)("PublishLifecycleListener begin is called. \n" + event.toString() + "\n" + event.getOID().toString()));
        ContentItem item = this.getContentItem(event.getOID());
        if (Assert.isEnabled()) {
            Assert.falsity((boolean)(item instanceof ContentBundle), (String)"Content bundles cannot be published");
        }
        ContentItem master = null;
        ContentItem pending = null;
        if (item.isDraftVersion()) {
            master = item;
            pending = master.getPublicVersion();
            if (Assert.isEnabled()) {
                Assert.equal((Object)"pending", (Object)pending.getVersion());
            }
        } else {
            pending = item;
            master = pending.getDraftVersion();
            Assert.unequal((Object)master, (Object)pending);
            Assert.equal((Object)"draft", (Object)master.getVersion());
        }
        master.promotePendingVersion(pending);
    }

    public void end(LifecycleEvent event) {
        s_log.info((Object)("PublishLifecycleListener end is called. \n" + event.toString() + "\n" + event.getOID().toString()));
        ContentItem item = this.getContentItem(event.getOID());
        ContentItem master = null;
        master = item.isLiveVersion() ? item.getWorkingVersion() : item;
        if (master.isLive()) {
            master.setLive(null);
        }
    }

    private ContentItem getContentItem(OID oid) {
        ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
        return item;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

