/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;

public class PhaseDefinition
extends ACSObject {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/lifecycle/PhaseDefinition.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.PhaseDefinition";
    private static final int HOUR = 60;
    private static final int DAY = 1440;
    protected static final String LABEL = "label";
    protected static final String DESCRIPTION = "description";
    protected static final String DEFAULT_DELAY = "defaultDelay";
    protected static final String DEFAULT_DURATION = "defaultDuration";
    protected static final String DEFAULT_LISTENER = "defaultListener";
    protected static final String LIFECYCLE_DEFINITION = "lifecycleDefinition";
    private static final Integer ZERO = new Integer(0);

    protected PhaseDefinition() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public PhaseDefinition(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public PhaseDefinition(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public PhaseDefinition(DataObject obj) {
        super(obj);
    }

    protected PhaseDefinition(String type) {
        super(type);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getLabel() {
        return (String)this.get(LABEL);
    }

    public void setLabel(String label) {
        this.set(LABEL, label);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    public Integer getDefaultDelay() {
        Integer dd = (Integer)this.get(DEFAULT_DELAY);
        return dd == null ? ZERO : dd;
    }

    public void setDefaultDelay(Integer minutes) {
        this.set(DEFAULT_DELAY, minutes);
    }

    private static Integer convertToMinutes(Integer days, Integer hours, Integer minutes) {
        Integer dd = days == null ? ZERO : days;
        Integer hh = hours == null ? ZERO : hours;
        Integer mm = minutes == null ? ZERO : minutes;
        return new Integer(dd * 1440 + hh * 60 + mm);
    }

    public void setDefaultDelay(Integer days, Integer hours, Integer minutes) {
        this.setDefaultDelay(PhaseDefinition.convertToMinutes(days, hours, minutes));
    }

    public Integer getDefaultDuration() {
        return (Integer)this.get(DEFAULT_DURATION);
    }

    public void setDefaultDuration(Integer minutes) {
        this.set(DEFAULT_DURATION, minutes);
    }

    public void setDefaultDuration(Integer days, Integer hours, Integer minutes) {
        if (days == null && hours == null && minutes == null) {
            this.setDefaultDuration(null);
        } else {
            this.setDefaultDuration(PhaseDefinition.convertToMinutes(days, hours, minutes));
        }
    }

    public String getDefaultListener() {
        return (String)this.get(DEFAULT_LISTENER);
    }

    public void setDefaultListener(String listener) {
        this.set(DEFAULT_LISTENER, listener);
    }

    public LifecycleDefinition getLifecycleDefinition() {
        DataObject lcd = (DataObject)this.get(LIFECYCLE_DEFINITION);
        return lcd == null ? null : new LifecycleDefinition(lcd);
    }

    protected void setLifecycleDefinition(LifecycleDefinition lifecycleDefinition) {
        this.setAssociation(LIFECYCLE_DEFINITION, (DomainObject)lifecycleDefinition);
    }
}

