/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.UserDefinedContentItem;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.dispatcher.XMLGenerator;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectTraversal;
import com.arsdigita.domain.DomainObjectTraversalAdapter;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.domain.SimpleDomainObjectTraversalAdapter;
import com.arsdigita.metadata.DynamicObjectType;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SimpleXMLGenerator
implements XMLGenerator {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/SimpleXMLGenerator.java#19 $ by $Author: mbooth $, $DateTime: 2004/07/14 09:21:00 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$dispatcher$SimpleXMLGenerator == null ? (class$com$arsdigita$cms$dispatcher$SimpleXMLGenerator = SimpleXMLGenerator.class$("com.arsdigita.cms.dispatcher.SimpleXMLGenerator")) : class$com$arsdigita$cms$dispatcher$SimpleXMLGenerator));
    public static final String ADAPTER_CONTEXT = (class$com$arsdigita$cms$dispatcher$SimpleXMLGenerator == null ? (class$com$arsdigita$cms$dispatcher$SimpleXMLGenerator = SimpleXMLGenerator.class$("com.arsdigita.cms.dispatcher.SimpleXMLGenerator")) : class$com$arsdigita$cms$dispatcher$SimpleXMLGenerator).getName();
    static /* synthetic */ Class class$com$arsdigita$cms$dispatcher$SimpleXMLGenerator;

    public void generateXML(PageState state, Element parent, String useContext) {
        ContentSection section = CMS.getContext().getContentSection();
        ContentItem item = this.getContentItem(state);
        s_log.info((Object)("Generate XML for item " + item.getOID()));
        String className = item.getDefaultDomainClass();
        if (!item.getClass().getName().equals(className)) {
            s_log.info((Object)"Specializing item");
            try {
                item = (ContentItem)DomainObjectFactory.newInstance((OID)new OID(item.getObjectType().getQualifiedName(), (Object)item.getID()));
            }
            catch (DataObjectNotFoundException ex) {
                throw new UncheckedWrapperException((String)GlobalizationUtil.globalize("cms.dispatcher.cannot_find_domain_object").localize(), (Throwable)ex);
            }
        }
        if (item instanceof XMLGenerator) {
            s_log.info((Object)"Item implements XMLGenerator interface");
            XMLGenerator xitem = (XMLGenerator)((Object)item);
            xitem.generateXML(state, parent, useContext);
        } else if (className.equals("com.arsdigita.cms.UserDefinedContentItem")) {
            s_log.info((Object)"Item is a user defined content item");
            UserDefinedContentItem UDItem = (UserDefinedContentItem)item;
            this.generateUDItemXML(UDItem, state, parent, useContext);
        } else {
            s_log.info((Object)"Item is using DomainObjectXMLRenderer");
            Element content = this.startElement(useContext);
            DomainObjectXMLRenderer renderer = new DomainObjectXMLRenderer(content);
            renderer.setWrapAttributes(true);
            renderer.setWrapRoot(false);
            renderer.setWrapObjects(false);
            renderer.setRevisitFullObject(true);
            renderer.walk((DomainObject)item, ADAPTER_CONTEXT);
            parent.addContent(content);
        }
    }

    protected ContentItem getContentItem(PageState state) {
        if (CMS.getContext().hasContentItem()) {
            return CMS.getContext().getContentItem();
        }
        CMSPage page = (CMSPage)state.getPage();
        return page.getContentItem(state);
    }

    protected void generateUDItemXML(UserDefinedContentItem UDItem, PageState state, Element parent, String useContext) {
        Element element = this.startElement(useContext);
        Element additionalAttrs = this.UDItemElement(useContext);
        element.addAttribute("type", UDItem.getContentType().getLabel());
        element.addAttribute("id", UDItem.getID().toString());
        element.addAttribute("name", UDItem.getName());
        element.addAttribute("title", UDItem.getTitle());
        element.addAttribute("javaClass", UDItem.getContentType().getClassName());
        DynamicObjectType dot = new DynamicObjectType(UDItem.getSpecificObjectType());
        Iterator declaredProperties = dot.getObjectType().getDeclaredProperties();
        Property currentProperty = null;
        Object value = null;
        while (declaredProperties.hasNext()) {
            currentProperty = (Property)declaredProperties.next();
            value = UDItem.get(currentProperty.getName());
            if (value != null) {
                element.addContent(this.UDItemAttrElement(currentProperty.getName(), value.toString()));
                continue;
            }
            element.addContent(this.UDItemAttrElement(currentProperty.getName(), "none specified"));
        }
        parent.addContent(element);
    }

    private Element startElement(String useContext) {
        Element element = new Element("cms:item", "http://www.arsdigita.com/cms/1.0");
        if (useContext != null) {
            element.addAttribute("useContext", useContext);
        }
        return element;
    }

    private Element UDItemElement(String useContext) {
        Element element = new Element("cms:UDItemAttributes", "http://www.arsdigita.com/cms/1.0");
        return element;
    }

    private Element UDItemAttrElement(String name, String value) {
        Element element = new Element("cms:UDItemAttribute", "http://www.arsdigita.com/cms/1.0");
        element.addAttribute("UDItemAttrName", name);
        element.addAttribute("UDItemAttrValue", value);
        return element;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SimpleDomainObjectTraversalAdapter adapter = new SimpleDomainObjectTraversalAdapter();
        adapter.addAssociationProperty("/object/type");
        adapter.addAssociationProperty("/object/categories");
        DomainObjectTraversal.registerAdapter((String)"com.arsdigita.cms.ContentItem", (DomainObjectTraversalAdapter)adapter, (String)ADAPTER_CONTEXT);
    }
}

