/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.cms.CMSExcursion;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.ContentSectionDispatcher;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.ItemXML;
import com.arsdigita.cms.dispatcher.TemplateResolver;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.dispatcher.AccessDeniedException;
import com.arsdigita.dispatcher.ChainedDispatcher;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ACSObjectCache;
import com.arsdigita.kernel.User;
import com.arsdigita.versioning.Transaction;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ItemDispatcher
implements ChainedDispatcher {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$dispatcher$ItemDispatcher == null ? (class$com$arsdigita$cms$dispatcher$ItemDispatcher = ItemDispatcher.class$("com.arsdigita.cms.dispatcher.ItemDispatcher")) : class$com$arsdigita$cms$dispatcher$ItemDispatcher));
    public static Map s_itemResolverCache = Collections.synchronizedMap(new HashMap());
    public static Map s_templateResolverCache = Collections.synchronizedMap(new HashMap());
    public static final String FILE_SUFFIX = ".jsp";
    public static final String INDEX_FILE = "/index";
    public static final String TEMPLATE_ROOT = "/packages/content-section/templates";
    public static final String DEFAULT_ITEM_TEMPLATE = "/default/item.jsp";
    public static final String DEFAULT_FOLDER_TEMPLATE = "/default/folder.jsp";
    public static final String XML_SUFFIX = ".xml";
    public static final String XML_MODE = "xmlMode";
    private static boolean m_cacheItems = true;
    public static final String PREVIEW = "/preview";
    protected ItemXML m_itemXML = new ItemXML();
    static /* synthetic */ Class class$com$arsdigita$cms$dispatcher$ItemDispatcher;

    public static void setCacheItems(boolean value) {
        m_cacheItems = value;
    }

    public int chainedDispatch(final HttpServletRequest request, final HttpServletResponse response, final RequestContext actx) throws IOException, ServletException {
        int maxAge;
        Date endDate;
        String queryString = request.getQueryString();
        Transaction transaction = null;
        String url = actx.getRemainingURLPart();
        s_log.info((Object)("Resolving item URL " + url));
        if (url.endsWith(XML_SUFFIX)) {
            request.setAttribute(XML_MODE, (Object)Boolean.TRUE);
            s_log.debug((Object)"StraightXML Requested");
            url = "/" + url.substring(0, url.length() - XML_SUFFIX.length());
        } else {
            request.setAttribute(XML_MODE, (Object)Boolean.FALSE);
            if (url.endsWith(FILE_SUFFIX)) {
                url = "/" + url.substring(0, url.length() - FILE_SUFFIX.length());
            } else if (url.endsWith("/")) {
                url = "/" + url.substring(0, url.length() - 1);
            } else {
                s_log.warn((Object)"Fail: URL doesn't have right suffix.");
                return 1;
            }
        }
        final ContentSection section = ContentSectionDispatcher.getContentSection(request);
        final ContentItem item = this.getItem(section, url);
        if (item == null) {
            s_log.warn((Object)("Fail: No live item found matching " + url));
            return 1;
        }
        if (transaction != null) {
            item.rollBackTo(transaction);
        }
        ACSObjectCache.set((ServletRequest)request, (ACSObject)item);
        request.setAttribute("com.arsdigita.cms.dispatcher.item", (Object)item);
        s_log.debug((Object)("MATCHED " + item.getID()));
        Lifecycle cycle = item.getLifecycle();
        int expires = DispatcherHelper.getDefaultCacheExpiry();
        if (cycle != null && (endDate = cycle.getEndDate()) != null && (maxAge = (int)((endDate.getTime() - System.currentTimeMillis()) / 1000L)) < expires) {
            expires = maxAge;
        }
        if (m_cacheItems && !url.startsWith(PREVIEW)) {
            SecurityManager sm = new SecurityManager(section);
            if (sm.canAccess((User)null, "public_pages", item)) {
                DispatcherHelper.cacheForWorld((HttpServletResponse)response, (int)expires);
            } else {
                DispatcherHelper.cacheForUser((HttpServletResponse)response, (int)expires);
            }
        } else {
            DispatcherHelper.cacheDisable((HttpServletResponse)response);
        }
        if (((Boolean)request.getAttribute(XML_MODE)).booleanValue()) {
            this.m_itemXML.dispatch(request, response, actx);
            return 0;
        }
        final String templateURL = this.getTemplateURL(section, item, request, actx);
        s_log.debug((Object)("TEMPLATE " + templateURL));
        CMSExcursion excursion = new CMSExcursion(){

            public void excurse() throws ServletException, IOException {
                this.setContentSection(section);
                this.setContentItem(item);
                DispatcherHelper.setRequestContext((HttpServletRequest)request, (RequestContext)actx);
                DispatcherHelper.forwardRequestByPath((String)templateURL, (HttpServletRequest)request, (HttpServletResponse)response);
            }
        };
        excursion.run();
        return 0;
    }

    public ContentItem getItem(ContentSection section, String url) {
        ContentItem item;
        ItemResolver itemResolver = this.getItemResolver(section);
        SecurityManager sm = new SecurityManager(section);
        boolean hasPermission = true;
        HttpServletRequest request = DispatcherHelper.getRequest();
        boolean preview = false;
        if (url.startsWith(PREVIEW)) {
            url = url.substring(PREVIEW.length());
            preview = true;
        }
        if (preview) {
            item = itemResolver.getItem(section, url, "draft");
            if (item != null) {
                hasPermission = sm.canAccess(request, "preview_pages", item);
            }
        } else {
            item = itemResolver.getItem(section, url, "live");
            if (item != null) {
                hasPermission = sm.canAccess(request, "public_pages", item);
            }
        }
        if (item == null && url.endsWith(INDEX_FILE)) {
            url = url.substring(0, url.length() - INDEX_FILE.length());
            s_log.info((Object)("Attempting to match folder " + url));
            item = itemResolver.getItem(section, url, "live");
            if (item != null) {
                hasPermission = sm.canAccess(request, "public_pages", item);
            }
        }
        if (!hasPermission) {
            throw new AccessDeniedException();
        }
        return item;
    }

    public ItemResolver getItemResolver(ContentSection section) {
        String name = section.getName();
        ItemResolver ir = (ItemResolver)s_itemResolverCache.get(name);
        if (ir == null) {
            ir = section.getItemResolver();
            s_itemResolverCache.put(name, ir);
        }
        return ir;
    }

    public TemplateResolver getTemplateResolver(ContentSection section) {
        String name = section.getName();
        TemplateResolver ir = (TemplateResolver)s_templateResolverCache.get(name);
        if (ir == null) {
            ir = section.getTemplateResolver();
            s_templateResolverCache.put(name, ir);
        }
        return ir;
    }

    public String getTemplateURL(ContentSection section, ContentItem item, HttpServletRequest request, RequestContext actx) {
        String templateURL = this.getTemplateResolver(section).getTemplate(section, item, request);
        return templateURL;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

