/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateManager;
import com.arsdigita.cms.TemplateManagerFactory;
import com.arsdigita.cms.dispatcher.AbstractTemplateResolver;
import com.arsdigita.cms.dispatcher.TemplateResolver;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.util.Assert;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class DefaultTemplateResolver
extends AbstractTemplateResolver
implements TemplateResolver {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$dispatcher$DefaultTemplateResolver == null ? (class$com$arsdigita$cms$dispatcher$DefaultTemplateResolver = DefaultTemplateResolver.class$("com.arsdigita.cms.dispatcher.DefaultTemplateResolver")) : class$com$arsdigita$cms$dispatcher$DefaultTemplateResolver));
    static /* synthetic */ Class class$com$arsdigita$cms$dispatcher$DefaultTemplateResolver;

    public String getTemplate(ContentSection section, ContentItem item, HttpServletRequest request) {
        String template = this.getItemTemplate(section, item, request);
        MimeType mimeType = MimeType.loadMimeType((String)"text/x-jsp");
        if (template == null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"No item template, looking for content type template");
            }
            template = this.getTypeTemplate(section, item, request, mimeType);
        }
        if (template == null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"No content type template, looking for default template");
            }
            template = this.getDefaultTemplate(section, item, request);
            Assert.assertNotNull((Object)template, (String)"default template");
        }
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Got template " + template + " for item " + item.getOID()));
        }
        return ContentSection.getConfig().getTemplateRoot() + template;
    }

    public String getTemplatePath(Template template) {
        return ContentSection.getConfig().getTemplateRoot() + this.getTemplateFilename(template, template.getContentSection());
    }

    public String getTemplateXSLPath(Template template) {
        return ContentSection.getConfig().getTemplateRoot() + this.getTemplateXSLFilename(template, template.getContentSection());
    }

    protected String getItemTemplate(ContentSection section, ContentItem item, HttpServletRequest request) {
        String context;
        TemplateManager manager = TemplateManagerFactory.getInstance();
        Template template = manager.getTemplate(item, context = this.getTemplateContext(request));
        return template == null ? null : this.getTemplateFilename(template, section);
    }

    protected String getTypeTemplate(ContentSection section, ContentItem item, HttpServletRequest request) {
        MimeType mimeType = MimeType.loadMimeType((String)"text/x-jsp");
        return this.getTypeTemplate(section, item, request, mimeType);
    }

    protected String getTypeTemplate(ContentSection section, ContentItem item, HttpServletRequest request, MimeType mimeType) {
        TemplateManager manager = TemplateManagerFactory.getInstance();
        ContentType type = item.getContentType();
        Template template = null;
        if (type != null) {
            String context = this.getTemplateContext(request);
            template = manager.getDefaultTemplate(section, type, context, mimeType);
        } else if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Item has no content type, not looking for a content type specific template");
        }
        return template == null ? null : this.getTemplateFilename(template, section);
    }

    protected String getDefaultTemplate(ContentSection section, ContentItem item, HttpServletRequest request) {
        String path = item instanceof Folder ? ContentSection.getConfig().getDefaultFolderTemplatePath() : ContentSection.getConfig().getDefaultItemTemplatePath();
        return path;
    }

    protected String getTemplateFilename(Template template, ContentSection section, ContentItem item, HttpServletRequest request) {
        return this.getTemplateFilename(template, section);
    }

    protected String getTemplateXSLFilename(Template template, ContentSection section, ContentItem item, HttpServletRequest request) {
        return this.getTemplateXSLFilename(template, section);
    }

    protected String getTemplateFilename(Template template, ContentSection section) {
        String templateName = template.getPath();
        String sectionURL = section.getPath();
        return sectionURL + "/" + templateName;
    }

    protected String getTemplateXSLFilename(Template template, ContentSection section) {
        String templateName = template.getPathNoJsp() + ".xsl";
        String sectionURL = section.getPath();
        return sectionURL + "/" + templateName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

