/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.web.URL;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class Link
extends ACSObject {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$contenttypes$Link == null ? (class$com$arsdigita$cms$contenttypes$Link = Link.class$("com.arsdigita.cms.contenttypes.Link")) : class$com$arsdigita$cms$contenttypes$Link));
    public static final String TITLE = "linkTitle";
    public static final String TARGET_TYPE = "targetType";
    public static final String EXTERNAL_LINK = "externalLink";
    public static final String INTERNAL_LINK = "internalLink";
    public static final String TARGET_URI = "targetURI";
    public static final String TARGET_ITEM = "targetItem";
    public static final String TARGET_WINDOW = "targetWindow";
    public static final String DESCRIPTION = "linkDescription";
    public static final String ORDER = "linkOrder";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.Link";
    static /* synthetic */ Class class$com$arsdigita$cms$contenttypes$Link;

    public Link() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Link(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Link(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public Link(DataObject obj) {
        super(obj);
    }

    public Link(String type) {
        super(type);
    }

    public String getTitle() {
        return (String)this.get(TITLE);
    }

    public void setTitle(String title) {
        this.set(TITLE, title);
    }

    public String getTargetType() {
        return (String)this.get(TARGET_TYPE);
    }

    public void setTargetType(String type) {
        Assert.assertTrue((type != null && (type.equals(EXTERNAL_LINK) || type.equals(INTERNAL_LINK)) ? 1 : 0) != 0);
        this.set(TARGET_TYPE, type);
    }

    public String getTargetURI() {
        return (String)this.get(TARGET_URI);
    }

    public void setTargetURI(String uri) {
        this.set(TARGET_URI, uri);
    }

    public ContentItem getTargetItem() {
        DataObject object = (DataObject)this.get(TARGET_ITEM);
        return (ContentItem)DomainObjectFactory.newInstance((DataObject)object);
    }

    public void setTargetItem(ContentItem item) {
        this.setAssociation(TARGET_ITEM, (DomainObject)item);
    }

    public String getTargetWindow() {
        return (String)this.get(TARGET_WINDOW);
    }

    public void setTargetWindow(String window) {
        this.set(TARGET_WINDOW, window);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    public Integer getOrder() {
        return (Integer)this.get(ORDER);
    }

    public void setOrder(Integer order) {
        Assert.assertNotNull((Object)order);
        this.set(ORDER, order);
    }

    public void setOrder(int order) {
        this.setOrder(new Integer(order));
    }

    public String getInternalOrExternalURI(PageState state) {
        if (EXTERNAL_LINK.equals(this.getTargetType())) {
            return this.getTargetURI();
        }
        ContentItem item = this.getTargetItem();
        if (item == null) {
            s_log.error((Object)(this.getOID() + " is internal link, but has null target item"));
            return "";
        }
        ContentSection section = item.getContentSection();
        ItemResolver resolver = section.getItemResolver();
        String url = resolver.generateItemURL(state, item, section, item.getVersion());
        return URL.there((HttpServletRequest)state.getRequest(), (String)url).toString();
    }

    public static DataCollection getReferringLinks(ContentItem item) {
        Session session = SessionManager.getSession();
        DataCollection links = session.retrieve(BASE_DATA_OBJECT_TYPE);
        Filter filter = links.addInSubqueryFilter("id", "com.arsdigita.cms.contenttypes.getReferringLinks");
        filter.set("itemID", (Object)item.getID());
        return links;
    }

    public void swapWithNext() {
        throw new UnsupportedOperationException("Not implemented on base Link class. Subclass Link to support this for a specific role");
    }

    public void swapWithPrevious() {
        throw new UnsupportedOperationException("Not implemented on base Link class. Subclass Link to support this for a specific role");
    }

    public void swapWithNext(String queryName, String operationName) {
        this.swapKeys(true, queryName, operationName);
    }

    public void swapWithPrevious(String queryName, String operationName) {
        this.swapKeys(false, queryName, operationName);
    }

    protected DataQuery getSwapQuery(String queryName) {
        return SessionManager.getSession().retrieveQuery(queryName);
    }

    protected DataOperation getSwapOperation(String operationName) {
        DataOperation operation = SessionManager.getSession().retrieveDataOperation(operationName);
        return operation;
    }

    protected void swapKeys(boolean swapNext, String queryName, String operationName) {
        String methodName = null;
        methodName = swapNext ? "swapWithNext" : "swapWithPrevious";
        Assert.assertTrue((!this.isNew() ? 1 : 0) != 0, (String)(methodName + " cannot be called on an " + "object that is new"));
        Integer currentKey = (Integer)this.get(ORDER);
        if (currentKey == null) {
            this.alphabetize();
            return;
        }
        Assert.assertTrue((currentKey != null ? 1 : 0) != 0, (String)(methodName + " cannot be " + "called on an object that is not currently in the " + "list"));
        int key = currentKey;
        DataQuery query = this.getSwapQuery(queryName);
        int otherKey = key;
        if (swapNext) {
            otherKey = key + 1;
            query.addFilter(query.getFilterFactory().greaterThan(ORDER, (Object)currentKey, true));
        } else {
            otherKey = key - 1;
            query.addFilter(query.getFilterFactory().lessThan(ORDER, (Object)currentKey, true));
        }
        if (query.next()) {
            otherKey = (Integer)query.get(ORDER);
            query.close();
        }
        DataOperation operation = this.getSwapOperation(operationName);
        operation.setParameter(ORDER, (Object)new Integer(key));
        operation.setParameter("nextLinkOrder", (Object)new Integer(otherKey));
        operation.execute();
    }

    protected void alphabetize() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

