/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.contenttypes.ContentGroup;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;

public class ContentGroupAssociation
extends ContentItem {
    protected static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/contenttypes/ContentGroupAssociation.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.ContentGroupAssociation";
    public static final String CONTENT_ITEM = "contentItem";
    public static final String CONTENT_GROUP = "contentGroup";
    public static final String SORT_KEY = "sortKey";

    public ContentGroupAssociation() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public ContentGroupAssociation(String type) {
        super(type);
    }

    public ContentGroupAssociation(ContentItem item, ContentGroup group) {
        this(BASE_DATA_OBJECT_TYPE);
        this.setContentItem(item);
        this.setContentGroup(group);
    }

    public ContentGroupAssociation(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ContentGroupAssociation(DataObject obj) {
        super(obj);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public void setContentItem(ContentItem item) {
        this.set(CONTENT_ITEM, item);
    }

    protected void setContentGroup(ContentGroup group) {
        Assert.assertTrue((group != null ? 1 : 0) != 0, (String)"The ContentGroup must not be null");
        this.set(CONTENT_GROUP, group);
    }

    protected ContentItem getContentItem() {
        return (ContentItem)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(CONTENT_ITEM)));
    }

    protected ContentGroup getContentGroup() {
        return (ContentGroup)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(CONTENT_GROUP)));
    }

    protected Integer getSortKey() {
        return (Integer)this.get(SORT_KEY);
    }

    protected void setSortKey(Integer key) {
        this.set(SORT_KEY, key);
    }

    protected void swapWithNext() {
        this.swapKeys(true, "com.arsdigita.cms.contenttypes.minItemSortKeyInGroup");
    }

    protected void swapWithPrevious() {
        this.swapKeys(false, "com.arsdigita.cms.contenttypes.maxItemSortKeyInGroup");
    }

    private void swapKeys(boolean swapNext, String queryName) {
        String methodName = null;
        methodName = swapNext ? "swapWithNext" : "swapWithPrevious";
        Assert.assertTrue((!this.isNew() ? 1 : 0) != 0, (String)(methodName + " cannot be called on an " + "object that is new"));
        Integer currentKey = (Integer)this.get(SORT_KEY);
        Assert.assertTrue((currentKey != null ? 1 : 0) != 0, (String)(methodName + " cannot be " + "called on an object that is not currently in the " + "list"));
        int key = currentKey;
        DataQuery query = SessionManager.getSession().retrieveQuery(queryName);
        query.setParameter("groupID", (Object)this.getContentGroup().getID());
        int otherKey = key;
        if (swapNext) {
            otherKey = key + 1;
            query.addFilter(query.getFilterFactory().greaterThan(SORT_KEY, (Object)currentKey, true));
        } else {
            otherKey = key - 1;
            query.addFilter(query.getFilterFactory().lessThan(SORT_KEY, (Object)currentKey, true));
        }
        if (query.next()) {
            otherKey = (Integer)query.get(SORT_KEY);
            query.close();
        }
        DataOperation operation = SessionManager.getSession().retrieveDataOperation("com.arsdigita.cms.contenttypes.swapItemWithNextInGroup");
        operation.setParameter(SORT_KEY, (Object)new Integer(key));
        operation.setParameter("nextSortKey", (Object)new Integer(otherKey));
        operation.setParameter("groupID", (Object)this.getContentGroup().getID());
        operation.execute();
    }

    protected void beforeSave() {
        super.beforeSave();
        if (this.getSortKey() == null) {
            this.setSortKey(new Integer(0));
        }
    }
}

