/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class Template
extends TextAsset {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/Template.java#19 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$Template == null ? (class$com$arsdigita$cms$Template = Template.class$("com.arsdigita.cms.Template")) : class$com$arsdigita$cms$Template));
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.Template";
    public static final String LABEL = "label";
    public static final String IS_PUBLISHABLE = "isPublishable";
    public static final String JSP_MIME_TYPE = "text/x-jsp";
    public static final String XSL_MIME_TYPE = "text/xml";
    public static final Map SUPPORTED_MIME_TYPES = new HashMap();
    static /* synthetic */ Class class$com$arsdigita$cms$Template;

    public Template() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Template(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Template(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Template(DataObject obj) {
        super(obj);
    }

    public Template(String type) {
        super(type);
        MimeType mime = MimeType.loadMimeType((String)JSP_MIME_TYPE);
        this.setMimeType(mime);
        ContentType t = null;
        t = ContentType.findByAssociatedObjectType(BASE_DATA_OBJECT_TYPE);
        this.setContentType(t);
    }

    public void initialize() {
        super.initialize();
        if (this.get(IS_PUBLISHABLE) == null) {
            this.setPublishable(true);
        }
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getLabel() {
        return (String)this.get(LABEL);
    }

    public void setLabel(String label) {
        this.set(LABEL, label);
    }

    public String getDisplayName() {
        String result = this.getLabel();
        return result != null ? result : super.getDisplayName();
    }

    public Boolean isPublishable() {
        return (Boolean)this.get(IS_PUBLISHABLE);
    }

    public void setPublishable(Boolean isPublishable) {
        this.set(IS_PUBLISHABLE, isPublishable);
    }

    public void setPublishable(boolean isPublishable) {
        this.set(IS_PUBLISHABLE, new Boolean(isPublishable));
    }

    public String getPath() {
        String path = this.getPathNoJsp();
        if (!path.endsWith(".jsp")) {
            path = path + ".jsp";
        }
        return path;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SUPPORTED_MIME_TYPES.put(JSP_MIME_TYPE, GlobalizationUtil.globalize("mime_type_jsp"));
        SUPPORTED_MIME_TYPES.put(XSL_MIME_TYPE, GlobalizationUtil.globalize("mime_type_xsl"));
    }
}

