/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class ContentPage
extends ContentItem {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ContentPage.java#38 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ContentPage == null ? (class$com$arsdigita$cms$ContentPage = ContentPage.class$("com.arsdigita.cms.ContentPage")) : class$com$arsdigita$cms$ContentPage));
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.ContentPage";
    public static final String TITLE = "title";
    public static final String SUMMARY = "summary";
    public static final String LAUNCH_DATE = "launchDate";
    protected static final String PAGES_IN_FOLDER = "com.arsdigita.cms.pagesInFolder";
    protected static final String PAGES_IN_CATEGORY = "com.arsdigita.cms.pagesInFolderByCategory";
    public static final String QUERY_PAGE = "page";
    public static final String QUERY_TYPE = "type";
    public static final String QUERY_ROOT_ID = "rootFolderID";
    public static final String QUERY_CATEGORY_ID = "categoryID";
    private String m_newName = null;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentPage;

    public ContentPage() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public ContentPage(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ContentPage(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public ContentPage(DataObject obj) {
        super(obj);
    }

    public ContentPage(String type) {
        super(type);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getDisplayName() {
        String result = this.getTitle();
        if (result == null) {
            return super.getDisplayName();
        }
        return result;
    }

    public void setName(String name) {
        super.setName(name);
        ContentBundle bundle = this.getContentBundle();
        if (bundle != null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)(this + " is inside a bundle; setting the " + "bundle's name to " + name + " as well"));
            }
            bundle.setName(name);
            bundle.save();
        }
    }

    public final ContentBundle getContentBundle() {
        ACSObject parent = this.getParent();
        if (parent instanceof ContentBundle) {
            return (ContentBundle)parent;
        }
        return null;
    }

    public String getTitle() {
        return (String)this.get(TITLE);
    }

    public void setTitle(String value) {
        this.set(TITLE, value);
    }

    public Date getLaunchDate() {
        return (Date)this.get(LAUNCH_DATE);
    }

    public void setLaunchDate(Date ldate) {
        this.set(LAUNCH_DATE, ldate);
    }

    protected static DataQuery setPagesQueryParameters(String name, ContentSection s, String context) {
        Folder root;
        DataQuery q = SessionManager.getSession().retrieveQuery(name);
        Folder f = s.getRootFolder();
        if ("live".equals(context)) {
            root = (Folder)f.getLiveVersion();
            if (root == null) {
                root = f;
            }
        } else {
            root = f;
        }
        q.setParameter(QUERY_ROOT_ID, (Object)root.getID());
        q.setParameter("version", (Object)context);
        return q;
    }

    protected static DataQuery setPagesQueryParameters(String name, ContentSection s, String context, OID userOID) {
        DataQuery q = ContentPage.setPagesQueryParameters(name, s, context);
        FilterFactory ff = q.getFilterFactory();
        PrivilegeDescriptor pd = PrivilegeDescriptor.get((String)"cms_read_item");
        Filter f = PermissionService.getFilterQuery((FilterFactory)ff, (String)"page.id", (PrivilegeDescriptor)pd, (OID)userOID);
        q.addFilter(f);
        return q;
    }

    public static DataQuery getPagesInSectionQuery(ContentSection s, String context, Category cat) {
        DataQuery q = ContentPage.setPagesQueryParameters(PAGES_IN_CATEGORY, s, context);
        q.setParameter(QUERY_CATEGORY_ID, (Object)cat.getID());
        return q;
    }

    public static DataQuery getPagesInSectionQuery(ContentSection s, String context, Category cat, OID userOID) {
        DataQuery q = ContentPage.setPagesQueryParameters(PAGES_IN_CATEGORY, s, context, userOID);
        q.setParameter(QUERY_CATEGORY_ID, (Object)cat.getID());
        return q;
    }

    public static DataQuery getPagesInSectionQuery(ContentSection s, String context) {
        return ContentPage.setPagesQueryParameters(PAGES_IN_FOLDER, s, context);
    }

    public static DataQuery getPagesInSectionQuery(ContentSection s, String context, OID userOID) {
        return ContentPage.setPagesQueryParameters(PAGES_IN_FOLDER, s, context, userOID);
    }

    public String getSearchSummary() {
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

