/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.workflow;

import com.arsdigita.cms.ui.ContentItemPage;

import java.math.BigDecimal;

/**
 * Interface for generating a URL for a Task given the ID of the
 * ContentItem and the Task.
 *
 * @author Uday Mathur (umathur@arsdigita.com)
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 * */

public class PreviewTaskURLGenerator extends FinishTaskURLGenerator {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/workflow/PreviewTaskURLGenerator.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public PreviewTaskURLGenerator() {}
    public String generateURL(BigDecimal itemId, BigDecimal taskId) {
        return ContentItemPage.getItemURL(itemId, ContentItemPage.AUTHORING_TAB);
    }
}
