/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.kernel.Party;
import com.arsdigita.toolbox.ui.SecurityContainer;


public class WorkflowPublishableContainer extends SecurityContainer {
    ItemSelectionModel m_itemModel;
    public WorkflowPublishableContainer(ItemSelectionModel m) {
        super();
    }

    public WorkflowPublishableContainer(Component c, ItemSelectionModel m) {
        super(c);
        m_itemModel = m;
    }

    public void setItemModel(ItemSelectionModel m) {
        m_itemModel = m;
    }

    protected boolean canAccess(Party party, PageState state) {
        SecurityManager sm = Utilities.getSecurityManager(state);
        return sm.canAccess(state.getRequest(),
                            SecurityManager.SCHEDULE_PUBLICATION,
                            (ContentItem)m_itemModel.getSelectedObject(state));
    }
}
