/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.AbstractListModelBuilder;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import org.apache.log4j.Logger;

/**
 * Builds a list of workflow templates registered to the current
 * content section.
 *
 * @author Michael Pih
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/WorkflowListModelBuilder.java#6 $
 */
class WorkflowListModelBuilder extends AbstractListModelBuilder {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/WorkflowListModelBuilder.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (AssignedTaskTableModelBuilder.class);

    public final ListModel makeModel(final List list, final PageState state) {
        return new Model();
    }

    private class Model implements ListModel {
        private final TaskCollection m_templates;

        public Model() {
            final ContentSection section =
                CMS.getContext().getContentSection();

            m_templates = section.getWorkflowTemplates();
            m_templates.addOrder("label");
        }

        public boolean next() {
            return m_templates.next();
        }

        public Object getElement() {
            return ((WorkflowTemplate) m_templates.getDomainObject())
                .getLabel();
        }

        public String getKey() {
            WorkflowTemplate template =
                (WorkflowTemplate) m_templates.getDomainObject();

            return template.getID().toString();
        }
    }
}
